/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class OpenFirebaseAssistantQuickFix
extends DefaultLintQuickFix {
    public OpenFirebaseAssistantQuickFix() {
        super(AndroidLintBundle.message("android.lint.fix.open.firebase.assistant", new Object[0]));
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> {
            AnAction openFirebaseAssistant = ActionManager.getInstance().getAction("DeveloperServices.Firebase");
            if (openFirebaseAssistant == null) {
                ApplicationManager.getApplication().invokeLater(this::reportFirebaseNotAvailable);
                return;
            }
            AnActionEvent openFirebaseAssistantEvent = AnActionEvent.createEvent((AnAction)openFirebaseAssistant, (DataContext)dataContext, null, (String)"Android Lint QuickFix", (ActionUiKind)ActionUiKind.NONE, null);
            openFirebaseAssistant.actionPerformed(openFirebaseAssistantEvent);
        });
    }

    private void reportFirebaseNotAvailable() {
        String message = String.format("<html>Firebase Assistant is not available. The Firebase Services plugin has to be enabled in the <a href=\"plugins\">Plugins</a> dialog in %1$s.</html>", ShowSettingsUtil.getSettingsMenuName());
        NotificationListener listener2 = (notification, event) -> {
            ShowSettingsUtil.getInstance().showSettingsDialog(null, PluginManagerConfigurable.class);
            notification.expire();
        };
        Notification notification2 = AndroidNotification.BALLOON_GROUP.createNotification(this.getName(), message, NotificationType.WARNING).setListener(listener2);
        notification2.notify(null);
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return startElement.getText().startsWith("'com.google.android.gms:play-services:");
    }
}

