/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AnnotateQuickFixKt;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.quickFixes.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ExtensionSdk;
import com.android.tools.lint.detector.api.VersionChecks;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u001f\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0002H\u0014J!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0094\u0002J\r\u0010\u0017\u001a\u00070\r\u00a2\u0006\u0002\b\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J@\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0007H\u0002J0\u0010&\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J8\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0018\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\"H\u0002J(\u0010/\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00022\u0006\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0002J\f\u00103\u001a\u00020\u0007*\u00020\u0002H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/idea/lint/quickFixes/AddTargetApiQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/intellij/psi/PsiElement;", "requirements", "", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "requiresApi", "", "element", "requireClass", "<init>", "(Ljava/util/List;ZLcom/intellij/psi/PsiElement;Z)V", "getName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "Lorg/jetbrains/annotations/NotNull;", "context", "Lcom/intellij/modcommand/ActionContext;", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "handleXml", "startElement", "handleJava", "addAnnotationsJava", "elementFactory", "Lcom/intellij/psi/PsiElementFactory;", "container", "Lcom/intellij/psi/PsiModifierListOwner;", "sdkId", "", "api", "minor", "replace", "addAnnotationJava", "fqcn", "annotationText", "handleKotlin", "addAnnotationsKotlin", "annotationContainer", "getSdkId", "project", "Lcom/intellij/openapi/project/Project;", "addAnnotationKotlin", "fqn", "inner", "getAnnotationContainer", "isTargetApiAnnotationValidTarget", "intellij.android.lint"})
@SourceDebugExtension(value={"SMAP\nAddTargetApiQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddTargetApiQuickFix.kt\ncom/android/tools/idea/lint/quickFixes/AddTargetApiQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n1761#2,3:330\n1#3:333\n*S KotlinDebug\n*F\n+ 1 AddTargetApiQuickFix.kt\ncom/android/tools/idea/lint/quickFixes/AddTargetApiQuickFix\n*L\n90#1:330,3\n*E\n"})
public final class AddTargetApiQuickFix
extends PsiUpdateModCommandAction<PsiElement> {
    @NotNull
    private final List<ApiConstraint.SdkApiConstraint> requirements;
    private final boolean requiresApi;
    private final boolean requireClass;

    public AddTargetApiQuickFix(@NotNull List<ApiConstraint.SdkApiConstraint> requirements, boolean requiresApi, @NotNull PsiElement element, boolean requireClass) {
        Intrinsics.checkNotNullParameter(requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
        this.requirements = requirements;
        this.requiresApi = requiresApi;
        this.requireClass = requireClass;
    }

    public /* synthetic */ AddTargetApiQuickFix(List list, boolean bl, PsiElement psiElement, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(list, bl, psiElement, bl2);
    }

    private final String getName(PsiElement element) {
        String string;
        ApiConstraint.SdkApiConstraint first = (ApiConstraint.SdkApiConstraint)CollectionsKt.first(this.requirements);
        if (Intrinsics.areEqual((Object)element.getLanguage(), (Object)XMLLanguage.INSTANCE)) {
            string = "Suppress with tools:targetApi attribute";
        } else if (!this.requiresApi) {
            Object[] objectArray = new Object[]{AddTargetVersionCheckQuickFix.Companion.getVersionField(first.min(), false)};
            string = AndroidLintBundle.Companion.message("android.lint.fix.add.target.api", objectArray);
        } else if (this.requirements.size() > 1) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = this.requirements;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ApiConstraint.SdkApiConstraint it = (ApiConstraint.SdkApiConstraint)element$iv;
                        boolean bl2 = false;
                        if (!(it.getSdkId() == 0)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            string = bl ? AndroidLintBundle.Companion.message("android.lint.fix.add.both.annotations", new Object[0]) : AndroidLintBundle.Companion.message("android.lint.fix.add.sdk.annotation", new Object[0]);
        } else if (this.requiresApi && first.getSdkId() != 0) {
            String fieldName = ExtensionSdk.Companion.getSdkExtensionField(first.getSdkId(), false);
            Object[] objectArray = new Object[]{fieldName, first.minString()};
            string = AndroidLintBundle.Companion.message("android.lint.fix.add.requires.sdk.extension", objectArray);
        } else {
            Object[] objectArray = new Object[]{AddTargetVersionCheckQuickFix.Companion.getVersionField$default(AddTargetVersionCheckQuickFix.Companion, first.fromInclusive(), first.fromInclusiveMinor(), false, false, false, 16, null)};
            string = AndroidLintBundle.Companion.message("android.lint.fix.add.requires.api", objectArray);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = this.getAnnotationContainer(element);
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            presentation = Presentation.of((String)this.getName(element));
        } else {
            presentation = null;
        }
        return presentation;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Language language = element.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            this.handleJava(element);
        } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            this.handleKotlin(element);
        } else if (Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE)) {
            this.handleXml(element);
        }
    }

    @NotNull
    public String getFamilyName() {
        return "AddTargetApi";
    }

    private final void handleXml(PsiElement startElement) {
        PsiElement psiElement = this.getAnnotationContainer(startElement);
        XmlTag xmlTag = psiElement instanceof XmlTag ? (XmlTag)psiElement : null;
        if (xmlTag == null) {
            return;
        }
        XmlTag element = xmlTag;
        XmlFile file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), XmlFile.class, (boolean)false);
        if (file != null) {
            IdeResourcesUtil.ensureNamespaceImported$default(file, "http://schemas.android.com/tools", null, 4, null);
            ApiConstraint.SdkApiConstraint first = (ApiConstraint.SdkApiConstraint)CollectionsKt.first(this.requirements);
            String value2 = first.minString();
            element.setAttribute("targetApi", "http://schemas.android.com/tools", value2);
        }
    }

    private final void handleJava(PsiElement startElement) {
        PsiElement psiElement = this.getAnnotationContainer(startElement);
        PsiModifierListOwner psiModifierListOwner = psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null;
        if (psiModifierListOwner == null) {
            return;
        }
        PsiModifierListOwner container = psiModifierListOwner;
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList != null) {
            Project project = startElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
            PsiElementFactory factory2 = psiElementFactory;
            for (ApiConstraint.SdkApiConstraint requirement : CollectionsKt.reversed((Iterable)this.requirements)) {
                this.addAnnotationsJava(factory2, container, this.requiresApi, requirement.getSdkId(), requirement.fromInclusive(), requirement.fromInclusiveMinor(), requirement.getSdkId() == 0);
            }
        }
    }

    private final void addAnnotationsJava(PsiElementFactory elementFactory, PsiModifierListOwner container, boolean requiresApi, int sdkId, int api, int minor, boolean replace) {
        String fqcn = null;
        String annotationText = null;
        if (requiresApi && sdkId == 0) {
            String string = VersionChecks.REQUIRES_API_ANNOTATION.newName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newName(...)");
            fqcn = string;
            annotationText = "@" + fqcn + "(api=" + AddTargetVersionCheckQuickFix.Companion.getVersionField$default(AddTargetVersionCheckQuickFix.Companion, api, minor, true, false, false, 16, null) + ")";
        } else if (requiresApi) {
            fqcn = "androidx.annotation.RequiresExtension";
            Project project = container.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            annotationText = "@" + fqcn + "(extension=" + this.getSdkId(project, sdkId) + ", version=" + api + ")";
        } else {
            fqcn = "android.annotation.TargetApi";
            annotationText = "@" + fqcn + "(" + AddTargetVersionCheckQuickFix.Companion.getVersionField(api, true) + ")";
        }
        this.addAnnotationJava(elementFactory, container, fqcn, annotationText, replace);
    }

    private final void addAnnotationJava(PsiElementFactory elementFactory, PsiModifierListOwner container, String fqcn, String annotationText, boolean replace) {
        block4: {
            PsiAnnotation newAnnotation;
            block5: {
                String[] stringArray;
                block3: {
                    PsiAnnotation annotation;
                    PsiAnnotation psiAnnotation = elementFactory.createAnnotationFromText(annotationText, (PsiElement)container);
                    Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"createAnnotationFromText(...)");
                    newAnnotation = psiAnnotation;
                    if (replace) {
                        stringArray = new String[]{fqcn};
                        v1 = AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])stringArray);
                    } else {
                        v1 = annotation = null;
                    }
                    if (annotation == null || annotation instanceof SyntheticElement) break block3;
                    annotation.replace((PsiElement)newAnnotation);
                    break block4;
                }
                if (replace || AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])(stringArray = new String[]{fqcn})) == null) break block5;
                PsiModifierList owner = container.getModifierList();
                PsiAnnotation inserted = AddAnnotationPsiFix.addPhysicalAnnotationTo((String)fqcn, (PsiNameValuePair[])newAnnotation.getParameterList().getAttributes(), (PsiAnnotationOwner)((PsiAnnotationOwner)owner));
                if (inserted == null) break block4;
                JavaCodeStyleManager.getInstance((Project)inserted.getProject()).shortenClassReferences((PsiElement)inserted);
                break block4;
            }
            PsiNameValuePair[] psiNameValuePairArray = newAnnotation.getParameterList().getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePairArray, (String)"getAttributes(...)");
            PsiNameValuePair[] attributes = psiNameValuePairArray;
            PsiModifierList psiModifierList = container.getModifierList();
            if (psiModifierList == null) {
                return;
            }
            PsiModifierList containerModifierList = psiModifierList;
            PsiAnnotation psiAnnotation = AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent((String)fqcn, (PsiNameValuePair[])attributes, (PsiAnnotationOwner)((PsiAnnotationOwner)containerModifierList));
            if (psiAnnotation == null) break block4;
            PsiAnnotation it = psiAnnotation;
            boolean bl = false;
            JavaCodeStyleManager.getInstance((Project)container.getProject()).shortenClassReferences((PsiElement)it);
        }
    }

    private final void handleKotlin(PsiElement startElement) {
        PsiElement psiElement = this.getAnnotationContainer(startElement);
        if (psiElement == null) {
            return;
        }
        PsiElement annotationContainer = psiElement;
        for (ApiConstraint.SdkApiConstraint requirement : CollectionsKt.reversed((Iterable)this.requirements)) {
            this.addAnnotationsKotlin(annotationContainer, this.requiresApi, requirement.getSdkId(), requirement.fromInclusive(), requirement.fromInclusiveMinor(), requirement.getSdkId() == 0);
        }
    }

    private final void addAnnotationsKotlin(PsiElement annotationContainer, boolean requiresApi, int sdkId, int api, int minor, boolean replace) {
        Object object;
        String fqn;
        String string = requiresApi && sdkId != 0 ? "androidx.annotation.RequiresExtension" : (fqn = requiresApi ? VersionChecks.REQUIRES_API_ANNOTATION.newName() : "android.annotation.TargetApi");
        if (requiresApi && sdkId != 0) {
            Project project = annotationContainer.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            object = "extension=" + this.getSdkId(project, sdkId) + ", version=" + api;
        } else {
            object = AddTargetVersionCheckQuickFix.Companion.getVersionField$default(AddTargetVersionCheckQuickFix.Companion, api, minor, true, false, false, 16, null);
        }
        String inner = object;
        Intrinsics.checkNotNull((Object)fqn);
        this.addAnnotationKotlin(annotationContainer, fqn, inner, replace);
    }

    private final String getSdkId(Project project, int sdkId) {
        ApiLookup lookup2 = LintIdeClient.getApiLookup((Project)project);
        String string = ApiLookup.getSdkExtensionField((ApiLookup)lookup2, (int)sdkId, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSdkExtensionField(...)");
        return string;
    }

    private final void addAnnotationKotlin(PsiElement annotationContainer, String fqn, String inner, boolean replace) {
        if (annotationContainer instanceof KtModifierListOwner) {
            String whiteSpaceText = AnnotateQuickFixKt.isNewLineNeededForAnnotation((KtElement)((KtElement)annotationContainer)) ? "\n" : " ";
            AnnotationModificationUtilsKt.addAnnotation$default((KtModifierListOwner)((KtModifierListOwner)annotationContainer), (ClassId)ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)ClassContext.Companion.getInternalName(fqn), (boolean)false, (int)2, null), (String)inner, null, (boolean)replace, (String)whiteSpaceText, null, (int)32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement getAnnotationContainer(PsiElement element) {
        Object object;
        Language language = element.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            void var3_3;
            Class[] classArray;
            PsiModifierListOwner container = null;
            if (this.requireClass) {
                classArray = new Class[]{PsiClass.class};
                v0 = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classArray);
            } else {
                classArray = new Class[]{PsiMethod.class, PsiClass.class};
                v0 = container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classArray);
            }
            while (container != null && container instanceof PsiAnonymousClass) {
                classArray = new Class[]{PsiClass.class};
                container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)container), PsiMethod.class, (boolean)true, (Class[])classArray);
            }
            object = (PsiElement)var3_3;
        } else {
            object = Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE) ? PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false) : (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? PsiTreeUtil.findFirstParent((PsiElement)element, arg_0 -> AddTargetApiQuickFix.getAnnotationContainer$lambda$4(arg_0 -> AddTargetApiQuickFix.getAnnotationContainer$lambda$3(this, arg_0), arg_0)) : null);
        }
        return object;
    }

    private final boolean isTargetApiAnnotationValidTarget(PsiElement $this$isTargetApiAnnotationValidTarget) {
        return $this$isTargetApiAnnotationValidTarget instanceof KtClassOrObject || $this$isTargetApiAnnotationValidTarget instanceof KtFunction && !($this$isTargetApiAnnotationValidTarget instanceof KtFunctionLiteral) || $this$isTargetApiAnnotationValidTarget instanceof KtPropertyAccessor;
    }

    private static final boolean getAnnotationContainer$lambda$3(AddTargetApiQuickFix this$0, PsiElement it) {
        boolean bl;
        if (this$0.requiresApi) {
            Intrinsics.checkNotNull((Object)it);
            bl = AnnotateQuickFixKt.isAnnotationTarget((PsiElement)it);
        } else {
            Intrinsics.checkNotNull((Object)it);
            bl = this$0.isTargetApiAnnotationValidTarget(it);
        }
        return bl;
    }

    private static final boolean getAnnotationContainer$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

