/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.SetAttributeQuickFix;
import com.android.tools.idea.lint.quickFixes.UnusedResourcesQuickFix;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class AndroidLintUnusedResourcesInspection
extends AndroidLintInspectionBase {
    public AndroidLintUnusedResourcesInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.unused.resources", new Object[0]), UnusedResourceDetector.ISSUE);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Incident incident) {
        LintFix fixData = incident.getFix();
        String resource = LintFix.getString((LintFix)fixData, (String)"field", null);
        if (resource != null) {
            String resourceUrl = "@" + resource.substring(2).replace('.', '/');
            return new LintIdeQuickFix[]{new UnusedResourcesQuickFix(null), new UnusedResourcesQuickFix(resource), new SetAttributeQuickFix(this, "Add a tools:keep attribute to mark as implicitly used", null, "keep", "http://schemas.android.com/tools", resourceUrl){

                public boolean startInWriteAction() {
                    return false;
                }

                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    WriteCommandAction.runWriteCommandAction((Project)startElement.getProject(), (String)this.getName(), null, () -> super.apply(startElement, endElement, context), (PsiFile[])new PsiFile[]{startElement.getContainingFile()});
                }
            }};
        }
        return new LintIdeQuickFix[]{new UnusedResourcesQuickFix(null)};
    }
}

