/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.repository.WellKnownMavenArtifactId;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.model.IdeMultiVariantData;
import com.android.tools.idea.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.GradleAndroidDependencyModel;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeProject;
import com.android.tools.idea.lint.model.LintModelFactory;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.DependencyScopeType;
import com.android.tools.idea.projectsystem.ProjectSyncModificationTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleModuleSystem;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.LintModelModuleProject;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelAndroidLibrary;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelVariant;
import com.android.tools.sdk.AndroidPlatform;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.graph.Graph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinModuleKind;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0004\u000b\f\r\u000eB!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/lint/AndroidLintIdeProject;", "Lcom/android/tools/idea/lint/common/LintIdeProject;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "referenceDir", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;)V", "initialize", "", "Companion", "LintAndroidProject", "LintAndroidModelProject", "LintGradleProject", "intellij.android.lint"})
public final class AndroidLintIdeProject
extends LintIdeProject {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AndroidLintIdeProject(@NotNull LintClient client, @NotNull File dir, @NotNull File referenceDir) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
        super(client, dir, referenceDir);
    }

    protected void initialize() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00052\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ,\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\rJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002Jz\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\r2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00052\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00060\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0&2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0012\u001a\u00020\r2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010$2\u0006\u0010*\u001a\u00020+H\u0002\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/lint/AndroidLintIdeProject$Companion;", "", "<init>", "()V", "create", "", "Lcom/android/tools/lint/detector/api/Project;", "client", "Lcom/android/tools/idea/lint/common/LintIdeClient;", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "modules", "", "Lcom/intellij/openapi/module/Module;", "(Lcom/android/tools/idea/lint/common/LintIdeClient;Ljava/util/List;[Lcom/intellij/openapi/module/Module;)Ljava/util/List;", "createForSingleFile", "Lcom/intellij/openapi/util/Pair;", "file", "module", "findAndroidModule", "addProjects", "", "Lcom/android/tools/lint/client/api/LintClient;", "moduleMap", "", "libraryMap", "Lcom/android/tools/lint/model/LintModelAndroidLibrary;", "projectMap", "projects", "", "shallowModel", "", "createModuleProject", "getLintModuleModel", "Lcom/android/tools/lint/model/LintModelModule;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "buildModuleModel", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "getLintProjectDirectory", "Ljava/io/File;", "findAndroidFacetInProject", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.lint"})
    @SourceDebugExtension(value={"SMAP\nAndroidLintIdeProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintIdeProject.kt\ncom/android/tools/idea/lint/AndroidLintIdeProject$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,685:1\n11228#2:686\n11563#2,3:687\n295#3,2:690\n1563#3:692\n1634#3,3:693\n1563#3:696\n1634#3,3:697\n1#4:700\n*S KotlinDebug\n*F\n+ 1 AndroidLintIdeProject.kt\ncom/android/tools/idea/lint/AndroidLintIdeProject$Companion\n*L\n95#1:686\n95#1:687,3\n242#1:690,2\n275#1:692\n275#1:693,3\n309#1:696\n309#1:697,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Project> create(@NotNull LintIdeClient client, @Nullable List<? extends VirtualFile> files2, Module ... modules) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
            ArrayList projects = new ArrayList();
            HashMap projectMap = Maps.newHashMap();
            HashMap moduleMap = Maps.newHashMap();
            HashMap libraryMap = Maps.newHashMap();
            Object $this$map$iv = modules;
            boolean $i$f$map = false;
            Module[] moduleArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Module[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var17_19 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(LinkedAndroidModuleGroupUtilsKt.getMainModule((Module)it));
            }
            List distinctModules = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            $this$map$iv = files2;
            if (!($this$map$iv == null || $this$map$iv.isEmpty())) {
                for (Module module : distinctModules) {
                    LintClient lintClient = (LintClient)client;
                    Intrinsics.checkNotNull((Object)moduleMap);
                    Map map2 = moduleMap;
                    Intrinsics.checkNotNull((Object)libraryMap);
                    Map map3 = libraryMap;
                    Intrinsics.checkNotNull((Object)projectMap);
                    this.addProjects(lintClient, module, files2, map2, map3, projectMap, projects, false);
                }
            } else {
                for (Module module : distinctModules) {
                    LintClient lintClient = (LintClient)client;
                    Intrinsics.checkNotNull((Object)moduleMap);
                    Map map4 = moduleMap;
                    Intrinsics.checkNotNull((Object)libraryMap);
                    Map map5 = libraryMap;
                    Intrinsics.checkNotNull((Object)projectMap);
                    this.addProjects(lintClient, module, null, map4, map5, projectMap, projects, false);
                }
            }
            client.setModuleMap((Map)projectMap);
            if (projects.size() > 1) {
                HashSet roots = new HashSet(projects);
                Iterator iterator2 = projects.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                Iterator iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Object e = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Project project = (Project)e;
                    List list = project.getAllLibraries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllLibraries(...)");
                    roots.removeAll(CollectionsKt.toSet((Iterable)list));
                }
                return CollectionsKt.toList((Iterable)roots);
            }
            return projects;
        }

        @NotNull
        public final com.intellij.openapi.util.Pair<Project, Project> createForSingleFile(@NotNull LintIdeClient client, @Nullable VirtualFile file, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Project project = this.createModuleProject((LintClient)client, module, true);
            Project main = null;
            HashMap projectMap = Maps.newHashMap();
            if (project != null) {
                Module androidModule;
                project.setDirectLibraries(CollectionsKt.emptyList());
                if (file != null) {
                    project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                }
                Intrinsics.checkNotNull((Object)projectMap);
                ((Map)projectMap).put(project, module);
                if (!project.isAndroidProject() && (androidModule = this.findAndroidModule(module)) != null && (main = this.createModuleProject((LintClient)client, androidModule, true)) != null) {
                    String path;
                    GradleProjectPath gradleProjectPath = GradleProjectPathKt.getGradleProjectPath(module);
                    String string = path = gradleProjectPath != null ? gradleProjectPath.getPath() : null;
                    if (Intrinsics.areEqual((Object)path, (Object)":")) {
                        File firstFile;
                        main.setDirectLibraries(CollectionsKt.emptyList());
                        client.setModuleMap(MapsKt.mapOf((Pair)TuplesKt.to((Object)main, (Object)module)));
                        List list = project.getSubset();
                        File file2 = firstFile = list != null ? (File)CollectionsKt.firstOrNull((List)list) : null;
                        if (firstFile != null) {
                            main.addFile(firstFile);
                        }
                        main.isGradleRootHolder = true;
                        com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)main, null);
                        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                        return pair;
                    }
                    ((Map)projectMap).put(main, androidModule);
                    main.setDirectLibraries(CollectionsKt.listOf((Object)project));
                }
                project.isGradleRootHolder = true;
            }
            client.setModuleMap((Map)projectMap);
            com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)project, main);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
            return pair;
        }

        private final Module findAndroidModule(Module module) {
            if (module.isDisposed()) {
                return null;
            }
            Graph graph = (Graph)ApplicationManager.getApplication().runReadAction(() -> Companion.findAndroidModule$lambda$1(module));
            if (graph == null) {
                return null;
            }
            Graph graph2 = graph;
            Ref.ObjectRef androidModule = new Ref.ObjectRef();
            HashSet seen = Sets.newHashSet();
            Object object = com.android.tools.idea.lint.AndroidLintIdeProject$Companion.findAndroidModule$findAppModule(seen, (Ref.ObjectRef<Module>)androidModule, (Graph<Module>)graph2, module);
            if (object == null && (object = (Module)androidModule.element) == null) {
                String path;
                Companion $this$findAndroidModule_u24lambda_u243 = this;
                boolean bl = false;
                GradleProjectPath gradleProjectPath = GradleProjectPathKt.getGradleProjectPath(module);
                String string = path = gradleProjectPath != null ? gradleProjectPath.getPath() : null;
                if (Intrinsics.areEqual((Object)path, (Object)"") || Intrinsics.areEqual((Object)path, (Object)":")) {
                    Object v5;
                    block6: {
                        Collection collection2 = graph2.getNodes();
                        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getNodes(...)");
                        Iterable $this$firstOrNull$iv = collection2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Module it = (Module)element$iv;
                            boolean bl2 = false;
                            if (!(AndroidFacet.getInstance((Module)it) != null)) continue;
                            v5 = element$iv;
                            break block6;
                        }
                        v5 = null;
                    }
                    Module module2 = v5;
                    object = module2 != null ? LinkedAndroidModuleGroupUtilsKt.getMainModule(module2) : null;
                } else {
                    object = null;
                }
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final void addProjects(LintClient client, Module module, List<? extends VirtualFile> files2, Map<Module, Project> moduleMap, Map<LintModelAndroidLibrary, Project> libraryMap, Map<Project, Module> projectMap, List<Project> projects, boolean shallowModel) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (moduleMap.containsKey(module)) {
                return;
            }
            Project project = this.createModuleProject(client, module, shallowModel);
            if (project == null) {
                void $this$mapTo$iv$iv2;
                Iterator $this$map$iv2;
                List<AndroidFacet> list = AndroidDependenciesCache.getAllAndroidDependencies(module, false);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getAllAndroidDependencies(...)");
                Iterable iterable = list;
                boolean $i$f$map = false;
                void var13_15 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv2), (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    AndroidFacet androidFacet = (AndroidFacet)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    Module module2 = it.getModule();
                    Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"getModule(...)");
                    collection2.add(LinkedAndroidModuleGroupUtilsKt.getMainModule(module2));
                }
                List dependentModules = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                for (Module dependentModule : dependentModules) {
                    this.addProjects(client, dependentModule, files2, moduleMap, libraryMap, projectMap, projects, true);
                }
                return;
            }
            project.setIdeaProject(module.getProject());
            projects.add(project);
            moduleMap.put(module, project);
            projectMap.put(project, module);
            if (LintIdeProject.Companion.processFileFilter(module, files2, project)) {
                return;
            }
            ArrayList<Project> dependencies2 = new ArrayList<Project>();
            List<AndroidFacet> list = AndroidDependenciesCache.getAllAndroidDependencies(module, true);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAllAndroidDependencies(...)");
            Iterable dependentModule = list;
            boolean $i$f$map = false;
            void destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AndroidFacet bl = (AndroidFacet)item$iv$iv;
                Collection collection3 = destination$iv$iv2;
                boolean bl2 = false;
                Module module3 = it.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"getModule(...)");
                collection3.add(LinkedAndroidModuleGroupUtilsKt.getMainModule(module3));
            }
            List dependentModules = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
            for (Module dependentModule2 : dependentModules) {
                Project p = moduleMap.get(dependentModule2);
                if (p != null) {
                    dependencies2.add(p);
                    continue;
                }
                this.addProjects(client, dependentModule2, files2, moduleMap, libraryMap, projectMap, (List<Project>)dependencies2, true);
            }
            project.setDirectLibraries((List)dependencies2);
        }

        private final Project createModuleProject(LintClient client, Module module, boolean shallowModel) {
            Module androidModule = ModuleExtensionsKt.findAndroidModule((Module)module);
            Module module2 = androidModule;
            if (module2 == null) {
                module2 = module;
            }
            AndroidFacet facet = AndroidFacet.getInstance((Module)module2);
            File file = this.getLintProjectDirectory(module, facet);
            if (file == null) {
                return null;
            }
            File dir = file;
            Project project = null;
            if (facet == null) {
                KotlinFacet kotlinFacet = KotlinFacet.Companion.get(module);
                if (kotlinFacet != null && ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings().getMppVersion() != null && ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings().getKind() != KotlinModuleKind.COMPILATION_AND_SOURCE_SET_HOLDER) {
                    return null;
                }
                project = (Project)new LintIdeProject.LintModuleProject(client, dir, dir, module);
                com.intellij.openapi.project.Project project2 = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                AndroidFacet f = this.findAndroidFacetInProject(project2);
                if (f != null) {
                    ((LintIdeProject.LintModuleProject)project).gradleProject = AndroidModel.Companion.isRequired(f);
                }
                if (LinkedAndroidModuleGroupUtilsKt.isHolderModule(module)) {
                    GradleProjectPath gradleProjectPath = GradleProjectPathKt.getGradleProjectPath(module);
                    ((LintIdeProject.LintModuleProject)project).isGradleRootHolder = Intrinsics.areEqual((Object)(gradleProjectPath != null ? gradleProjectPath.getPath() : null), (Object)":");
                }
            } else if (AndroidModel.Companion.isRequired(facet)) {
                AndroidModel androidModel = AndroidModel.Companion.get(facet);
                if (androidModel instanceof GradleAndroidDependencyModel) {
                    String variantName = ((GradleAndroidDependencyModel)androidModel).getSelectedVariantName();
                    LintModelModule lintModel = this.getLintModuleModel(facet, shallowModel);
                    LintModelVariant variant = lintModel.findVariant(variantName);
                    if (variant == null) {
                        variant = (LintModelVariant)lintModel.getVariants().get(0);
                    }
                    project = (Project)new LintGradleProject(client, dir, dir, variant, facet, (GradleAndroidDependencyModel)androidModel);
                } else {
                    project = androidModel != null ? (Project)new LintAndroidModelProject(client, dir, dir, facet, androidModel) : (Project)new LintAndroidProject(client, dir, dir, facet);
                }
            } else {
                project = (Project)new LintAndroidProject(client, dir, dir, facet);
            }
            project.setIdeaProject(module.getProject());
            client.registerProject(dir, project);
            return project;
        }

        private final LintModelModule getLintModuleModel(AndroidFacet facet, boolean shallowModel) {
            LintModelModule lintModelModule;
            com.intellij.openapi.project.Project project = facet.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            com.intellij.openapi.project.Project project2 = project;
            CachedValuesManager cacheValueManager = CachedValuesManager.getManager((com.intellij.openapi.project.Project)project2);
            if (shallowModel) {
                Object object = cacheValueManager.getCachedValue((UserDataHolder)facet, () -> Companion.getLintModuleModel$lambda$6(facet));
                Intrinsics.checkNotNull((Object)object);
                lintModelModule = (LintModelModule)object;
            } else {
                Object object = cacheValueManager.getCachedValue((UserDataHolder)facet, () -> Companion.getLintModuleModel$lambda$7(facet));
                Intrinsics.checkNotNull((Object)object);
                lintModelModule = (LintModelModule)object;
            }
            return lintModelModule;
        }

        private final CachedValueProvider.Result<LintModelModule> buildModuleModel(AndroidFacet facet, boolean shallowModel) {
            GradleAndroidDependencyModel model = GradleAndroidDependencyModel.Companion.get(facet);
            if (model == null) {
                boolean $i$a$-checkNotNull-AndroidLintIdeProject$Companion$buildModuleModel$42 = false;
                String $i$a$-checkNotNull-AndroidLintIdeProject$Companion$buildModuleModel$42 = "GradleAndroidModel not available for " + facet;
                throw new IllegalStateException($i$a$-checkNotNull-AndroidLintIdeProject$Companion$buildModuleModel$42.toString());
            }
            IdeAndroidProject builderModelProject = model.getAndroidProject();
            IdeMultiVariantData multiVariantData = builderModelProject.getMultiVariantData();
            if (multiVariantData == null) {
                boolean $i$a$-checkNotNull-AndroidLintIdeProject$Companion$buildModuleModel$52 = false;
                String $i$a$-checkNotNull-AndroidLintIdeProject$Companion$buildModuleModel$52 = "GradleAndroidModel is expected to support multi variant plugins.";
                throw new IllegalStateException($i$a$-checkNotNull-AndroidLintIdeProject$Companion$buildModuleModel$52.toString());
            }
            String externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)facet.getModule());
            if (externalProjectPath == null) {
                boolean $i$a$-checkNotNull-AndroidLintIdeProject$Companion$buildModuleModel$62 = false;
                String $i$a$-checkNotNull-AndroidLintIdeProject$Companion$buildModuleModel$62 = "No external project path for " + facet.getModule();
                throw new IllegalStateException($i$a$-checkNotNull-AndroidLintIdeProject$Companion$buildModuleModel$62.toString());
            }
            File dir = new File(externalProjectPath);
            LintModelModule module = new LintModelFactory().create(builderModelProject, (Collection<? extends IdeVariant>)model.getVariantsWithDependencies(), multiVariantData, dir, !shallowModel);
            Object[] objectArray = new Object[1];
            com.intellij.openapi.project.Project project = facet.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            objectArray[0] = ProjectSyncModificationTracker.Companion.getInstance(project);
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)module, (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"create(...)");
            return result2;
        }

        private final File getLintProjectDirectory(Module module, AndroidFacet facet) {
            String externalProjectPath;
            CharSequence charSequence;
            if (ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleProjectSystemUtil.GRADLE_SYSTEM_ID, (Module)module) && !((charSequence = (CharSequence)(externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module))) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                return new File(externalProjectPath);
            }
            File dir = null;
            if (facet != null) {
                VirtualFile virtualFile = AndroidRootUtil.getMainContentRoot(facet);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile mainContentRoot = virtualFile;
                dir = VfsUtilCore.virtualToIoFile((VirtualFile)mainContentRoot);
            } else {
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
                VirtualFile[] roots = virtualFileArray;
                if (roots.length == 0) {
                    return null;
                }
                dir = VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
            }
            return dir;
        }

        private final AndroidFacet findAndroidFacetInProject(com.intellij.openapi.project.Project project) {
            List list = ProjectFacetManager.getInstance((com.intellij.openapi.project.Project)project).getFacets(AndroidFacet.ID);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFacets(...)");
            List androidFacetsInRandomOrder = list;
            return androidFacetsInRandomOrder.isEmpty() ? null : (AndroidFacet)androidFacetsInRandomOrder.get(0);
        }

        private static final Graph findAndroidModule$lambda$1(Module $module) {
            com.intellij.openapi.project.Project project = $module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            com.intellij.openapi.project.Project project2 = project;
            return ModuleManager.Companion.getInstance(project2).moduleGraph();
        }

        private static final Module findAndroidModule$findAppModule(HashSet<Module> seen, Ref.ObjectRef<Module> androidModule, Graph<Module> graph, Module module) {
            if (!seen.add(module)) {
                return null;
            }
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            if (facet != null) {
                if (((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) {
                    Module module2 = facet.getModule();
                    Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"getModule(...)");
                    return LinkedAndroidModuleGroupUtilsKt.getMainModule(module2);
                }
                if (androidModule.element == null) {
                    Module module3 = facet.getModule();
                    Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"getModule(...)");
                    androidModule.element = LinkedAndroidModuleGroupUtilsKt.getMainModule(module3);
                }
            }
            Iterator iterator2 = graph.getOut((Object)module);
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"getOut(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Module dep = LinkedAndroidModuleGroupUtilsKt.getMainModule((Module)e);
                Module appModule = com.android.tools.idea.lint.AndroidLintIdeProject$Companion.findAndroidModule$findAppModule(seen, androidModule, graph, dep);
                if (appModule == null) continue;
                return appModule;
            }
            return null;
        }

        private static final CachedValueProvider.Result getLintModuleModel$lambda$6(AndroidFacet $facet) {
            return Companion.buildModuleModel($facet, true);
        }

        private static final CachedValueProvider.Result getLintModuleModel$lambda$7(AndroidFacet $facet) {
            return Companion.buildModuleModel($facet, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/lint/AndroidLintIdeProject$LintAndroidModelProject;", "Lcom/android/tools/idea/lint/AndroidLintIdeProject$LintAndroidProject;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "referenceDir", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "androidModel", "Lcom/android/tools/idea/model/AndroidModel;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/tools/idea/model/AndroidModel;)V", "getPackage", "", "getMinSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "getMinSdkVersions", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "getTargetSdkVersion", "intellij.android.lint"})
    private static final class LintAndroidModelProject
    extends LintAndroidProject {
        @NotNull
        private final AndroidModel androidModel;

        public LintAndroidModelProject(@NotNull LintClient client, @NotNull File dir, @NotNull File referenceDir, @NotNull AndroidFacet facet, @NotNull AndroidModel androidModel) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Intrinsics.checkNotNullParameter((Object)androidModel, (String)"androidModel");
            super(client, dir, referenceDir, facet);
            this.androidModel = androidModel;
        }

        @NotNull
        public String getPackage() {
            String pkg;
            LintModelVariant variant = this.getBuildVariant();
            if (variant != null && (pkg = variant.getPackage()) != null) {
                return pkg;
            }
            String manifestPackage = super.getPackage();
            if (manifestPackage != null) {
                return manifestPackage;
            }
            return this.androidModel.getApplicationId();
        }

        @NotNull
        public AndroidVersion getMinSdkVersion() {
            return this.androidModel.getMinSdkVersion();
        }

        @NotNull
        public ApiConstraint getMinSdkVersions() {
            AndroidVersion version2 = this.androidModel.getMinSdkVersion();
            return (ApiConstraint)ApiConstraint.Companion.get(version2.getFeatureLevel(), 0);
        }

        @NotNull
        public AndroidVersion getTargetSdkVersion() {
            AndroidVersion version2 = this.androidModel.getTargetSdkVersion();
            if (version2 != null) {
                return version2;
            }
            AndroidVersion androidVersion = super.getTargetSdkVersion();
            Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"getTargetSdkVersion(...)");
            return androidVersion;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010!R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/lint/AndroidLintIdeProject$LintAndroidProject;", "Lcom/android/tools/idea/lint/common/LintIdeProject$LintModuleProject;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "referenceDir", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;Lorg/jetbrains/android/facet/AndroidFacet;)V", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "isAndroidProject", "", "getName", "", "getType", "Lcom/android/tools/lint/model/LintModelModuleType;", "getManifestFiles", "", "getProguardFiles", "getResourceFolders", "dependsOn", "id", "Lcom/android/ide/common/repository/GoogleMavenArtifactId;", "moduleSystem", "Lcom/android/tools/idea/projectsystem/AndroidModuleSystem;", "(Lcom/android/ide/common/repository/GoogleMavenArtifactId;Lcom/android/tools/idea/projectsystem/AndroidModuleSystem;)Ljava/lang/Boolean;", "dependsOnForGradleProject", "artifact", "Lcom/android/tools/idea/projectsystem/gradle/GradleModuleSystem;", "(Ljava/lang/String;Lcom/android/tools/idea/projectsystem/gradle/GradleModuleSystem;)Ljava/lang/Boolean;", "(Ljava/lang/String;)Ljava/lang/Boolean;", "intellij.android.lint"})
    @SourceDebugExtension(value={"SMAP\nAndroidLintIdeProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintIdeProject.kt\ncom/android/tools/idea/lint/AndroidLintIdeProject$LintAndroidProject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,685:1\n1#2:686\n*E\n"})
    private static class LintAndroidProject
    extends LintIdeProject.LintModuleProject {
        @NotNull
        private final AndroidFacet facet;

        public LintAndroidProject(@NotNull LintClient client, @NotNull File dir, @NotNull File referenceDir, @NotNull AndroidFacet facet) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Module module = facet.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
            super(client, dir, referenceDir, LinkedAndroidModuleGroupUtilsKt.getMainModule(module));
            this.facet = facet;
            this.gradleProject = false;
            this.library = ((AndroidFacetConfiguration)this.facet.getConfiguration()).isLibraryProject();
            Module module2 = this.facet.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"getModule(...)");
            AndroidPlatform platform = AndroidPlatforms.getInstance(LinkedAndroidModuleGroupUtilsKt.getMainModule(module2));
            if (platform != null) {
                this.buildSdk = platform.getApiLevel();
                this.buildSdkLevel = platform.getApiVersion().getAndroidApiLevel();
            }
        }

        @NotNull
        protected final AndroidFacet getFacet() {
            return this.facet;
        }

        public boolean isAndroidProject() {
            return true;
        }

        @NotNull
        public String getName() {
            Module module = this.facet.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
            return ProjectSystemUtil.getModuleSystem(module).getDisplayNameForModuleGroup();
        }

        @NotNull
        public LintModelModuleType getType() {
            return LintModelFactory.Companion.getModuleType(((AndroidFacetConfiguration)this.facet.getConfiguration()).getProjectType());
        }

        @NotNull
        public List<File> getManifestFiles() {
            if (this.manifestFiles == null) {
                VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(this.facet);
                this.manifestFiles = manifestFile != null ? CollectionsKt.listOf((Object)VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile)) : CollectionsKt.emptyList();
            }
            List list = this.manifestFiles;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"manifestFiles");
            return list;
        }

        @NotNull
        public List<File> getProguardFiles() {
            if (this.proguardFiles == null) {
                AndroidFacetProperties androidFacetProperties = this.facet.getProperties();
                Intrinsics.checkNotNullExpressionValue((Object)androidFacetProperties, (String)"getProperties(...)");
                AndroidFacetProperties properties = androidFacetProperties;
                if (properties.RUN_PROGUARD) {
                    List urls = properties.myProGuardCfgFiles;
                    Intrinsics.checkNotNull((Object)urls);
                    if (!((Collection)urls).isEmpty()) {
                        this.proguardFiles = new ArrayList();
                        for (String osPath : AndroidUtils.urlsToOsPaths(urls, null)) {
                            Intrinsics.checkNotNull((Object)osPath);
                            if (StringsKt.contains$default((CharSequence)osPath, (CharSequence)"%MODULE_SDK_HOME%", (boolean)false, (int)2, null)) continue;
                            this.proguardFiles.add(new File(osPath));
                        }
                    }
                }
                if (this.proguardFiles == null) {
                    this.proguardFiles = CollectionsKt.emptyList();
                }
            }
            List list = this.proguardFiles;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"proguardFiles");
            return list;
        }

        @NotNull
        public List<File> getResourceFolders() {
            if (this.resourceFolders == null) {
                List<VirtualFile> folders = ResourceFolderManager.Companion.getInstance(this.facet).getFolders();
                ArrayList dirs = Lists.newArrayListWithExpectedSize((int)folders.size());
                for (VirtualFile folder : folders) {
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)folder));
                }
                this.resourceFolders = dirs;
            }
            List list = this.resourceFolders;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resourceFolders");
            return list;
        }

        private final Boolean dependsOn(GoogleMavenArtifactId id2, AndroidModuleSystem moduleSystem) {
            GoogleMavenArtifactId googleMavenArtifactId;
            GoogleMavenArtifactId googleMavenArtifactId2;
            if (moduleSystem.hasResolvedDependency((WellKnownMavenArtifactId)id2)) {
                return true;
            }
            GoogleMavenArtifactId it = googleMavenArtifactId2 = GoogleMavenArtifactId.Companion.androidxIdOf(id2);
            boolean bl = false;
            Object object = googleMavenArtifactId = it != id2 ? googleMavenArtifactId2 : null;
            if (googleMavenArtifactId != null) {
                it = googleMavenArtifactId;
                boolean bl2 = false;
                if (moduleSystem.hasResolvedDependency((WellKnownMavenArtifactId)it)) {
                    return true;
                }
            }
            return null;
        }

        private final Boolean dependsOnForGradleProject(String artifact, GradleModuleSystem moduleSystem) {
            com.android.ide.common.gradle.Module it;
            com.android.ide.common.gradle.Module module = com.android.ide.common.gradle.Module.Companion.tryParse(artifact);
            if (module != null) {
                it = module;
                boolean bl = false;
                if (moduleSystem.getResolvedDependency(it, DependencyScopeType.MAIN) != null) {
                    return true;
                }
            } else {
                return null;
            }
            if (StringsKt.startsWith$default((String)artifact, (String)"com.android.support", (boolean)false, (int)2, null)) {
                String newArtifact = AndroidxNameUtils.getCoordinateMapping((String)artifact);
                if (Intrinsics.areEqual((Object)newArtifact, (Object)artifact)) {
                    return null;
                }
                Intrinsics.checkNotNull((Object)newArtifact);
                com.android.ide.common.gradle.Module module2 = com.android.ide.common.gradle.Module.Companion.tryParse(newArtifact);
                if (module2 != null) {
                    it = module2;
                    boolean bl = false;
                    if (moduleSystem.getResolvedDependency(it, DependencyScopeType.MAIN) != null) {
                        return true;
                    }
                }
            }
            return null;
        }

        @Nullable
        public Boolean dependsOn(@NotNull String artifact) {
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            GoogleMavenArtifactId id2 = GoogleMavenArtifactId.Companion.find(artifact);
            Module module = this.facet.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
            AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module);
            GoogleMavenArtifactId googleMavenArtifactId = id2;
            if ((googleMavenArtifactId != null ? this.dependsOn(googleMavenArtifactId, moduleSystem) : (bl = moduleSystem instanceof GradleModuleSystem ? this.dependsOnForGradleProject(artifact, (GradleModuleSystem)moduleSystem) : null)) == null) {
                bl = super.dependsOn(artifact);
            }
            return bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/lint/AndroidLintIdeProject$LintGradleProject;", "Lcom/android/tools/lint/detector/api/LintModelModuleProject;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "referenceDir", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "androidFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "gradleAndroidModel", "Lcom/android/tools/idea/gradle/project/model/GradleAndroidDependencyModel;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;Lcom/android/tools/lint/model/LintModelVariant;Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/tools/idea/gradle/project/model/GradleAndroidDependencyModel;)V", "facet", "getJavaClassFolders", "", "getJavaLibraries", "includeProvided", "", "getBuildSdk", "", "getBuildTargetHash", "", "intellij.android.lint"})
    private static final class LintGradleProject
    extends LintModelModuleProject {
        @NotNull
        private final GradleAndroidDependencyModel gradleAndroidModel;
        @NotNull
        private final AndroidFacet facet;

        public LintGradleProject(@NotNull LintClient client, @NotNull File dir, @NotNull File referenceDir, @NotNull LintModelVariant variant, @NotNull AndroidFacet androidFacet, @NotNull GradleAndroidDependencyModel gradleAndroidModel) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter((Object)androidFacet, (String)"androidFacet");
            Intrinsics.checkNotNullParameter((Object)gradleAndroidModel, (String)"gradleAndroidModel");
            super(client, dir, referenceDir, variant, null);
            this.gradleProject = true;
            this.mergeManifests = true;
            this.facet = androidFacet;
            this.gradleAndroidModel = gradleAndroidModel;
        }

        @NotNull
        public List<File> getJavaClassFolders() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<File> getJavaLibraries(boolean includeProvided) {
            return CollectionsKt.emptyList();
        }

        public int getBuildSdk() {
            String compileTarget = this.gradleAndroidModel.getAndroidProject().getCompileTarget();
            AndroidVersion version2 = AndroidTargetHash.getPlatformVersion((String)compileTarget);
            if (version2 != null) {
                return version2.getFeatureLevel();
            }
            Module module = this.facet.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
            AndroidPlatform platform = AndroidPlatforms.getInstance(module);
            if (platform != null) {
                return platform.getApiVersion().getFeatureLevel();
            }
            return super.getBuildSdk();
        }

        @NotNull
        public String getBuildTargetHash() {
            return this.gradleAndroidModel.getAndroidProject().getCompileTarget();
        }
    }
}

