/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.DrawViewNode;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.NotificationModel;
import com.android.tools.idea.layoutinspector.model.SelectionOrigin;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.ui.LevelListItem;
import com.android.tools.idea.layoutinspector.ui.ViewDrawInfo;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010W\u001a\u00020\u001d2\u0006\u0010X\u001a\u00020\u001dJ\u0006\u0010Y\u001a\u00020=J\u001c\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0[2\u0006\u0010W\u001a\u00020\u001d2\u0006\u0010X\u001a\u00020\u001dJ\u001c\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00160[2\u0006\u0010W\u001a\u00020\u001d2\u0006\u0010X\u001a\u00020\u001dJ\u0018\u0010]\u001a\u0004\u0018\u00010V2\u0006\u0010W\u001a\u00020\u001d2\u0006\u0010X\u001a\u00020\u001dJ\u0016\u0010^\u001a\u00020=2\u0006\u0010_\u001a\u00020\u001d2\u0006\u0010`\u001a\u00020\u001dJ\u0006\u0010a\u001a\u00020=J6\u0010b\u001a\u00020=*\u00020c2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020e0[2\u0012\u0010f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020g0<0<2\u0006\u0010h\u001a\u00020(H\u0002J,\u0010i\u001a\b\u0012\u0004\u0012\u0002Hj0<\"\u0004\b\u0000\u0010j*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hj0<0<2\u0006\u0010k\u001a\u00020(H\u0002J\u001e\u0010l\u001a\u000202*\u00020e2\u0006\u0010m\u001a\u00020e2\b\b\u0002\u0010n\u001a\u000202H\u0002J\u0018\u0010o\u001a\u0002022\u0006\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020qH\u0007J\u0014\u0010s\u001a\u000202*\u00020q2\u0006\u0010m\u001a\u00020qH\u0002J\u0014\u0010s\u001a\u000202*\u00020&2\u0006\u0010m\u001a\u00020&H\u0002J\u0014\u0010s\u001a\u000202*\u00020q2\u0006\u0010m\u001a\u00020&H\u0002JB\u0010t\u001a\u00020=2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020\u001d2\u0006\u0010x\u001a\u00020\u001d2\u0012\u0010y\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020g05052\f\u0010z\u001a\b\u0012\u0004\u0012\u00020\u00160<H\u0002J\u0006\u0010{\u001a\u00020=J\u0006\u0010|\u001a\u00020=R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020(8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020(8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b/\u0010+\u001a\u0004\b0\u0010-R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b1\u00103R*\u00104\u001a\b\u0012\u0004\u0012\u00020\u0016058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b6\u0010+\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001d\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0\t0<\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u00108R(\u0010@\u001a\u0004\u0018\u00010?2\b\u0010\u0015\u001a\u0004\u0018\u00010?@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\"\u0010F\u001a\u0004\u0018\u00010E2\b\u0010\u0015\u001a\u0004\u0018\u00010E@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR$\u0010J\u001a\u00020I2\u0006\u0010\u0015\u001a\u00020I@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR$\u0010O\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010-\"\u0004\bQ\u0010RR\u000e\u0010S\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010T\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\bT\u00103\u00a8\u0006}"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/RenderModel;", "", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "notificationModel", "Lcom/android/tools/idea/layoutinspector/model/NotificationModel;", "treeSettings", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "currentClientProvider", "Lkotlin/Function0;", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "<init>", "(Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lcom/android/tools/idea/layoutinspector/model/NotificationModel;Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;Lkotlin/jvm/functions/Function0;)V", "getModel", "()Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "getNotificationModel", "()Lcom/android/tools/idea/layoutinspector/model/NotificationModel;", "getTreeSettings", "()Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "getCurrentClientProvider", "()Lkotlin/jvm/functions/Function0;", "value", "Lcom/android/tools/idea/layoutinspector/ui/ViewDrawInfo;", "hoveredDrawInfo", "getHoveredDrawInfo", "()Lcom/android/tools/idea/layoutinspector/ui/ViewDrawInfo;", "setHoveredDrawInfo", "(Lcom/android/tools/idea/layoutinspector/ui/ViewDrawInfo;)V", "xOff", "", "getXOff", "()D", "setXOff", "(D)V", "yOff", "getYOff", "setYOff", "visibleBounds", "Ljava/awt/Rectangle;", "maxDepth", "", "maxWidth", "getMaxWidth$annotations", "()V", "getMaxWidth", "()I", "maxHeight", "getMaxHeight$annotations", "getMaxHeight", "isRotated", "", "()Z", "hitRects", "", "getHitRects$annotations", "getHitRects", "()Ljava/util/List;", "setHitRects", "(Ljava/util/List;)V", "modificationListeners", "", "", "getModificationListeners", "", "overlayBytes", "getOverlayBytes", "()[B", "setOverlayBytes", "([B)V", "Ljava/awt/Image;", "overlayImage", "getOverlayImage", "()Ljava/awt/Image;", "", "overlayAlpha", "getOverlayAlpha", "()F", "setOverlayAlpha", "(F)V", "layerSpacing", "getLayerSpacing", "setLayerSpacing", "(I)V", "rootBounds", "isActive", "selectView", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "x", "y", "clearSelection", "findViewsAt", "Lkotlin/sequences/Sequence;", "findDrawInfoAt", "findTopViewAt", "rotate", "xRotation", "yRotation", "refresh", "buildLevelLists", "Lcom/android/tools/idea/layoutinspector/model/ViewNode$ReadAccess;", "nodes", "Lcom/android/tools/idea/layoutinspector/model/DrawViewNode;", "levelListCollector", "Lcom/android/tools/idea/layoutinspector/ui/LevelListItem;", "minLevel", "getOrAddSublist", "T", "index", "intersects", "other", "useTransitiveBounds", "testOverlap", "shape1", "Ljava/awt/Shape;", "shape2", "overlap", "rebuildRectsForLevel", "transform", "Ljava/awt/geom/AffineTransform;", "magnitude", "angle", "allLevels", "newHitRects", "resetRotation", "fireModified", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nRenderModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderModel.kt\ncom/android/tools/idea/layoutinspector/ui/RenderModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,433:1\n1869#2,2:434\n1869#2,2:436\n1869#2,2:439\n1869#2,2:441\n360#2,3:443\n1761#2,3:446\n363#2,4:449\n388#2,3:454\n1761#2,3:457\n391#2,4:460\n1761#2,3:464\n774#2:467\n865#2,2:468\n388#2,3:470\n1761#2,3:473\n391#2,4:476\n1634#2,3:480\n1878#2,2:483\n1869#2:485\n1870#2:493\n1880#2:494\n1869#2,2:495\n1869#2,2:497\n1387#2:506\n1475#2,5:507\n1563#2:512\n1634#2,3:513\n2851#2,7:516\n622#3:438\n2396#3,7:499\n1#4:453\n382#5,7:486\n*S KotlinDebug\n*F\n+ 1 RenderModel.kt\ncom/android/tools/idea/layoutinspector/ui/RenderModel\n*L\n108#1:434,2\n118#1:436,2\n188#1:439,2\n244#1:441,2\n288#1:443,3\n289#1:446,3\n288#1:449,4\n308#1:454,3\n309#1:457,3\n308#1:460,4\n315#1:464,3\n334#1:467\n334#1:468,2\n340#1:470,3\n341#1:473,3\n340#1:476,4\n343#1:480,3\n405#1:483,2\n406#1:485\n406#1:493\n405#1:494\n431#1:495,2\n196#1:497,2\n221#1:506\n221#1:507,5\n222#1:512\n222#1:513,3\n223#1:516,7\n168#1:438\n212#1:499,7\n407#1:486,7\n*E\n"})
public final class RenderModel {
    @NotNull
    private final InspectorModel model;
    @NotNull
    private final NotificationModel notificationModel;
    @NotNull
    private final TreeSettings treeSettings;
    @NotNull
    private final Function0<InspectorClient> currentClientProvider;
    @Nullable
    private ViewDrawInfo hoveredDrawInfo;
    private double xOff;
    private double yOff;
    @NotNull
    private Rectangle visibleBounds;
    private int maxDepth;
    @NotNull
    private List<ViewDrawInfo> hitRects;
    @NotNull
    private final List<Function0<Unit>> modificationListeners;
    @Nullable
    private byte[] overlayBytes;
    @Nullable
    private Image overlayImage;
    private float overlayAlpha;
    private int layerSpacing;
    @NotNull
    private Rectangle rootBounds;

    public RenderModel(@NotNull InspectorModel model, @NotNull NotificationModel notificationModel, @NotNull TreeSettings treeSettings, @NotNull Function0<? extends InspectorClient> currentClientProvider) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)notificationModel, (String)"notificationModel");
        Intrinsics.checkNotNullParameter((Object)treeSettings, (String)"treeSettings");
        Intrinsics.checkNotNullParameter(currentClientProvider, (String)"currentClientProvider");
        this.model = model;
        this.notificationModel = notificationModel;
        this.treeSettings = treeSettings;
        this.currentClientProvider = currentClientProvider;
        this.visibleBounds = new Rectangle();
        this.hitRects = CollectionsKt.emptyList();
        this.modificationListeners = new ArrayList();
        this.overlayAlpha = 0.6f;
        this.layerSpacing = 150;
        this.rootBounds = new Rectangle();
        this.model.addModificationListener((arg_0, arg_1, arg_2) -> RenderModel._init_$lambda$2(this, arg_0, arg_1, arg_2));
        this.refresh();
    }

    @NotNull
    public final InspectorModel getModel() {
        return this.model;
    }

    @NotNull
    public final NotificationModel getNotificationModel() {
        return this.notificationModel;
    }

    @NotNull
    public final TreeSettings getTreeSettings() {
        return this.treeSettings;
    }

    @NotNull
    public final Function0<InspectorClient> getCurrentClientProvider() {
        return this.currentClientProvider;
    }

    @Nullable
    public final ViewDrawInfo getHoveredDrawInfo() {
        return this.hoveredDrawInfo;
    }

    public final void setHoveredDrawInfo(@Nullable ViewDrawInfo value2) {
        if (!Intrinsics.areEqual((Object)this.hoveredDrawInfo, (Object)value2)) {
            this.hoveredDrawInfo = value2;
            this.fireModified();
        }
    }

    public final double getXOff() {
        return this.xOff;
    }

    public final void setXOff(double d) {
        this.xOff = d;
    }

    public final double getYOff() {
        return this.yOff;
    }

    public final void setYOff(double d) {
        this.yOff = d;
    }

    public final int getMaxWidth() {
        return (int)Math.hypot(this.maxDepth * this.layerSpacing, this.visibleBounds.width);
    }

    @VisibleForTesting
    public static /* synthetic */ void getMaxWidth$annotations() {
    }

    public final int getMaxHeight() {
        return (int)Math.hypot(this.maxDepth * this.layerSpacing, this.visibleBounds.height);
    }

    @VisibleForTesting
    public static /* synthetic */ void getMaxHeight$annotations() {
    }

    public final boolean isRotated() {
        return !(this.xOff == 0.0) || !(this.yOff == 0.0);
    }

    @NotNull
    public final List<ViewDrawInfo> getHitRects() {
        return this.hitRects;
    }

    public final void setHitRects(@NotNull List<ViewDrawInfo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.hitRects = list;
    }

    @VisibleForTesting
    public static /* synthetic */ void getHitRects$annotations() {
    }

    @NotNull
    public final List<Function0<Unit>> getModificationListeners() {
        return this.modificationListeners;
    }

    @Nullable
    public final byte[] getOverlayBytes() {
        return this.overlayBytes;
    }

    public final void setOverlayBytes(@Nullable byte[] value2) {
        if (value2 != null) {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(value2));
            this.overlayImage = image;
            this.resetRotation();
        } else {
            this.overlayImage = null;
        }
        this.overlayBytes = value2;
        Iterable $this$forEach$iv = this.modificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    @Nullable
    public final Image getOverlayImage() {
        return this.overlayImage;
    }

    public final float getOverlayAlpha() {
        return this.overlayAlpha;
    }

    public final void setOverlayAlpha(float value2) {
        this.overlayAlpha = value2;
        Iterable $this$forEach$iv = this.modificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final int getLayerSpacing() {
        return this.layerSpacing;
    }

    public final void setLayerSpacing(int value2) {
        this.layerSpacing = value2;
        this.refresh();
    }

    public final boolean isActive() {
        return !this.model.isEmpty();
    }

    @Nullable
    public final ViewNode selectView(double x, double y) {
        ViewNode view = this.findTopViewAt(x, y);
        this.model.setSelection(view, SelectionOrigin.INTERNAL);
        ((InspectorClient)this.currentClientProvider.invoke()).getStats().selectionMadeFromImage(view);
        return view;
    }

    public final void clearSelection() {
        this.model.setSelection(null, SelectionOrigin.INTERNAL);
    }

    @NotNull
    public final Sequence<ViewNode> findViewsAt(double x, double y) {
        return SequencesKt.distinct((Sequence)SequencesKt.mapNotNull(this.findDrawInfoAt(x, y), arg_0 -> RenderModel.findViewsAt$lambda$3(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sequence<ViewDrawInfo> findDrawInfoAt(double x, double y) {
        void $this$sortedByDescending$iv;
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.asReversed(this.hitRects)), arg_0 -> RenderModel.findDrawInfoAt$lambda$4(x, y, arg_0));
        boolean $i$f$sortedByDescending = false;
        return SequencesKt.distinct((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ViewDrawInfo it = (ViewDrawInfo)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getHitLevel());
                it = (ViewDrawInfo)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getHitLevel()));
            }
        }));
    }

    @Nullable
    public final ViewNode findTopViewAt(double x, double y) {
        Sequence<ViewNode> views = this.findViewsAt(x, y);
        return (ViewNode)SequencesKt.firstOrNull(views);
    }

    public final void rotate(double xRotation, double yRotation) {
        this.xOff = RangesKt.coerceIn((double)(this.xOff + xRotation), (double)-1.0, (double)1.0);
        this.yOff = RangesKt.coerceIn((double)(this.yOff + yRotation), (double)-1.0, (double)1.0);
        this.refresh();
    }

    public final void refresh() {
        ((InspectorClient)this.currentClientProvider.invoke()).getStats().setCurrentMode3D(this.isRotated());
        if (this.model.isEmpty()) {
            this.visibleBounds = new Rectangle();
            this.maxDepth = 0;
            this.hitRects = CollectionsKt.emptyList();
            Iterable $this$forEach$iv = this.modificationListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
            return;
        }
        ViewNode root = this.model.getRoot();
        List levelLists = new ArrayList();
        ViewNode.Companion.readAccess(arg_0 -> RenderModel.refresh$lambda$8(root, this, levelLists, arg_0));
        this.maxDepth = levelLists.size();
        List newHitRects = new ArrayList();
        AffineTransform transform2 = new AffineTransform();
        double magnitude = 0.0;
        double angle = 0.0;
        if (this.maxDepth > 0) {
            ViewNode.Companion.readAccess(arg_0 -> RenderModel.refresh$lambda$18(this, arg_0));
            root.getLayoutBounds().x = this.rootBounds.x;
            root.getLayoutBounds().y = this.rootBounds.y;
            root.getLayoutBounds().width = this.rootBounds.width;
            root.getLayoutBounds().height = this.rootBounds.height;
            magnitude = Math.min(0.98, Math.hypot(this.xOff, this.yOff));
            angle = Math.abs(this.xOff) < 1.0E-5 ? 1.5707963267948966 : Math.atan(this.yOff / this.xOff);
            transform2.rotate(angle);
        } else {
            this.visibleBounds = new Rectangle();
        }
        this.rebuildRectsForLevel(transform2, magnitude, angle, levelLists, newHitRects);
        this.hitRects = CollectionsKt.toList((Iterable)newHitRects);
        Iterable $this$forEach$iv = this.modificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLevelLists(ViewNode.ReadAccess $this$buildLevelLists, Sequence<? extends DrawViewNode> nodes, List<List<LevelListItem>> levelListCollector, int minLevel) {
        Object object;
        Object it;
        if (SequencesKt.none(nodes)) {
            return;
        }
        List[] listArray = new List[]{new ArrayList()};
        List siblingGroups = CollectionsKt.mutableListOf((Object[])listArray);
        for (DrawViewNode node : nodes) {
            int reversedIndex;
            block37: {
                int n;
                List $this$indexOfFirst$iv = CollectionsKt.reversed((Iterable)siblingGroups);
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    boolean bl;
                    block36: {
                        it = (List)item$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = (Iterable)it;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            object = $this$any$iv.iterator();
                            while (object.hasNext()) {
                                Object element$iv = object.next();
                                DrawViewNode sibling = (DrawViewNode)element$iv;
                                boolean bl3 = false;
                                if (!this.intersects(sibling, node, true)) continue;
                                bl = true;
                                break block36;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        n = index$iv;
                        break block37;
                    }
                    ++index$iv;
                }
                n = reversedIndex = -1;
            }
            int siblingListIndex = reversedIndex == -1 ? (node.canCollapse(this.treeSettings) ? 0 : 1) : siblingGroups.size() - reversedIndex;
            this.getOrAddSublist(siblingGroups, siblingListIndex).add(node);
        }
        for (DrawViewNode node : (List)siblingGroups.get(0)) {
            int newLevelIndex;
            block46: {
                block45: {
                    block44: {
                        boolean bl;
                        block39: {
                            ViewNode it2 = node.findFilteredOwner(this.treeSettings);
                            boolean bl4 = false;
                            boolean bl5 = it2 != null && !this.model.isVisible(it2);
                            if (bl5) {
                                this.buildLevelLists($this$buildLevelLists, node.children($this$buildLevelLists), levelListCollector, minLevel);
                                continue;
                            }
                            if (levelListCollector.isEmpty()) {
                                v3 = -1;
                            } else {
                                List<List<LevelListItem>> $this$indexOfLast$iv = levelListCollector.subList(minLevel, levelListCollector.size());
                                boolean $i$f$indexOfLast = false;
                                ListIterator<List<LevelListItem>> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                                while (iterator$iv.hasPrevious()) {
                                    boolean bl6;
                                    block38: {
                                        List<LevelListItem> levelList = iterator$iv.previous();
                                        boolean bl7 = false;
                                        Iterable $this$any$iv = levelList;
                                        boolean $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            bl6 = false;
                                        } else {
                                            for (Object element$iv : $this$any$iv) {
                                                object = (LevelListItem)element$iv;
                                                boolean bl8 = false;
                                                DrawViewNode existing = ((LevelListItem)object).component1();
                                                if (!RenderModel.intersects$default(this, existing, node, false, 2, null)) continue;
                                                bl6 = true;
                                                break block38;
                                            }
                                            bl6 = false;
                                        }
                                    }
                                    if (!bl6) continue;
                                    v3 = iterator$iv.nextIndex();
                                    break block39;
                                }
                                v3 = newLevelIndex = -1;
                            }
                        }
                        if (newLevelIndex != 0) break block44;
                        List list = (List)CollectionsKt.getOrNull(levelListCollector, (int)minLevel);
                        if (list != null) {
                            boolean bl9;
                            block40: {
                                Iterable $this$any$iv = list;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl9 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        it = (LevelListItem)element$iv;
                                        boolean bl10 = false;
                                        if (!Intrinsics.areEqual((Object)((LevelListItem)it).getNode().findFilteredOwner(this.treeSettings), (Object)node.findFilteredOwner(this.treeSettings))) continue;
                                        bl9 = true;
                                        break block40;
                                    }
                                    bl9 = false;
                                }
                            }
                            bl = bl9;
                        } else {
                            bl = false;
                        }
                        if (bl) break block45;
                    }
                    if (newLevelIndex != -1 || node.findFilteredOwner(this.treeSettings) != null) break block46;
                }
                if (node.getDrawWhenCollapsed()) {
                    this.getOrAddSublist(levelListCollector, minLevel).add(new LevelListItem(node, true));
                }
                this.buildLevelLists($this$buildLevelLists, node.children($this$buildLevelLists), levelListCollector, minLevel);
                continue;
            }
            this.getOrAddSublist(levelListCollector, newLevelIndex + minLevel + 1).add(new LevelListItem(node, false));
            this.buildLevelLists($this$buildLevelLists, node.children($this$buildLevelLists), levelListCollector, newLevelIndex + minLevel + 1);
        }
        for (List siblingGroup : siblingGroups.subList(1, siblingGroups.size())) {
            void $this$mapTo$iv;
            int n;
            Iterable<List<LevelListItem>> $this$indexOfLast$iv;
            List filteredGroup;
            block43: {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = siblingGroup;
                boolean $i$f$filter = false;
                Iterable $i$f$any = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    DrawViewNode it3 = (DrawViewNode)element$iv$iv;
                    boolean bl = false;
                    ViewNode owner = it3.findFilteredOwner(this.treeSettings);
                    if (!(owner == null || this.model.isVisible(owner))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                filteredGroup = (List)destination$iv$iv;
                $this$indexOfLast$iv = levelListCollector.subList(minLevel, levelListCollector.size());
                boolean $i$f$indexOfLast = false;
                ListIterator<List<LevelListItem>> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean bl;
                    block42: {
                        List<LevelListItem> levelList = iterator$iv.previous();
                        boolean bl11 = false;
                        Iterable $this$any$iv = levelList;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                boolean bl12;
                                block41: {
                                    LevelListItem levelListItem = (LevelListItem)element$iv;
                                    boolean bl13 = false;
                                    DrawViewNode existing = levelListItem.component1();
                                    Iterable $this$any$iv2 = filteredGroup;
                                    boolean $i$f$any3 = false;
                                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                        bl12 = false;
                                    } else {
                                        for (Object element$iv2 : $this$any$iv2) {
                                            DrawViewNode it4 = (DrawViewNode)element$iv2;
                                            boolean bl14 = false;
                                            if (!RenderModel.intersects$default(this, existing, it4, false, 2, null)) continue;
                                            bl12 = true;
                                            break block41;
                                        }
                                        bl12 = false;
                                    }
                                }
                                if (!bl12) continue;
                                bl = true;
                                break block42;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    n = iterator$iv.nextIndex();
                    break block43;
                }
                n = -1;
            }
            int newLevelIndex = n + minLevel + 1;
            $this$indexOfLast$iv = filteredGroup;
            Collection destination$iv = this.getOrAddSublist(levelListCollector, newLevelIndex);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it5;
                DrawViewNode $this$any$iv = (DrawViewNode)item$iv;
                Collection collection2 = destination$iv;
                boolean bl = false;
                collection2.add(new LevelListItem((DrawViewNode)it5, false));
            }
            for (DrawViewNode sibling : siblingGroup) {
                ViewNode owner = sibling.findFilteredOwner(this.treeSettings);
                boolean hidden = owner != null && !this.model.isVisible(owner);
                this.buildLevelLists($this$buildLevelLists, sibling.children($this$buildLevelLists), levelListCollector, hidden ? minLevel : newLevelIndex);
            }
        }
    }

    private final <T> List<T> getOrAddSublist(List<List<T>> $this$getOrAddSublist, int index) {
        List list;
        List<List<T>> list2 = $this$getOrAddSublist;
        boolean bl = 0 <= index ? index < list2.size() : false;
        if (bl) {
            list = list2.get(index);
        } else {
            List list3;
            int it = index;
            boolean bl2 = false;
            List it2 = list3 = (List)new ArrayList();
            boolean bl3 = false;
            $this$getOrAddSublist.add(it2);
            list = list3;
        }
        return list;
    }

    private final boolean intersects(DrawViewNode $this$intersects, DrawViewNode other, boolean useTransitiveBounds) {
        return this.overlap(useTransitiveBounds ? (Shape)$this$intersects.getUnfilteredOwner().getTransitiveBounds() : $this$intersects.getBounds(), other.getBounds());
    }

    static /* synthetic */ boolean intersects$default(RenderModel renderModel, DrawViewNode drawViewNode, DrawViewNode drawViewNode2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return renderModel.intersects(drawViewNode, drawViewNode2, bl);
    }

    @TestOnly
    public final boolean testOverlap(@NotNull Shape shape1, @NotNull Shape shape2) {
        Intrinsics.checkNotNullParameter((Object)shape1, (String)"shape1");
        Intrinsics.checkNotNullParameter((Object)shape2, (String)"shape2");
        return this.overlap(shape1, shape2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean overlap(Shape $this$overlap, Shape other) {
        Rectangle r1 = $this$overlap instanceof Rectangle ? (Rectangle)$this$overlap : null;
        Rectangle r2 = other instanceof Rectangle ? (Rectangle)other : null;
        if (r1 != null && r2 != null) {
            v0 = this.overlap(r1, r2);
            return v0;
        } else if (r1 != null) {
            v0 = this.overlap(other, r1);
            return v0;
        } else if (r2 != null) {
            v0 = this.overlap($this$overlap, r2);
            return v0;
        } else {
            Area area;
            Rectangle rectangle = other.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
            if (!this.overlap($this$overlap, rectangle)) return false;
            Area $this$overlap_u24lambda_u2433 = area = new Area($this$overlap);
            boolean bl = false;
            $this$overlap_u24lambda_u2433.intersect(new Area(other));
            if (area.isEmpty()) return false;
            return true;
        }
    }

    private final boolean overlap(Rectangle $this$overlap, Rectangle other) {
        return $this$overlap.x < other.x + other.width && other.x < $this$overlap.x + $this$overlap.width && $this$overlap.y < other.y + other.height && other.y < $this$overlap.y + $this$overlap.height;
    }

    private final boolean overlap(Shape $this$overlap, Rectangle other) {
        return $this$overlap.intersects(other.x, other.y, other.width, other.height);
    }

    /*
     * WARNING - void declaration
     */
    private final void rebuildRectsForLevel(AffineTransform transform2, double magnitude, double angle, List<? extends List<LevelListItem>> allLevels, List<ViewDrawInfo> newHitRects) {
        Map ownerToLevel = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = allLevels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void levelList;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int level = n;
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)levelList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                void $this$getOrPut$iv;
                LevelListItem levelListItem = (LevelListItem)element$iv;
                boolean bl2 = false;
                DrawViewNode view = levelListItem.component1();
                boolean isCollapsed = levelListItem.component2();
                Map map2 = ownerToLevel;
                ViewNode key$iv = view.findFilteredOwner(this.treeSettings);
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    Integer answer$iv = level;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                int hitLevel = ((Number)object).intValue();
                AffineTransform viewTransform = new AffineTransform(transform2);
                int sign = this.xOff < 0.0 ? -1 : 1;
                viewTransform.translate(magnitude * (double)(level - this.maxDepth / 2) * (double)this.layerSpacing * (double)sign, 0.0);
                viewTransform.scale(Math.sqrt(1.0 - magnitude * magnitude), 1.0);
                viewTransform.rotate(-angle);
                Shape rect = viewTransform.createTransformedShape(view.getUnfilteredOwner().getRenderBounds());
                Intrinsics.checkNotNull((Object)rect);
                newHitRects.add(new ViewDrawInfo(rect, viewTransform, view, hitLevel, isCollapsed));
            }
        }
    }

    public final void resetRotation() {
        if (!(this.xOff == 0.0) || !(this.yOff == 0.0)) {
            this.xOff = 0.0;
            this.yOff = 0.0;
            this.refresh();
        }
    }

    public final void fireModified() {
        Iterable $this$forEach$iv = this.modificationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private static final void _init_$lambda$2(RenderModel this$0, AndroidWindow androidWindow, AndroidWindow androidWindow2, boolean bl) {
        if (androidWindow2 == null) {
            this$0.overlayImage = null;
        }
        if (!((InspectorClient)this$0.currentClientProvider.invoke()).getCapabilities().contains((Object)InspectorClient.Capability.SUPPORTS_SKP)) {
            this$0.resetRotation();
        }
    }

    private static final ViewNode findViewsAt$lambda$3(RenderModel this$0, ViewDrawInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNode().findFilteredOwner(this$0.treeSettings);
    }

    private static final boolean findDrawInfoAt$lambda$4(double $x, double $y, ViewDrawInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getBounds().contains($x, $y);
    }

    private static final Unit refresh$lambda$8(ViewNode $root, RenderModel this$0, List $levelLists, ViewNode.ReadAccess $this$readAccess) {
        Intrinsics.checkNotNullParameter((Object)$this$readAccess, (String)"$this$readAccess");
        Iterable $this$forEach$iv = $this$readAccess.getDrawChildren($root);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DrawViewNode it = (DrawViewNode)element$iv;
            boolean bl = false;
            Object[] objectArray = new DrawViewNode[]{it};
            this$0.buildLevelLists($this$readAccess, (Sequence<? extends DrawViewNode>)SequencesKt.sequenceOf((Object[])objectArray), $levelLists, $levelLists.size());
        }
        return Unit.INSTANCE;
    }

    private static final boolean refresh$lambda$18$lambda$9(RenderModel this$0, ViewNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.model.isVisible(it);
    }

    private static final Rectangle refresh$lambda$18$lambda$10(ViewNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTransitiveBounds().getBounds();
    }

    private static final Sequence refresh$lambda$18$lowestVisible$lambda$13(RenderModel this$0, ViewNode.ReadAccess $this_readAccess, ViewNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RenderModel.refresh$lambda$18$lowestVisible(this$0, $this_readAccess, it);
    }

    private static final Sequence<ViewNode> refresh$lambda$18$lowestVisible(RenderModel this$0, ViewNode.ReadAccess $this_readAccess, ViewNode node) {
        Sequence sequence;
        if (this$0.model.isVisible(node)) {
            Object[] objectArray = new ViewNode[]{node};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)$this_readAccess.getChildren(node)), arg_0 -> RenderModel.refresh$lambda$18$lowestVisible$lambda$13(this$0, $this_readAccess, arg_0));
        }
        return sequence;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit refresh$lambda$18(RenderModel this$0, ViewNode.ReadAccess $this$readAccess) {
        Rectangle rectangle;
        Object v2;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object list$iv$iv;
        ViewNode it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Rectangle rectangle2;
        Object object;
        Object acc;
        Object accumulator$iv;
        Object v0;
        Iterable $this$reduceOrNull$iv;
        Intrinsics.checkNotNullParameter((Object)$this$readAccess, (String)"$this$readAccess");
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter($this$readAccess.flatten(this$0.model.getRoot()), arg_0 -> RenderModel.refresh$lambda$18$lambda$9(this$0, arg_0)), RenderModel::refresh$lambda$18$lambda$10);
        RenderModel renderModel = this$0;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void bounds;
                Rectangle rectangle3 = (Rectangle)iterator$iv.next();
                acc = (Rectangle)accumulator$iv;
                boolean bl = false;
                object = acc;
                Rectangle $this$refresh_u24lambda_u2418_u24lambda_u2412_u24lambda_u2411 = object;
                boolean bl2 = false;
                $this$refresh_u24lambda_u2418_u24lambda_u2412_u24lambda_u2411.add((Rectangle)bounds);
                accumulator$iv = object;
            }
            v0 = accumulator$iv;
        }
        if ((rectangle2 = (Rectangle)v0) == null) {
            rectangle2 = new Rectangle();
        }
        renderModel.visibleBounds = rectangle2;
        $this$reduceOrNull$iv = $this$readAccess.getChildren(this$0.model.getRoot());
        renderModel = this$0;
        boolean $i$f$flatMapSequence = false;
        iterator$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ViewNode)element$iv$iv;
            boolean bl = false;
            list$iv$iv = RenderModel.refresh$lambda$18$lowestVisible(this$0, $this$readAccess, it);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ViewNode)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getRenderBounds().getBounds());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$reduceOrNull = false;
        iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void bounds;
                Rectangle $i$f$mapTo2 = (Rectangle)iterator$iv.next();
                acc = (Rectangle)accumulator$iv;
                boolean bl = false;
                Object $this$refresh_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416 = object = acc;
                boolean bl3 = false;
                ((Rectangle)$this$refresh_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416).add((Rectangle)bounds);
                accumulator$iv = object;
            }
            v2 = accumulator$iv;
        }
        if ((rectangle = (Rectangle)v2) == null) {
            rectangle = new Rectangle();
        }
        renderModel.rootBounds = rectangle;
        return Unit.INSTANCE;
    }
}

