/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.resource;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.AndroidProjectModelUtils;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0007\u001a\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"findFacetFromPackage", "Lorg/jetbrains/android/facet/AndroidFacet;", "project", "Lcom/intellij/openapi/project/Project;", "packageName", "", "mapNamespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "facet", "namespace", "mapReference", "Lcom/android/ide/common/rendering/api/ResourceReference;", "reference", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.android.layout-inspector"})
public final class ResourceLookupResolverKt {
    @Nullable
    public static final AndroidFacet findFacetFromPackage(@NotNull Project project, @NotNull String packageName) {
        AndroidFacet androidFacet;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            for (Module it : (Iterable)ProjectSystemUtil.getProjectSystem(project).findModulesWithApplicationId(packageName)) {
                boolean bl = false;
                AndroidFacet androidFacet2 = AndroidFacet.getInstance((Module)it);
                if (androidFacet2 == null) continue;
                androidFacet = androidFacet2;
                break block1;
            }
            androidFacet = null;
        }
        return androidFacet;
    }

    @NotNull
    public static final ResourceNamespace mapNamespace(@Nullable AndroidFacet facet, @NotNull ResourceNamespace namespace) {
        ResourceNamespace resourceNamespace;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (facet != null && AndroidProjectModelUtils.getNamespacing(facet) == Namespacing.REQUIRED) {
            resourceNamespace = namespace;
        } else if (Intrinsics.areEqual((Object)namespace, (Object)ResourceNamespace.ANDROID)) {
            ResourceNamespace resourceNamespace2 = ResourceNamespace.ANDROID;
            resourceNamespace = resourceNamespace2;
            Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace2, (String)"ANDROID");
        } else {
            ResourceNamespace resourceNamespace3 = ResourceNamespace.RES_AUTO;
            resourceNamespace = resourceNamespace3;
            Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace3, (String)"RES_AUTO");
        }
        return resourceNamespace;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final ResourceReference mapReference(@Nullable AndroidFacet facet, @Nullable ResourceReference reference) {
        ResourceReference resourceReference;
        if (reference != null) {
            AndroidFacet androidFacet = facet;
            if ((androidFacet != null ? AndroidProjectModelUtils.getNamespacing(androidFacet) : null) != Namespacing.REQUIRED) {
                ResourceNamespace resourceNamespace = reference.getNamespace();
                Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"getNamespace(...)");
                resourceReference = new ResourceReference(ResourceLookupResolverKt.mapNamespace(facet, resourceNamespace), reference.getResourceType(), reference.getName());
                return resourceReference;
            }
        }
        resourceReference = reference;
        return resourceReference;
    }

    @Nullable
    public static final Navigatable findNavigatable(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof Navigatable ? (Navigatable)element : EditSourceUtil.getDescriptor((PsiElement)element);
    }
}

