/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.legacy;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorSessionMetrics;
import com.android.tools.idea.layoutinspector.metrics.statistics.SessionStatisticsImpl;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.NotificationModel;
import com.android.tools.idea.layoutinspector.pipeline.AbstractInspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.legacy.ComposeWarning;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyEvent;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyPropertiesProvider;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyTreeLoader;
import com.android.tools.idea.layoutinspector.properties.ViewNodeAndResourceLookup;
import com.android.tools.idea.layoutinspector.snapshots.LegacySnapshotSupportKt;
import com.android.tools.idea.layoutinspector.snapshots.SnapshotMetadata;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorAttachToProcess;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001HBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010;\u001a\u00020\"H\u0094@\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020\"H\u0002J\b\u0010>\u001a\u00020\"H\u0016J\u0016\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u00020AH\u0096@\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020\u0017H\u0007J\u000e\u0010D\u001a\u00020\"H\u0094@\u00a2\u0006\u0002\u0010<J\u000e\u0010E\u001a\u00020FH\u0096@\u00a2\u0006\u0002\u0010<J\u000e\u0010G\u001a\u00020FH\u0096@\u00a2\u0006\u0002\u0010<R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001d\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R&\u0010/\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010.\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00105\"\u0004\b:\u00107\u00a8\u0006I"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyClient;", "Lcom/android/tools/idea/layoutinspector/pipeline/AbstractInspectorClient;", "process", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "notificationModel", "Lcom/android/tools/idea/layoutinspector/model/NotificationModel;", "metrics", "Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorSessionMetrics;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "treeLoaderForTest", "Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeLoader;", "<init>", "(Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lcom/android/tools/idea/layoutinspector/model/NotificationModel;Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorSessionMetrics;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeLoader;)V", "getModel", "()Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "lookup", "Lcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;", "inLiveMode", "", "getInLiveMode", "()Z", "provider", "Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyPropertiesProvider;", "getProvider", "()Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyPropertiesProvider;", "loggedInitialRender", "composeWarning", "Lcom/android/tools/idea/layoutinspector/pipeline/legacy/ComposeWarning;", "logEvent", "", "type", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorEvent$DynamicLayoutInspectorEventType;", "isRenderEvent", "treeLoader", "getTreeLoader", "()Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeLoader;", "latestScreenshots", "", "", "", "getLatestScreenshots", "()Ljava/util/Map;", "latestData", "getLatestData", "setLatestData", "(Ljava/util/Map;)V", "latestConfig", "getLatestConfig", "()Ljava/lang/String;", "setLatestConfig", "(Ljava/lang/String;)V", "latestTheme", "getLatestTheme", "setLatestTheme", "doConnect", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doAttach", "refresh", "saveSnapshot", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reloadAllWindows", "doDisconnect", "startFetching", "", "stopFetching", "LegacyFetchingUnsupportedOperationException", "intellij.android.layout-inspector"})
public final class LegacyClient
extends AbstractInspectorClient {
    @NotNull
    private final InspectorModel model;
    @NotNull
    private final LayoutInspectorSessionMetrics metrics;
    @NotNull
    private final ViewNodeAndResourceLookup lookup;
    private final boolean inLiveMode;
    @NotNull
    private final LegacyPropertiesProvider provider;
    private boolean loggedInitialRender;
    @NotNull
    private final ComposeWarning composeWarning;
    @NotNull
    private final LegacyTreeLoader treeLoader;
    @NotNull
    private final Map<String, byte[]> latestScreenshots;
    @NotNull
    private Map<String, byte[]> latestData;
    @NotNull
    private String latestConfig;
    @NotNull
    private String latestTheme;

    public LegacyClient(@NotNull ProcessDescriptor process2, @NotNull InspectorModel model, @NotNull NotificationModel notificationModel, @NotNull LayoutInspectorSessionMetrics metrics, @NotNull CoroutineScope coroutineScope, @NotNull Disposable parentDisposable, @Nullable LegacyTreeLoader treeLoaderForTest) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)notificationModel, (String)"notificationModel");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(DynamicLayoutInspectorAttachToProcess.ClientType.LEGACY_CLIENT, model.getProject(), notificationModel, process2, new SessionStatisticsImpl(DynamicLayoutInspectorAttachToProcess.ClientType.LEGACY_CLIENT, null, null, null, 14, null), coroutineScope, parentDisposable, null, 128, null);
        this.model = model;
        this.metrics = metrics;
        this.lookup = this.model;
        this.provider = new LegacyPropertiesProvider();
        this.composeWarning = new ComposeWarning(this.model.getProject(), notificationModel);
        LegacyTreeLoader legacyTreeLoader = treeLoaderForTest;
        if (legacyTreeLoader == null) {
            legacyTreeLoader = new LegacyTreeLoader(this);
        }
        this.treeLoader = legacyTreeLoader;
        this.latestScreenshots = new LinkedHashMap();
        this.latestData = new LinkedHashMap();
        this.latestConfig = "";
        this.latestTheme = "";
        this.loggedInitialRender = false;
    }

    public /* synthetic */ LegacyClient(ProcessDescriptor processDescriptor2, InspectorModel inspectorModel, NotificationModel notificationModel, LayoutInspectorSessionMetrics layoutInspectorSessionMetrics, CoroutineScope coroutineScope, Disposable disposable, LegacyTreeLoader legacyTreeLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            legacyTreeLoader = null;
        }
        this(processDescriptor2, inspectorModel, notificationModel, layoutInspectorSessionMetrics, coroutineScope, disposable, legacyTreeLoader);
    }

    @NotNull
    public final InspectorModel getModel() {
        return this.model;
    }

    @Override
    public boolean getInLiveMode() {
        return this.inLiveMode;
    }

    @Override
    @NotNull
    public LegacyPropertiesProvider getProvider() {
        return this.provider;
    }

    public final void logEvent(@NotNull DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!this.isRenderEvent(type)) {
            LayoutInspectorSessionMetrics.logEvent$default(this.metrics, type, this.getStats(), null, null, 12, null);
        } else if (!this.loggedInitialRender) {
            LayoutInspectorSessionMetrics.logEvent$default(this.metrics, type, this.getStats(), null, null, 12, null);
            this.loggedInitialRender = true;
        }
    }

    private final boolean isRenderEvent(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1, 2 -> true;
            default -> false;
        };
    }

    @Override
    @NotNull
    public LegacyTreeLoader getTreeLoader() {
        return this.treeLoader;
    }

    @NotNull
    public final Map<String, byte[]> getLatestScreenshots() {
        return this.latestScreenshots;
    }

    @NotNull
    public final Map<String, byte[]> getLatestData() {
        return this.latestData;
    }

    public final void setLatestData(@NotNull Map<String, byte[]> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.latestData = map2;
    }

    @NotNull
    public final String getLatestConfig() {
        return this.latestConfig;
    }

    public final void setLatestConfig(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.latestConfig = string;
    }

    @NotNull
    public final String getLatestTheme() {
        return this.latestTheme;
    }

    public final void setLatestTheme(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.latestTheme = string;
    }

    @Override
    @Nullable
    protected Object doConnect(@NotNull Continuation<? super Unit> $completion) {
        this.doAttach();
        return Unit.INSTANCE;
    }

    private final void doAttach() {
        LayoutInspectorSessionMetrics.logEvent$default(this.metrics, DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.COMPATIBILITY_REQUEST, this.getStats(), null, null, 12, null);
        while (!this.reloadAllWindows()) {
            if (this.getState() == InspectorClient.State.DISCONNECTED) {
                return;
            }
            Thread.sleep(1000L);
        }
        this.logEvent(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.COMPATIBILITY_SUCCESS);
        this.composeWarning.performCheck(this);
    }

    @Override
    public void refresh() {
        this.reloadAllWindows();
    }

    @Override
    @Nullable
    public Object saveSnapshot(@NotNull Path path, @NotNull Continuation<? super Unit> $completion) {
        ThreadingAssertions.assertBackgroundThread();
        long startTime = System.currentTimeMillis();
        SnapshotMetadata snapshotMetadata = LegacySnapshotSupportKt.saveLegacySnapshot(path, this.latestData, this.latestScreenshots, this.latestConfig, this.latestTheme, this.getProcess(), this.model);
        snapshotMetadata.setSaveDuration(Boxing.boxLong((long)(System.currentTimeMillis() - startTime)));
        LayoutInspectorSessionMetrics saveMetrics = new LayoutInspectorSessionMetrics(this.model.getProject(), this.getProcess(), snapshotMetadata);
        LayoutInspectorSessionMetrics.logEvent$default(saveMetrics, DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.SNAPSHOT_CAPTURED, this.getStats(), null, null, 12, null);
        return Unit.INSTANCE;
    }

    @Slow
    public final boolean reloadAllWindows() {
        List<String> list = this.getTreeLoader().getAllWindowIds(null);
        if (list == null) {
            return false;
        }
        List<String> windowIds = list;
        if (windowIds.isEmpty()) {
            return false;
        }
        LegacyPropertiesProvider.Updater propertiesUpdater = new LegacyPropertiesProvider.Updater(this.lookup);
        for (String windowId : windowIds) {
            this.fireTreeEvent(new LegacyEvent(windowId, propertiesUpdater, windowIds));
        }
        propertiesUpdater.apply(this.getProvider());
        return true;
    }

    @Override
    @Nullable
    protected Object doDisconnect(@NotNull Continuation<? super Unit> $completion) {
        this.logEvent(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.SESSION_DATA);
        this.latestScreenshots.clear();
        return Unit.INSTANCE;
    }

    @Nullable
    public Object startFetching(@NotNull Continuation<?> $completion) {
        throw new LegacyFetchingUnsupportedOperationException();
    }

    @Nullable
    public Object stopFetching(@NotNull Continuation<?> $completion) {
        throw new LegacyFetchingUnsupportedOperationException();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyClient$LegacyFetchingUnsupportedOperationException;", "Ljava/lang/UnsupportedOperationException;", "Lkotlin/UnsupportedOperationException;", "<init>", "()V", "intellij.android.layout-inspector"})
    public static final class LegacyFetchingUnsupportedOperationException
    extends UnsupportedOperationException {
        public LegacyFetchingUnsupportedOperationException() {
            super("Fetching is not supported by legacy clients");
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.values().length];
            try {
                nArray[DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.COMPATIBILITY_RENDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.COMPATIBILITY_RENDER_NO_PICTURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

