/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.rs;

import com.android.tools.idea.lang.rs.RenderscriptFile;
import com.android.tools.idea.lang.rs.RenderscriptLanguage;
import com.android.tools.idea.lang.rs.RenderscriptLexer;
import com.android.tools.idea.lang.rs.RenderscriptParser;
import com.android.tools.idea.lang.rs.RenderscriptTokenType;
import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class RenderscriptParserDefinition
implements ParserDefinition {
    public static final IFileElementType FILE = new IFileElementType((Language)RenderscriptLanguage.INSTANCE);

    @NotNull
    public Lexer createLexer(Project project) {
        return new RenderscriptLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new RenderscriptParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return TokenSets.WHITESPACE_TOKENS;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return TokenSets.COMMENT_TOKENS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSets.STRING_TOKENS;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return new ASTWrapperPsiElement(node);
    }

    @NotNull
    public PsiFile createFile(FileViewProvider viewProvider) {
        return new RenderscriptFile(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left2, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MUST;
    }

    private static class TokenSets {
        static final TokenSet WHITESPACE_TOKENS = TokenSet.WHITE_SPACE;
        static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.COMMENT});
        static final TokenSet STRING_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.STRING});

        private TokenSets() {
        }
    }
}

