/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.model;

import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.android.tools.idea.lang.databinding.model.PsiModelMember;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/lang/databinding/model/PsiModelField;", "Lcom/android/tools/idea/lang/databinding/model/PsiModelMember;", "containingClass", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "psiField", "Lcom/intellij/psi/PsiField;", "<init>", "(Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;Lcom/intellij/psi/PsiField;)V", "getContainingClass", "()Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "getPsiField", "()Lcom/intellij/psi/PsiField;", "name", "", "getName", "()Ljava/lang/String;", "isPublic", "", "()Z", "isStatic", "fieldType", "getFieldType", "intellij.android.lang-databinding"})
public final class PsiModelField
implements PsiModelMember {
    @NotNull
    private final PsiModelClass containingClass;
    @NotNull
    private final PsiField psiField;
    private final boolean isPublic;
    private final boolean isStatic;
    @NotNull
    private final PsiModelClass fieldType;

    public PsiModelField(@NotNull PsiModelClass containingClass, @NotNull PsiField psiField) {
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)psiField, (String)"psiField");
        this.containingClass = containingClass;
        this.psiField = psiField;
        this.isPublic = this.psiField.hasModifierProperty("public");
        this.isStatic = this.psiField.hasModifierProperty("static");
        PsiType psiType = this.getContainingClass().getSubstitutor().substitute(this.psiField.getType());
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"substitute(...)");
        this.fieldType = new PsiModelClass(psiType, this.getContainingClass().getMode());
    }

    @Override
    @NotNull
    public PsiModelClass getContainingClass() {
        return this.containingClass;
    }

    @NotNull
    public final PsiField getPsiField() {
        return this.psiField;
    }

    @NotNull
    public final String getName() {
        String string = this.psiField.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public final boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @NotNull
    public final PsiModelClass getFieldType() {
        return this.fieldType;
    }
}

