/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.android.instantapps.sdk.api.ExtendedSdk;
import com.google.android.instantapps.sdk.api.SdkLoader;
import com.google.android.instantapps.sdk.api.TelemetryManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantAppSdks {
    @NotNull
    private static final String INSTANT_APP_SDK_PATH = "extras;google;instantapps";
    private static final String SDK_LIB_JAR_PATH = "tools/lib.jar";
    @VisibleForTesting
    static final String UPGRADE_PROMPT_TEXT = "Required Google Play Instant SDK must be updated to run this task. Do you want to update it now?";
    @VisibleForTesting
    static final LoadInstantAppSdkException COULD_NOT_LOAD_NEW_SDK_EXCEPTION = new LoadInstantAppSdkException("Could not load required version of the Google Play Instant SDK");
    private ExtendedSdk cachedSdkLib = null;

    @NotNull
    public static InstantAppSdks getInstance() {
        return (InstantAppSdks)ApplicationManager.getApplication().getService(InstantAppSdks.class);
    }

    @NotNull
    public Path getOrInstallInstantAppSdk() {
        LocalPackage localPackage = InstantAppSdks.getInstantAppLocalPackage();
        if (localPackage == null) {
            return InstantAppSdks.ensureSdkInstalled().getLocation();
        }
        return localPackage.getLocation();
    }

    @Nullable
    private static LocalPackage getInstantAppLocalPackage() {
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        return androidSdkHandler.getLocalPackage(INSTANT_APP_SDK_PATH, (ProgressIndicator)new StudioLoggerProgressIndicator(InstantAppSdks.class));
    }

    @NotNull
    private static LocalPackage ensureSdkInstalled() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            ModelWizardDialog dialog2;
            if (MessageDialogBuilder.yesNo((String)"Google Play Instant", (String)"Required Google Play Instant SDK not installed. Do you want to install it now?").show() == 0 && (dialog2 = SdkQuickfixUtils.createDialogForPaths(null, (Collection<String>)ImmutableList.of((Object)INSTANT_APP_SDK_PATH))) != null) {
                dialog2.show();
            }
        });
        LocalPackage localPackage = InstantAppSdks.getInstantAppLocalPackage();
        if (localPackage == null) {
            throw new LoadInstantAppSdkException("Could not load the Google Play Instant SDK");
        }
        return localPackage;
    }

    private static void updateSdk() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            ModelWizardDialog dialog2;
            int result2 = MessageDialogBuilder.yesNo((String)"Google Play Instant", (String)UPGRADE_PROMPT_TEXT).show();
            if (result2 == 0 && (dialog2 = SdkQuickfixUtils.createDialogForPaths(null, (Collection<String>)ImmutableList.of((Object)INSTANT_APP_SDK_PATH))) != null) {
                dialog2.show();
            }
        });
    }

    @NotNull
    public ExtendedSdk loadLibrary() {
        return this.loadLibrary(true);
    }

    @NotNull
    @VisibleForTesting
    ExtendedSdk loadLibrary(boolean attemptUpgrades) {
        if (this.cachedSdkLib == null) {
            Path sdkRoot = this.getOrInstallInstantAppSdk();
            File jar = sdkRoot.resolve(SDK_LIB_JAR_PATH).toFile();
            if (!jar.exists()) {
                if (attemptUpgrades) {
                    InstantAppSdks.updateSdk();
                    return this.loadLibrary(false);
                }
                throw COULD_NOT_LOAD_NEW_SDK_EXCEPTION;
            }
            this.cachedSdkLib = new SdkLoader().loadSdk(jar, TelemetryManager.HostApplication.ANDROID_STUDIO, ApplicationInfo.getInstance().getFullVersion());
            if (this.cachedSdkLib == null) {
                if (attemptUpgrades) {
                    InstantAppSdks.updateSdk();
                    return this.loadLibrary(false);
                }
                throw COULD_NOT_LOAD_NEW_SDK_EXCEPTION;
            }
        }
        this.cachedSdkLib.getTelemetryManager().setOptInStatus(AnalyticsSettings.getOptedIn() ? TelemetryManager.OptInStatus.OPTED_IN : TelemetryManager.OptInStatus.OPTED_OUT);
        return this.cachedSdkLib;
    }

    public static class LoadInstantAppSdkException
    extends RuntimeException {
        public LoadInstantAppSdkException(@NotNull String message) {
            super(message);
        }
    }
}

