/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ui;

import com.android.tools.idea.insights.persistence.AppInsightsSettings;
import com.android.tools.idea.insights.ui.UiUtilKt;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.PositionTracker;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/insights/ui/OfflineBalloonMaker;", "", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "offlineErrorContent", "showOfflineNotificationBalloon", "", "button", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "intellij.android.app-quality-insights.ui"})
public final class OfflineBalloonMaker {
    @NotNull
    private final Project project;
    @NotNull
    private final String offlineErrorContent;

    public OfflineBalloonMaker(@NotNull String name2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.offlineErrorContent = "<b>Offline</b><br/><br/>You are currently in offline mode because<br/>Android Studio could not reach " + name2 + ".<br/><br/>You can see issues already fetched from the<br/>last time you were online and your actions<br/>are saved locally. You can click Reconnect to<br/>exit offline mode. Reconnect will fetch<br/>new content and send your changes.<br/><br/><a href='dismiss'>Dismiss</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href='noshow'>Don't show again</a>";
    }

    public final void showOfflineNotificationBalloon(@NotNull ActionButton button) {
        Balloon balloon;
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Color color = MessageType.ERROR.getPopupBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getPopupBackground(...)");
        Color background = color;
        Ref.ObjectRef balloon2 = new Ref.ObjectRef();
        Balloon balloon3 = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.offlineErrorContent, UiUtilKt.getOfflineModeIcon(), background, (HyperlinkListener)new HyperlinkAdapter((Ref.ObjectRef<Balloon>)balloon2, this){
            final /* synthetic */ Ref.ObjectRef<Balloon> $balloon;
            final /* synthetic */ OfflineBalloonMaker this$0;
            {
                this.$balloon = $balloon;
                this.this$0 = $receiver;
            }

            protected void hyperlinkActivated(HyperlinkEvent e) {
                Balloon balloon;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$balloon.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"balloon");
                    balloon = null;
                } else {
                    balloon = (Balloon)this.$balloon.element;
                }
                balloon.hide();
                if (Intrinsics.areEqual((Object)e.getDescription(), (Object)"noshow")) {
                    ComponentManager $this$service$iv = (ComponentManager)OfflineBalloonMaker.access$getProject$p(this.this$0);
                    boolean $i$f$service = false;
                    Class<AppInsightsSettings> serviceClass$iv = AppInsightsSettings.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    ((AppInsightsSettings)object).setOfflineNotificationDismissed(true);
                }
            }
        }).setBorderColor(JBColor.border()).setBorderInsets((Insets)JBInsets.create((int)4, (int)4)).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon3, (String)"createBalloon(...)");
        balloon2.element = balloon3;
        if (balloon2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"balloon");
            balloon = null;
        } else {
            balloon = (Balloon)balloon2.element;
        }
        balloon.show((PositionTracker)new PositionTracker<Balloon>(button){

            public RelativePoint recalculateLocation(Balloon balloon) {
                Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
                return new RelativePoint(this.getComponent(), new Point(this.getComponent().getPreferredSize().width / 4, 0));
            }
        }, Balloon.Position.above);
    }

    public static final /* synthetic */ Project access$getProject$p(OfflineBalloonMaker $this) {
        return $this.project;
    }
}

