/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util.ui;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventUtil {
    @Nullable
    public static Module getSelectedAndroidModule(@NotNull AnActionEvent e) {
        Module module = EventUtil.getSelectedGradleModule(e);
        if (module != null && AndroidFacet.getInstance((Module)module) != null) {
            return module;
        }
        return null;
    }

    @Nullable
    public static Module getSelectedGradleModule(@NotNull AnActionEvent e) {
        ProjectFileIndex fileIndex;
        VirtualFile file;
        DataContext dataContext = e.getDataContext();
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (EventUtil.isGradleModule(module)) {
            return module;
        }
        Project project = e.getProject();
        if (project != null && (file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null && EventUtil.isGradleModule(module = (fileIndex = ProjectFileIndex.getInstance((Project)project)).getModuleForFile(file))) {
            return module;
        }
        return null;
    }

    private static boolean isGradleModule(@Nullable Module module) {
        return module != null && GradleFacet.isAppliedTo(module);
    }
}

