/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.pom;

import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenPoms {
    private static final Logger LOG = Logger.getInstance(MavenPoms.class);

    private MavenPoms() {
    }

    @NotNull
    public static List<PsArtifactDependencySpec> findDependenciesInPomFile(@Nullable File pomFilePath) {
        if (pomFilePath == null || !pomFilePath.isFile()) {
            return Collections.emptyList();
        }
        ArrayList<PsArtifactDependencySpec> dependencies2 = new ArrayList<PsArtifactDependencySpec>();
        try {
            Element rootElement = JDOMUtil.load((File)pomFilePath);
            Element dependenciesElement = null;
            for (Element childElement : rootElement.getChildren()) {
                if (!"dependencies".equals(childElement.getName())) continue;
                dependenciesElement = childElement;
                break;
            }
            if (dependenciesElement != null) {
                for (Element childElement : dependenciesElement.getChildren()) {
                    PsArtifactDependencySpec spec;
                    if (!"dependency".equals(childElement.getName()) || (spec = MavenPoms.createSpec(childElement)) == null) continue;
                    dependencies2.add(spec);
                }
            }
        }
        catch (Exception e) {
            String msg = String.format("Failed to obtain dependencies in POM file '%1$s", pomFilePath.getPath());
            LOG.warn(msg, (Throwable)e);
        }
        return dependencies2;
    }

    @Nullable
    private static PsArtifactDependencySpec createSpec(@NotNull Element dependencyElement) {
        String artifactId = null;
        String groupId = null;
        String version2 = null;
        String scope = null;
        boolean optional = false;
        for (Element childElement : dependencyElement.getChildren()) {
            String name2 = childElement.getName();
            if ("artifactId".equals(name2)) {
                artifactId = MavenPoms.textOf(childElement);
                continue;
            }
            if ("groupId".equals(name2)) {
                groupId = MavenPoms.textOf(childElement);
                continue;
            }
            if ("version".equals(name2)) {
                version2 = MavenPoms.textOf(childElement);
                continue;
            }
            if ("optional".equals(name2)) {
                optional = Boolean.valueOf(MavenPoms.textOf(childElement));
                continue;
            }
            if (!"scope".equals(name2)) continue;
            scope = MavenPoms.textOf(childElement);
        }
        if (StringUtil.isNotEmpty(artifactId) && !optional && ("compile".equals(scope) || "runtime".equals(scope) || StringUtil.isEmpty(scope))) {
            return PsArtifactDependencySpec.Companion.create(groupId, artifactId, version2);
        }
        return null;
    }

    @Nullable
    private static String textOf(@NotNull Element e) {
        return StringUtil.nullize((String)e.getText(), (boolean)true);
    }
}

