/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.issues;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.DependencyViewIssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.issues.NavigationHyperlinkListener;
import com.android.tools.idea.gradle.structure.configurables.ui.IssuesViewerPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssuesViewer {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final DependencyViewIssuesRenderer myRenderer;
    @NotNull
    private List<IssuesViewerPanel> myIssuesPanels;
    private JPanel myIssuesPanel1;
    private JPanel myIssuesPanel2;
    private JPanel myIssuesPanel3;
    private JPanel myIssuesPanel4;
    private JPanel myMainPanel;
    @Nullable
    private Set<PsIssue> myLastDisplayedIssues = null;

    public IssuesViewer(@NotNull PsContext context, @NotNull DependencyViewIssuesRenderer renderer2) {
        this.myContext = context;
        this.myRenderer = renderer2;
        this.setupUI();
    }

    public void display(@NotNull Collection<PsIssue> issues2, @Nullable PsPath scope) {
        LinkedHashSet<PsIssue> newIssues = new LinkedHashSet<PsIssue>(issues2);
        if (newIssues.equals(this.myLastDisplayedIssues)) {
            return;
        }
        this.myLastDisplayedIssues = newIssues;
        if (newIssues.isEmpty()) {
            for (IssuesViewerPanel panel2 : this.myIssuesPanels) {
                panel2.setVisible(false);
            }
            this.revalidateAndRepaintPanels();
            return;
        }
        HashMap issuesBySeverity = Maps.newHashMap();
        for (PsIssue issue2 : newIssues) {
            PsIssue.Severity severity = issue2.getSeverity();
            List currentIssues = issuesBySeverity.computeIfAbsent(severity, k -> new ArrayList());
            currentIssues.add(issue2);
        }
        ArrayList severities = Lists.newArrayList(issuesBySeverity.keySet());
        severities.sort(Comparator.comparingInt(PsIssue.Severity::getPriority));
        int typeCount = severities.size();
        assert (typeCount < 5);
        for (int index = 3; index >= 0; --index) {
            if (typeCount <= 0) {
                this.myIssuesPanels.get(index).setVisible(false);
                continue;
            }
            PsIssue.Severity severity = (PsIssue.Severity)((Object)severities.get(--typeCount));
            this.myIssuesPanels.get(index).displayIssues(scope, this.myRenderer, severity, (List)issuesBySeverity.get((Object)severity));
            this.myIssuesPanels.get(index).setVisible(true);
        }
        this.revalidateAndRepaintPanels();
    }

    private void revalidateAndRepaintPanels() {
        for (IssuesViewerPanel panel2 : this.myIssuesPanels) {
            UiUtil.revalidateAndRepaint(panel2);
        }
        UiUtil.revalidateAndRepaint(this.myMainPanel);
    }

    @NotNull
    public JPanel getPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        Font font = UIUtil.getTreeFont();
        NavigationHyperlinkListener hyperlinkListener = new NavigationHyperlinkListener(this.myContext);
        this.myIssuesPanel1 = new IssuesViewerPanel(hyperlinkListener, font);
        this.myIssuesPanel2 = new IssuesViewerPanel(hyperlinkListener, font);
        this.myIssuesPanel3 = new IssuesViewerPanel(hyperlinkListener, font);
        this.myIssuesPanel4 = new IssuesViewerPanel(hyperlinkListener, font);
        this.myIssuesPanels = Arrays.asList((IssuesViewerPanel)this.myIssuesPanel1, (IssuesViewerPanel)this.myIssuesPanel2, (IssuesViewerPanel)this.myIssuesPanel3, (IssuesViewerPanel)this.myIssuesPanel4);
        for (IssuesViewerPanel panel2 : this.myIssuesPanels) {
            panel2.setVisible(false);
        }
    }

    private void setupUI() {
        this.createUIComponents();
        this.myMainPanel = new JPanel();
        this.myMainPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myMainPanel.add((Component)this.myIssuesPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myMainPanel.add((Component)this.myIssuesPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myMainPanel.add((Component)this.myIssuesPanel1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myMainPanel.add((Component)this.myIssuesPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
    }
}

