/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.project;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.TargetAndroidModuleNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.TargetModulesTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.GoToModuleAction;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseCollapseAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.NodeHyperlinkSupport;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;

class TargetModulesPanel
extends ToolWindowPanel {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final Tree myTree;
    @NotNull
    private final StructureTreeModel<TargetModulesTreeStructure> structureTreeModel;
    @NotNull
    private final NodeHyperlinkSupport<TargetAndroidModuleNode> myHyperlinkSupport;

    TargetModulesPanel(@NotNull PsContext context) {
        super("Target Modules/Artifacts", AllIcons.Nodes.ModuleGroup, ToolWindowAnchor.RIGHT);
        this.myContext = context;
        TargetModulesTreeStructure treeStructure = new TargetModulesTreeStructure(context.getUiSettings());
        this.structureTreeModel = new StructureTreeModel((AbstractTreeStructure)treeStructure, (Disposable)this);
        this.myTree = new Tree((TreeModel)new AsyncTreeModel(this.structureTreeModel, (Disposable)this)){

            protected void processMouseEvent(MouseEvent e) {
                TargetAndroidModuleNode node;
                int id2 = e.getID();
                if (id2 == 501 && (node = TargetModulesPanel.this.myHyperlinkSupport.getIfHyperlink(e)) != null) {
                    PsAndroidModule module = (PsAndroidModule)node.getFirstModel();
                    String name2 = module.getName();
                    TargetModulesPanel.this.myContext.setSelectedModule(name2, TargetModulesPanel.this);
                    return;
                }
                super.processMouseEvent(e);
            }
        };
        this.myTree.setRowHeight(JBUI.scale((int)24));
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                TargetModulesPanel.this.popupInvoked(x, y);
            }
        });
        this.setHeaderActions();
        this.getHeader().setPreferredFocusedComponent((JComponent)this.myTree);
        JScrollPane scrollPane2 = UiUtil.setUp((JTree)this.myTree, "targetModules");
        this.add((Component)scrollPane2, "Center");
        this.myHyperlinkSupport = new NodeHyperlinkSupport<TargetAndroidModuleNode>(this.myTree, TargetAndroidModuleNode.class, this.myContext, false);
    }

    private void setHeaderActions() {
        ArrayList<AnAction> additionalActions = new ArrayList<AnAction>();
        additionalActions.add((AnAction)new AbstractBaseCollapseAllAction(this.myTree){

            public void actionPerformed(@NotNull AnActionEvent e) {
                TargetModulesPanel.this.myTree.requestFocusInWindow();
                TreeUtil.collapseAll((JTree)TargetModulesPanel.this.myTree, (int)-1);
            }
        });
        this.getHeader().setAdditionalActions(additionalActions);
    }

    private void popupInvoked(int x, int y) {
        TargetAndroidModuleNode node = this.myHyperlinkSupport.getNodeForLocation(x, y);
        if (node != null) {
            PsAndroidModule module = (PsAndroidModule)node.getFirstModel();
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.add((AnAction)new GoToModuleAction(module.getName(), this.myContext, (JComponent)this.myTree));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group2);
            popupMenu.getComponent().show((Component)this.myTree, x, y);
        }
    }

    void displayTargetModules(@NotNull List<AbstractDependencyNode<?, ? extends PsBaseDependency>> dependencyNodes) {
        ((TargetModulesTreeStructure)this.structureTreeModel.getTreeStructure()).displayTargetModules(dependencyNodes.stream().map(AbstractDependencyNode::getModels).toList());
        this.structureTreeModel.invalidateAsync();
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose(this.myHyperlinkSupport);
    }
}

