/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.projectView;

import com.android.tools.idea.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.util.AndroidProjectUtilKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class BuildNodeDecorator
implements ProjectViewNodeDecorator {
    public void decorate(@NotNull ProjectViewNode node, @NotNull PresentationData data2) {
        File folderPath;
        IdeAndroidProject androidProject;
        if (!(node instanceof PsiDirectoryNode)) {
            return;
        }
        PsiDirectoryNode psiDirectoryNode = (PsiDirectoryNode)node;
        PsiDirectory directory = (PsiDirectory)psiDirectoryNode.getValue();
        if (directory == null || !directory.isValid()) {
            return;
        }
        Project project = directory.getProject();
        if (!AndroidProjectUtilKt.isAndroidProject(project)) {
            return;
        }
        VirtualFile folder = directory.getVirtualFile();
        if (!ProjectRootsUtil.isModuleContentRoot((VirtualFile)folder, (Project)project)) {
            return;
        }
        Object parentValue = psiDirectoryNode.getParent().getValue();
        if (!(parentValue instanceof Module)) {
            return;
        }
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(folder);
        if (module == null && !module.isDisposed()) {
            return;
        }
        GradleAndroidModel gradleModel = GradleAndroidModel.get(module);
        IdeAndroidProject ideAndroidProject = androidProject = gradleModel != null ? gradleModel.getAndroidProject() : null;
        if (androidProject == null) {
            return;
        }
        File buildFolderPath = androidProject.getBuildFolder();
        if (FileUtil.filesEqual((File)buildFolderPath, (File)(folderPath = VfsUtilCore.virtualToIoFile((VirtualFile)folder)))) {
            data2.clearText();
            data2.addText(folder.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

