/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.tools.idea.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.build.events.GradleErrorQuickFixProvider;
import com.android.tools.idea.gradle.project.sync.issues.AgpUsedJavaTooLowReporter;
import com.android.tools.idea.gradle.project.sync.issues.AndroidXUsedReporter;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.BuildToolsTooLowReporter;
import com.android.tools.idea.gradle.project.sync.issues.CompileSdkVersionTooHighReporter;
import com.android.tools.idea.gradle.project.sync.issues.CxxConfigurationIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.DeprecatedConfigurationReporter;
import com.android.tools.idea.gradle.project.sync.issues.ExceptionSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.JcenterDeprecatedReporter;
import com.android.tools.idea.gradle.project.sync.issues.LibraryConstraintsEnabledReporter;
import com.android.tools.idea.gradle.project.sync.issues.MinSdkInManifestIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.MissingComposeCompilerGradlePluginReporter;
import com.android.tools.idea.gradle.project.sync.issues.MissingSdkIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.MissingSdkPackageSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.OutOfDateThirdPartyPluginIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporterUtils;
import com.android.tools.idea.gradle.project.sync.issues.TargetSdkInManifestIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnhandledIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.project.hyperlink.SyncMessageHyperlink;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.project.messages.SyncMessageWithContext;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

public class SyncIssuesReporter {
    @NotNull
    private final Map<Integer, BaseSyncIssuesReporter> myStrategies = new HashMap<Integer, BaseSyncIssuesReporter>(12);
    @NotNull
    private final BaseSyncIssuesReporter myDefaultMessageFactory;

    @NotNull
    public static SyncIssuesReporter getInstance() {
        return (SyncIssuesReporter)ApplicationManager.getApplication().getService(SyncIssuesReporter.class);
    }

    public SyncIssuesReporter() {
        this(new UnresolvedDependenciesReporter(), new BuildToolsTooLowReporter(), new MissingSdkPackageSyncIssuesReporter(), new MinSdkInManifestIssuesReporter(), new TargetSdkInManifestIssuesReporter(), new DeprecatedConfigurationReporter(), new MissingSdkIssueReporter(), new OutOfDateThirdPartyPluginIssueReporter(), new CxxConfigurationIssuesReporter(), new AndroidXUsedReporter(), new JcenterDeprecatedReporter(), new AgpUsedJavaTooLowReporter(), new ExceptionSyncIssuesReporter(), new CompileSdkVersionTooHighReporter(), new MissingComposeCompilerGradlePluginReporter(), new LibraryConstraintsEnabledReporter());
    }

    @NonInjectable
    @VisibleForTesting
    SyncIssuesReporter(BaseSyncIssuesReporter ... strategies) {
        for (BaseSyncIssuesReporter strategy : strategies) {
            int issueType = strategy.getSupportedIssueType();
            this.myStrategies.put(issueType, strategy);
        }
        this.myDefaultMessageFactory = new UnhandledIssuesReporter();
    }

    public void report(@NotNull Map<Module, List<IdeSyncIssue>> issuesByModules, @SystemIndependent String rootProjectPath) {
        if (issuesByModules.isEmpty()) {
            return;
        }
        LinkedHashMap syncIssues = new LinkedHashMap();
        IdentityHashMap<IdeSyncIssue, Module> moduleMap = new IdentityHashMap<IdeSyncIssue, Module>();
        LinkedHashMap<Module, VirtualFile> buildFileMap = new LinkedHashMap<Module, VirtualFile>();
        Project project = null;
        for (Module module : issuesByModules.keySet()) {
            project = module.getProject();
            buildFileMap.put(module, GradleProjectSystemUtil.getGradleBuildFile(module));
            issuesByModules.get(module).forEach(issue2 -> {
                if (issue2 != null) {
                    syncIssues.computeIfAbsent(issue2.getType(), type -> new ArrayList()).add(issue2);
                    moduleMap.put((IdeSyncIssue)issue2, module);
                }
            });
        }
        Map sortedSyncIssues = syncIssues.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue(Comparator.comparing(issues2 -> ((IdeSyncIssue)issues2.get(0)).getSeverity())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        SyncIssueUsageReporter syncIssueUsageReporter = SyncIssueUsageReporter.Companion.getInstance(project);
        ArrayList<SyncMessage> syncMessages = new ArrayList<SyncMessage>();
        for (Map.Entry entry : sortedSyncIssues.entrySet()) {
            BaseSyncIssuesReporter strategy = this.myStrategies.get(entry.getKey());
            if (strategy == null) {
                strategy = this.myDefaultMessageFactory;
            }
            List<SyncMessageWithContext> messages = strategy.reportAll((List)entry.getValue(), moduleMap, buildFileMap);
            List<SyncMessage> finalMessages = SyncIssuesReporter.addAdditionalIssueLinks(messages, buildFileMap, rootProjectPath);
            SyncIssueUsageReporterUtils.collect(syncIssueUsageReporter, (Integer)entry.getKey(), finalMessages);
            syncMessages.addAll(finalMessages);
        }
        GradleSyncMessages gradleSyncMessages = GradleSyncMessages.getInstance(project);
        for (SyncMessage syncMessage : syncMessages) {
            gradleSyncMessages.report(syncMessage);
        }
        Project finalProject = project;
        Runnable reportTask = () -> SyncIssueUsageReporter.Companion.getInstance(finalProject).reportToUsageTracker(rootProjectPath);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            reportTask.run();
        } else {
            ApplicationManager.getApplication().invokeLater(reportTask);
        }
    }

    private static List<SyncMessage> addAdditionalIssueLinks(@NotNull List<SyncMessageWithContext> syncMessages, Map<Module, VirtualFile> buildFileMap, @SystemIndependent String rootProjectPath) {
        List<GradleErrorQuickFixProvider> providers = GradleErrorQuickFixProvider.Companion.getProviders();
        ArrayList<SyncMessage> updatedMessages = new ArrayList<SyncMessage>(syncMessages.size());
        for (SyncMessageWithContext syncMessage : syncMessages) {
            SyncMessage originalSyncMessage = syncMessage.getSyncMessage();
            SyncMessage updatedMessage = originalSyncMessage.copy();
            for (GradleErrorQuickFixProvider provider : providers) {
                SyncMessageHyperlink link2 = provider.createSyncMessageAdditionalLink(originalSyncMessage, syncMessage.getAffectedModules(), buildFileMap, rootProjectPath);
                if (link2 == null) continue;
                updatedMessage.add(link2);
            }
            updatedMessages.add(updatedMessage);
        }
        return updatedMessages;
    }

    @VisibleForTesting
    @NotNull
    Map<Integer, BaseSyncIssuesReporter> getStrategies() {
        return this.myStrategies;
    }

    @VisibleForTesting
    @NotNull
    BaseSyncIssuesReporter getDefaultMessageFactory() {
        return this.myDefaultMessageFactory;
    }
}

