/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.build.output.BuildOutputErrorsListener;
import com.android.tools.idea.gradle.project.build.output.tomlParser.TomlErrorParser;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateHolder;
import com.android.tools.idea.gradle.project.sync.issues.GradleExceptionAnalyticsSupport;
import com.android.tools.idea.gradle.project.sync.issues.SyncFailureUsageReporterKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.BuildErrorMessage;
import com.google.wireless.android.sdk.stats.BuildOutputWindowStats;
import com.google.wireless.android.sdk.stats.GradleFailureDetails;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.SyncViewManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rd.util.PlatformDependentKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0013J\u001b\u0010\u0014\u001a\u00020\r2\u000b\u0010\u0012\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0015\u001a\u00020\u0007J/\u0010\u0016\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0012\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0018H\u0002J\u001d\u0010\u001b\u001a\u00020\r2\u000b\u0010\u0012\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/SyncFailureUsageReporter;", "", "<init>", "()V", "collectedFailureTypesByProjectPath", "", "", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$GradleSyncFailure;", "collectedFailureDetailsByProjectPath", "Lcom/google/wireless/android/sdk/stats/GradleFailureDetails;", "collectedFailureDetailsByBuildId", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "onSyncStart", "", "externalSystemTaskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "project", "Lcom/intellij/openapi/project/Project;", "rootProjectPath", "Lorg/jetbrains/annotations/SystemIndependent;", "collectFailure", "failure", "collectProcessedError", "processedError", "", "deriveSyncFailureFromProcessedError", "error", "collectUnprocessedGradleError", "gradleError", "extractGradleFailureDetails", "Companion", "intellij.android.projectSystem.gradle"})
public final class SyncFailureUsageReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, AndroidStudioEvent.GradleSyncFailure> collectedFailureTypesByProjectPath = PlatformDependentKt.concurrentMapOf();
    @NotNull
    private final Map<String, GradleFailureDetails> collectedFailureDetailsByProjectPath = PlatformDependentKt.concurrentMapOf();
    @NotNull
    private final Map<Object, AndroidStudioEvent.Builder> collectedFailureDetailsByBuildId = PlatformDependentKt.concurrentMapOf();

    public final void onSyncStart(@Nullable ExternalSystemTaskId externalSystemTaskId, @NotNull Project project, @NotNull String rootProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        if (externalSystemTaskId == null) {
            return;
        }
        this.collectedFailureTypesByProjectPath.remove(rootProjectPath);
        this.collectedFailureDetailsByProjectPath.remove(rootProjectPath);
        Disposable disposable = Disposer.newDisposable((String)"syncViewListenerDisposable");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        Disposer.register((Disposable)((Disposable)project), (Disposable)disposable2);
        BuildOutputErrorsListener errorsListener = new BuildOutputErrorsListener(externalSystemTaskId, disposable2, (Function1<? super List<BuildErrorMessage>, Unit>)((Function1)arg_0 -> SyncFailureUsageReporter.onSyncStart$lambda$1(this, externalSystemTaskId, arg_0)));
        Disposer.register((Disposable)disposable2, () -> SyncFailureUsageReporter.onSyncStart$lambda$2(this, externalSystemTaskId));
        ((SyncViewManager)project.getService(SyncViewManager.class)).addListener((BuildProgressListener)errorsListener, disposable2);
    }

    public final void collectFailure(@NotNull String rootProjectPath, @NotNull AndroidStudioEvent.GradleSyncFailure failure) {
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        AndroidStudioEvent.GradleSyncFailure previousValue = this.collectedFailureTypesByProjectPath.put(rootProjectPath, failure);
        if (previousValue != null) {
            SyncFailureUsageReporterKt.access$getLOG$p().warn("Multiple sync failures reported. Discarding: " + previousValue);
        }
    }

    public final void collectProcessedError(@Nullable ExternalSystemTaskId externalSystemTaskId, @NotNull Project project, @NotNull String rootProjectPath, @Nullable Throwable processedError) {
        GradleFailureDetails gradleFailureDetails;
        AndroidStudioEvent.GradleSyncFailure failureType;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        if (externalSystemTaskId == null) {
            return;
        }
        AndroidStudioEvent.GradleSyncFailure gradleSyncFailure = this.collectedFailureTypesByProjectPath.remove(rootProjectPath);
        if (gradleSyncFailure == null) {
            gradleSyncFailure = failureType = this.deriveSyncFailureFromProcessedError(processedError);
        }
        if ((gradleFailureDetails = this.collectedFailureDetailsByProjectPath.remove(rootProjectPath)) == null && (gradleFailureDetails = this.extractGradleFailureDetails(processedError)) == null) {
            gradleFailureDetails = GradleFailureDetails.newBuilder().build();
        }
        GradleFailureDetails failureErrorDetails = gradleFailureDetails;
        GradleSyncStateHolder syncStateHolder = GradleSyncStateHolder.Companion.getInstance(project);
        this.collectedFailureDetailsByBuildId.put(externalSystemTaskId, syncStateHolder.generateSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE_DETAILS, rootProjectPath).setGradleSyncFailure(failureType).setGradleFailureDetails(failureErrorDetails));
    }

    private final AndroidStudioEvent.GradleSyncFailure deriveSyncFailureFromProcessedError(Throwable error) {
        AndroidStudioEvent.GradleSyncFailure gradleSyncFailure;
        block1: {
            Object object;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block3: {
                                            block2: {
                                                block0: {
                                                    if (!(error instanceof BuildIssueException)) break block0;
                                                    String string = ((BuildIssueException)error).getBuildIssue().getClass().getPackageName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
                                                    gradleSyncFailure = StringsKt.startsWith$default((String)string, (String)"com.android.tools.", (boolean)false, (int)2, null) ? AndroidStudioEvent.GradleSyncFailure.ANDROID_BUILD_ISSUE_CREATED_UNKNOWN_FAILURE : (Intrinsics.areEqual((Object)((BuildIssueException)error).getBuildIssue().getTitle(), (Object)GradleBundle.message((String)"gradle.build.issue.gradle.unsupported.title", (Object[])new Object[0])) ? AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION : AndroidStudioEvent.GradleSyncFailure.BUILD_ISSUE_CREATED_UNKNOWN_FAILURE);
                                                    break block1;
                                                }
                                                Object object2 = error;
                                                boolean bl = object2 != null && (object2 = ((Throwable)object2).getMessage()) != null ? StringsKt.startsWith$default((String)object2, (String)"Could not find method ", (boolean)false, (int)2, null) : false;
                                                if (!bl) break block2;
                                                gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.DSL_METHOD_NOT_FOUND;
                                                break block1;
                                            }
                                            Object object3 = error;
                                            boolean bl = object3 != null && (object3 = ((Throwable)object3).getMessage()) != null ? StringsKt.startsWith$default((String)object3, (String)"Could not get unknown property ", (boolean)false, (int)2, null) : false;
                                            if (!bl) break block3;
                                            gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.DSL_METHOD_NOT_FOUND;
                                            break block1;
                                        }
                                        Object object4 = error;
                                        boolean bl = object4 != null && (object4 = ((Throwable)object4).getMessage()) != null ? StringsKt.startsWith$default((String)object4, (String)"Could not set unknown property ", (boolean)false, (int)2, null) : false;
                                        if (!bl) break block4;
                                        gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.DSL_METHOD_NOT_FOUND;
                                        break block1;
                                    }
                                    Object object5 = error;
                                    boolean bl = object5 != null && (object5 = ((Throwable)object5).getMessage()) != null ? StringsKt.startsWith$default((String)object5, (String)"Script compilation error:", (boolean)false, (int)2, null) : false;
                                    if (!bl) break block5;
                                    gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.KTS_COMPILATION_ERROR;
                                    break block1;
                                }
                                Object object6 = error;
                                boolean bl = object6 != null && (object6 = ((Throwable)object6).getMessage()) != null ? StringsKt.startsWith$default((String)object6, (String)"Compilation failed; see the compiler ", (boolean)false, (int)2, null) : false;
                                if (!bl) break block6;
                                gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.JAVA_COMPILATION_ERROR;
                                break block1;
                            }
                            Object object7 = error;
                            boolean bl = object7 != null && (object7 = ((Throwable)object7).getMessage()) != null ? StringsKt.startsWith$default((String)object7, (String)"Cannot cast object ", (boolean)false, (int)2, null) : false;
                            if (!bl) break block7;
                            gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.CANNOT_BE_CAST_TO;
                            break block1;
                        }
                        Throwable throwable = error;
                        boolean bl = throwable != null ? TomlErrorParser.Companion.isTomlError(throwable) : false;
                        if (!bl) break block8;
                        gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.INVALID_TOML_DEFINITION;
                        break block1;
                    }
                    Object object8 = error;
                    boolean bl = object8 != null && (object8 = ((Throwable)object8).getCause()) != null && (object8 = ((Throwable)object8).toString()) != null ? StringsKt.startsWith$default((String)object8, (String)"org.codehaus.groovy.control.MultipleCompilationErrorsException:", (boolean)false, (int)2, null) : false;
                    if (!bl) break block9;
                    gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.GROOVY_COMPILATION_ERROR;
                    break block1;
                }
                Object object9 = error;
                boolean bl = object9 != null && (object9 = ((Throwable)object9).getCause()) != null && (object9 = ((Throwable)object9).toString()) != null ? StringsKt.startsWith$default((String)object9, (String)"org.gradle.api.plugins.UnknownPluginException: Plugin [id: 'com.android.", (boolean)false, (int)2, null) : false;
                if (!bl) break block10;
                gradleSyncFailure = AndroidStudioEvent.GradleSyncFailure.UNKNOWN_PLUGIN_COM_ANDROID;
                break block1;
            }
            Object object10 = error;
            gradleSyncFailure = (object10 != null && (object10 = ((Throwable)object10).getCause()) != null && (object10 = ((Throwable)object10).toString()) != null ? StringsKt.startsWith$default((String)object10, (String)"org.gradle.api.plugins.UnknownPluginException: Plugin [id: '", (boolean)false, (int)2, null) : false) ? AndroidStudioEvent.GradleSyncFailure.UNKNOWN_PLUGIN_OTHER : (((object = error) != null && (object = ((Throwable)object).getCause()) != null && (object = ((Throwable)object).toString()) != null ? StringsKt.startsWith$default((String)object, (String)"org.gradle.internal.resolve.ModuleVersionNotFoundException:", (boolean)false, (int)2, null) : false) ? AndroidStudioEvent.GradleSyncFailure.MISSING_DEPENDENCY_OTHER : AndroidStudioEvent.GradleSyncFailure.UNKNOWN_GRADLE_FAILURE);
        }
        return gradleSyncFailure;
    }

    public final void collectUnprocessedGradleError(@NotNull String rootProjectPath, @Nullable Throwable gradleError) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
            GradleFailureDetails gradleFailureDetails = this.extractGradleFailureDetails(gradleError);
            if (gradleFailureDetails == null) break block0;
            GradleFailureDetails gradleFailureDetails2 = gradleFailureDetails;
            boolean bl = false;
            this.collectedFailureDetailsByProjectPath.put(rootProjectPath, gradleFailureDetails2);
        }
    }

    private final GradleFailureDetails extractGradleFailureDetails(Throwable gradleError) {
        if (gradleError == null) {
            return null;
        }
        return new GradleExceptionAnalyticsSupport().extractFailureDetails(gradleError).toAnalyticsMessage();
    }

    private static final Unit onSyncStart$lambda$1(SyncFailureUsageReporter this$0, ExternalSystemTaskId $externalSystemTaskId, List buildErrorMessages) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)buildErrorMessages, (String)"buildErrorMessages");
            AndroidStudioEvent.Builder builder = this$0.collectedFailureDetailsByBuildId.get($externalSystemTaskId);
            if (builder == null) break block0;
            AndroidStudioEvent.Builder it = builder;
            boolean bl = false;
            BuildOutputWindowStats buildOutputWindowStats = BuildOutputWindowStats.newBuilder().addAllBuildErrorMessages((Iterable)buildErrorMessages).build();
            AndroidStudioEvent.Builder builder2 = it.setBuildOutputWindowStats(buildOutputWindowStats);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setBuildOutputWindowStats(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder2);
        }
        return Unit.INSTANCE;
    }

    private static final void onSyncStart$lambda$2(SyncFailureUsageReporter this$0, ExternalSystemTaskId $externalSystemTaskId) {
        this$0.collectedFailureDetailsByBuildId.remove($externalSystemTaskId);
    }

    @JvmStatic
    @NotNull
    public static final SyncFailureUsageReporter getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/SyncFailureUsageReporter$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/gradle/project/sync/issues/SyncFailureUsageReporter;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SyncFailureUsageReporter getInstance() {
            Object object = ApplicationManager.getApplication().getService(SyncFailureUsageReporter.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (SyncFailureUsageReporter)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

