/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.issues.SyncFailureUsageReporter;
import com.android.tools.idea.gradle.project.sync.quickFixes.InstallBuildToolsQuickFix;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002JD\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001c0\u001bH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingBuildToolsIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "MISSING_BUILD_TOOLS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "EXCEPTION_ILLEGAL_PATTERN", "EXCEPTION_EXTERNAL_SYSTEM_PATTERN", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "getBuildIssueDescription", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/BuildIssueComposer;", "message", "", "version", "consumeBuildOutputFailureMessage", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.android.projectSystem.gradle"})
public final class MissingBuildToolsIssueChecker
implements GradleIssueChecker {
    private final Pattern MISSING_BUILD_TOOLS_PATTERN = Pattern.compile("(Cause: )?([Ff])ailed to find Build Tools revision (.*)");
    private final Pattern EXCEPTION_ILLEGAL_PATTERN = Pattern.compile("Caused by: java.lang.IllegalStateException(.*)");
    private final Pattern EXCEPTION_EXTERNAL_SYSTEM_PATTERN = Pattern.compile("Caused by: com.intellij.openapi.externalSystem.model.ExternalSystemException(.*)");

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String message = string;
        if (StringsKt.isBlank((CharSequence)message) || !(rootCause instanceof IllegalStateException) && !(rootCause instanceof ExternalSystemException)) {
            return null;
        }
        Matcher matcher = this.MISSING_BUILD_TOOLS_PATTERN.matcher((CharSequence)StringsKt.lines((CharSequence)message).get(0));
        if (!matcher.matches()) {
            return null;
        }
        SyncFailureUsageReporter.Companion.getInstance().collectFailure(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.MISSING_BUILD_TOOLS);
        String version2 = matcher.group(3);
        Intrinsics.checkNotNull((Object)version2);
        BuildIssueComposer buildIssueComposer = this.getBuildIssueDescription(message, version2);
        return buildIssueComposer.composeBuildIssue();
    }

    private final BuildIssueComposer getBuildIssueDescription(String message, String version2) {
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message, null, 2, null);
        buildIssueComposer.addQuickFix("Install Build Tools " + version2 + " and sync project", new InstallBuildToolsQuickFix(version2, CollectionsKt.emptyList(), false));
        return buildIssueComposer;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return stacktrace != null && (this.EXCEPTION_ILLEGAL_PATTERN.matcher(stacktrace).find() || this.EXCEPTION_EXTERNAL_SYSTEM_PATTERN.matcher(stacktrace).find()) && this.MISSING_BUILD_TOOLS_PATTERN.matcher((CharSequence)StringsKt.lines((CharSequence)failureCause).get(0)).matches();
    }
}

