/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.ide.common.gradle.Version;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.gradle.model.IdeDependencies;
import com.android.tools.idea.gradle.project.GradleVersionCatalogDetector;
import com.android.tools.idea.gradle.project.model.GradleAndroidDependencyModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncEventLoggerKt;
import com.android.tools.idea.gradle.project.sync.GradleSyncPhaseStartEvent;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.google.common.collect.Ordering;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.google.wireless.android.sdk.stats.KotlinSupport;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 J&\u0010!\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J@\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\r\u0010+\u001a\t\u0018\u00010,\u00a2\u0006\u0002\b-2\u0006\u0010.\u001a\u00020/2\u0019\b\u0002\u00100\u001a\u0013\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001801\u00a2\u0006\u0002\b3R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/idea/gradle/project/sync/GradleSyncEventLogger;", "", "now", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getNow", "()Lkotlin/jvm/functions/Function0;", "syncStartedTimeStamp", "syncSetupStartedTimeStamp", "syncEndedTimeStamp", "gradleSyncPhasesProfile", "Ljava/util/ArrayList;", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$GradleSyncPhaseData;", "Lkotlin/collections/ArrayList;", "phasesStack", "Lkotlin/collections/ArrayDeque;", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncPhaseStartEvent;", "syncType", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$GradleSyncType;", "trigger", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$Trigger;", "syncStarted", "", "setupStarted", "syncEnded", "success", "", "syncCancelled", "syncPhaseStarted", "phase", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$GradleSyncPhaseData$SyncPhase;", "gradlePhaseFinished", "startTimestamp", "endTimestamp", "status", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$GradleSyncPhaseData$PhaseResult;", "stopAllPhases", "generateSyncEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "project", "Lcom/intellij/openapi/project/Project;", "rootProjectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "kind", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$EventKind;", "updateAdditionalData", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$Builder;", "Lkotlin/ExtensionFunctionType;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleSyncEventLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleSyncEventLogger.kt\ncom/android/tools/idea/gradle/project/sync/GradleSyncEventLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1563#2:243\n1634#2,3:244\n1563#2:247\n1634#2,3:248\n1869#2,2:264\n11546#3,9:251\n13472#3:260\n13473#3:262\n11555#3:263\n1#4:261\n1#4:266\n*S KotlinDebug\n*F\n+ 1 GradleSyncEventLogger.kt\ncom/android/tools/idea/gradle/project/sync/GradleSyncEventLogger\n*L\n107#1:243\n107#1:244,3\n117#1:247\n117#1:248,3\n139#1:264,2\n139#1:251,9\n139#1:260\n139#1:262\n139#1:263\n139#1:261\n*E\n"})
public final class GradleSyncEventLogger {
    @NotNull
    private final Function0<Long> now;
    private long syncStartedTimeStamp;
    private long syncSetupStartedTimeStamp;
    private long syncEndedTimeStamp;
    @NotNull
    private final ArrayList<GradleSyncStats.GradleSyncPhaseData> gradleSyncPhasesProfile;
    @NotNull
    private final ArrayDeque<GradleSyncPhaseStartEvent> phasesStack;
    @Nullable
    private GradleSyncStats.GradleSyncType syncType;
    @Nullable
    private GradleSyncStats.Trigger trigger;

    public GradleSyncEventLogger(@NotNull Function0<Long> now) {
        Intrinsics.checkNotNullParameter(now, (String)"now");
        this.now = now;
        this.syncStartedTimeStamp = -1L;
        this.syncSetupStartedTimeStamp = -1L;
        this.syncEndedTimeStamp = -1L;
        this.gradleSyncPhasesProfile = new ArrayList();
        this.phasesStack = new ArrayDeque();
    }

    public /* synthetic */ GradleSyncEventLogger(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = GradleSyncEventLogger::_init_$lambda$0;
        }
        this((Function0<Long>)function0);
    }

    @NotNull
    public final Function0<Long> getNow() {
        return this.now;
    }

    public final synchronized void syncStarted(@NotNull GradleSyncStats.GradleSyncType syncType, @NotNull GradleSyncStats.Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)syncType, (String)"syncType");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        this.syncStartedTimeStamp = ((Number)this.now.invoke()).longValue();
        this.syncSetupStartedTimeStamp = -1L;
        this.syncEndedTimeStamp = -1L;
        this.phasesStack.clear();
        this.gradleSyncPhasesProfile.clear();
        this.syncType = syncType;
        this.trigger = trigger;
        this.syncPhaseStarted(GradleSyncStats.GradleSyncPhaseData.SyncPhase.SYNC_TOTAL);
    }

    public final synchronized long setupStarted() {
        this.syncSetupStartedTimeStamp = ((Number)this.now.invoke()).longValue();
        this.syncPhaseStarted(GradleSyncStats.GradleSyncPhaseData.SyncPhase.PROJECT_SETUP);
        return this.syncSetupStartedTimeStamp - this.syncStartedTimeStamp;
    }

    public final synchronized long syncEnded(boolean success) {
        this.syncEndedTimeStamp = ((Number)this.now.invoke()).longValue();
        if (success) {
            this.stopAllPhases(GradleSyncStats.GradleSyncPhaseData.PhaseResult.SUCCESS);
        } else {
            this.stopAllPhases(GradleSyncStats.GradleSyncPhaseData.PhaseResult.FAILURE);
        }
        return this.syncEndedTimeStamp - this.syncStartedTimeStamp;
    }

    public final synchronized void syncCancelled() {
        this.stopAllPhases(GradleSyncStats.GradleSyncPhaseData.PhaseResult.CANCELLED);
    }

    public final synchronized void syncPhaseStarted(@NotNull GradleSyncStats.GradleSyncPhaseData.SyncPhase phase) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        this.phasesStack.addLast((Object)new GradleSyncPhaseStartEvent(phase, ((Number)this.now.invoke()).longValue()));
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void gradlePhaseFinished(@NotNull GradleSyncStats.GradleSyncPhaseData.SyncPhase phase, long startTimestamp, long endTimestamp, @NotNull GradleSyncStats.GradleSyncPhaseData.PhaseResult status2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        GradleSyncPhaseStartEvent gradleSyncPhaseStartEvent = (GradleSyncPhaseStartEvent)this.phasesStack.lastOrNull();
        if ((gradleSyncPhaseStartEvent != null ? gradleSyncPhaseStartEvent.getPhase() : null) == phase) {
            this.phasesStack.removeLastOrNull();
        }
        Iterable iterable = (Iterable)this.phasesStack;
        GradleSyncStats.GradleSyncPhaseData.Builder builder = GradleSyncStats.GradleSyncPhaseData.newBuilder();
        boolean $i$f$map = false;
        void var10_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GradleSyncPhaseStartEvent gradleSyncPhaseStartEvent2 = (GradleSyncPhaseStartEvent)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getPhase());
        }
        GradleSyncStats.GradleSyncPhaseData.Builder finishedPhaseData = builder.addAllPhaseStack((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)phase)).setPhaseStartTimestampMs(startTimestamp).setPhaseEndTimestampMs(endTimestamp).setPhaseResult(status2);
        this.gradleSyncPhasesProfile.add(finishedPhaseData.build());
    }

    /*
     * WARNING - void declaration
     */
    private final void stopAllPhases(GradleSyncStats.GradleSyncPhaseData.PhaseResult status2) {
        while (!((Collection)this.phasesStack).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)this.phasesStack;
            GradleSyncStats.GradleSyncPhaseData.Builder builder = GradleSyncStats.GradleSyncPhaseData.newBuilder();
            boolean $i$f$map = false;
            void var5_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GradleSyncPhaseStartEvent gradleSyncPhaseStartEvent = (GradleSyncPhaseStartEvent)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getPhase());
            }
            GradleSyncStats.GradleSyncPhaseData.Builder finishedPhaseData = builder.addAllPhaseStack((Iterable)((List)destination$iv$iv)).setPhaseStartTimestampMs(((GradleSyncPhaseStartEvent)this.phasesStack.last()).getStartTimestamp()).setPhaseEndTimestampMs(this.syncEndedTimeStamp).setPhaseResult(status2);
            this.gradleSyncPhasesProfile.add(finishedPhaseData.build());
            this.phasesStack.removeLast();
        }
    }

    @NotNull
    public final synchronized AndroidStudioEvent.Builder generateSyncEvent(@NotNull Project project, @Nullable String rootProjectPath, @NotNull AndroidStudioEvent.EventKind kind, @NotNull Function1<? super GradleSyncStats.Builder, Unit> updateAdditionalData) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter(updateAdditionalData, (String)"updateAdditionalData");
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
        GradleSyncStats.Builder syncStats = GradleSyncStats.newBuilder();
        Set<GradleProjectSystemUtil.BuildFileType> buildFileTypes = GradleProjectSystemUtil.projectBuildFilesTypes(project);
        syncStats.setTotalTimeMs(this.syncEndedTimeStamp >= 0L ? this.syncEndedTimeStamp - this.syncStartedTimeStamp : (this.syncSetupStartedTimeStamp >= 0L ? this.syncSetupStartedTimeStamp - this.syncStartedTimeStamp : 0L));
        syncStats.setIdeTimeMs(this.syncEndedTimeStamp < 0L ? -1L : (this.syncSetupStartedTimeStamp < 0L ? -1L : this.syncEndedTimeStamp - this.syncSetupStartedTimeStamp));
        syncStats.setGradleTimeMs(this.syncSetupStartedTimeStamp >= 0L ? this.syncSetupStartedTimeStamp - this.syncStartedTimeStamp : -1L);
        GradleSyncStats.Trigger trigger = this.trigger;
        if (trigger == null) {
            trigger = GradleSyncStats.Trigger.TRIGGER_UNKNOWN;
        }
        syncStats.setTrigger(trigger);
        GradleSyncStats.GradleSyncType gradleSyncType = this.syncType;
        if (gradleSyncType == null) {
            gradleSyncType = GradleSyncStats.GradleSyncType.GRADLE_SYNC_TYPE_UNKNOWN;
        }
        syncStats.setSyncType(gradleSyncType);
        syncStats.setUsesBuildGradle(buildFileTypes.contains((Object)GradleProjectSystemUtil.BuildFileType.GROOVY));
        syncStats.setUsesBuildGradleKts(buildFileTypes.contains((Object)GradleProjectSystemUtil.BuildFileType.KOTLIN_SCRIPT));
        syncStats.setVersionCatalogDetectorState(GradleVersionCatalogDetector.Companion.getInstance(project).getVersionCatalogDetectorResultIfAvailable().getState());
        if (rootProjectPath != null) {
            Intrinsics.checkNotNull((Object)syncStats);
            GradleSyncEventLoggerKt.access$updateUserRequestedParallelSyncMode(syncStats, project, rootProjectPath);
        }
        Intrinsics.checkNotNull((Object)syncStats);
        updateAdditionalData.invoke((Object)syncStats);
        if (kind == AndroidStudioEvent.EventKind.GRADLE_SYNC_ENDED || kind == AndroidStudioEvent.EventKind.GRADLE_SYNC_CANCELLED || kind == AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE || kind == AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE_DETAILS) {
            syncStats.addAllGradleSyncPhasesData((Iterable)this.gradleSyncPhasesProfile);
        }
        if (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()] == 1) {
            object = GradleVersions.getInstance().getGradleVersion(project);
            if (object == null || (object = object.getVersion()) == null) {
                object = "";
            }
        } else {
            object = null;
        }
        GradleVersion gradleVersion2 = object;
        ActionsKt.runReadAction(() -> GradleSyncEventLogger.generateSyncEvent$lambda$7(project, syncStats, event, kind, (String)gradleVersion2));
        Intrinsics.checkNotNull((Object)event);
        return event;
    }

    public static /* synthetic */ AndroidStudioEvent.Builder generateSyncEvent$default(GradleSyncEventLogger gradleSyncEventLogger, Project project, String string, AndroidStudioEvent.EventKind eventKind, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = GradleSyncEventLogger::generateSyncEvent$lambda$3;
        }
        return gradleSyncEventLogger.generateSyncEvent(project, string, eventKind, (Function1<? super GradleSyncStats.Builder, Unit>)function1);
    }

    private static final long _init_$lambda$0() {
        return System.currentTimeMillis();
    }

    private static final Unit generateSyncEvent$lambda$3(GradleSyncStats.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"<this>");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinSupport.Builder generateSyncEvent$generateKotlinSupport(Project $project) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Object kotlinVersion = null;
        Object ktxVersion = null;
        Ordering ordering = Ordering.natural().nullsFirst();
        Object $this$mapNotNull$iv = ModuleManager.Companion.getInstance($project).getModules();
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            GradleAndroidDependencyModel it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void module = element$iv$iv;
            boolean bl2 = false;
            if (GradleAndroidDependencyModel.Companion.get((Module)module) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleAndroidDependencyModel model = (GradleAndroidDependencyModel)element$iv;
            boolean bl = false;
            IdeDependencies dependencies2 = model.getMainArtifactWithDependencies().getCompileClasspath();
            kotlinVersion = ordering.max(kotlinVersion, (Object)GradleSyncEventLoggerKt.access$findVersion(dependencies2.getLibraries(), "org.jetbrains.kotlin", "kotlin-stdlib"));
            ktxVersion = ordering.max(ktxVersion, (Object)GradleSyncEventLoggerKt.access$findVersion(dependencies2.getLibraries(), "androidx.core", "core-ktx"));
        }
        KotlinSupport.Builder kotlinSupport = KotlinSupport.newBuilder();
        if (kotlinVersion != null) {
            kotlinSupport.setKotlinSupportVersion(((Version)kotlinVersion).toString());
        }
        if (ktxVersion != null) {
            kotlinSupport.setAndroidKtxVersion(((Version)ktxVersion).toString());
        }
        Intrinsics.checkNotNull((Object)kotlinSupport);
        return kotlinSupport;
    }

    private static final Unit generateSyncEvent$lambda$7(Project $project, GradleSyncStats.Builder $syncStats, AndroidStudioEvent.Builder $event, AndroidStudioEvent.EventKind $kind, String $gradleVersion) {
        String lastSuccessfulVersion;
        String lastKnownVersion = GradleProjectSystemUtil.getLastKnownAndroidGradlePluginVersion($project);
        if (lastKnownVersion != null) {
            $syncStats.setLastKnownAndroidGradlePluginVersion(lastKnownVersion);
        }
        if ((lastSuccessfulVersion = GradleProjectSystemUtil.getLastSuccessfulAndroidGradlePluginVersion($project)) != null) {
            $syncStats.setAndroidGradlePluginVersion(lastSuccessfulVersion);
        }
        $event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC);
        $event.setKind($kind);
        String string = $gradleVersion;
        if (string != null) {
            String it = string;
            boolean bl = false;
            $event.setGradleVersion(it);
        }
        if ($kind == AndroidStudioEvent.EventKind.GRADLE_SYNC_ENDED) {
            $event.setKotlinSupport(GradleSyncEventLogger.generateSyncEvent$generateKotlinSupport($project));
        }
        Intrinsics.checkNotNull((Object)$event);
        UsageTrackerUtils.withProjectId($event, $project);
        $event.setGradleSyncStats($syncStats.build());
        return Unit.INSTANCE;
    }

    public GradleSyncEventLogger() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidStudioEvent.EventKind.values().length];
            try {
                nArray[AndroidStudioEvent.EventKind.GRADLE_SYNC_ENDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

