/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.gradle.project.sync.GradleFilesUpdater;
import com.android.tools.idea.res.FileRelevanceKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleFiles
implements Disposable.Default {
    @NotNull
    final Project myProject;
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final Set<VirtualFile> myChangedFiles = new HashSet<VirtualFile>();
    @NotNull
    private final Set<VirtualFile> myChangedExternalFiles = new HashSet<VirtualFile>();
    @NotNull
    private final Map<VirtualFile, Integer> myFileHashes = new HashMap<VirtualFile, Integer>();
    @NotNull
    private final Set<VirtualFile> myExternalBuildFiles = new HashSet<VirtualFile>();
    @NotNull
    private final GradleFilesUpdater myUpdater;

    @NotNull
    public static GradleFiles getInstance(@NotNull Project project) {
        return (GradleFiles)project.getService(GradleFiles.class);
    }

    private GradleFiles(@NotNull Project project) {
        this.myProject = project;
        this.myUpdater = GradleFilesUpdater.getInstance(project);
        if (this.myProject.isDefault()) {
            return;
        }
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source2, @NotNull VirtualFile file) {
                if (GradleFiles.this.hasHashForFile(file) && !GradleFiles.this.areHashesEqual(file)) {
                    GradleFiles.this.addChangedFile(file, GradleFiles.this.isExternalBuildFile(file));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHashForFile(@NotNull VirtualFile file) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.containsKey(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChangedFiles.clear();
            this.myChangedExternalFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChangedFile(@NotNull VirtualFile file, boolean isExternal) {
        Object object = this.myLock;
        synchronized (object) {
            if (isExternal) {
                this.myChangedExternalFiles.add(file);
            } else {
                this.myChangedFiles.add(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Integer getStoredHashForFile(@NotNull VirtualFile file) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsChangedFile(@NotNull VirtualFile file) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myChangedFiles.contains(file) || this.myChangedExternalFiles.contains(file);
        }
    }

    @Nullable
    static Integer computeHash(@NotNull VirtualFile file) {
        if (!file.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        return document == null ? null : Integer.valueOf(document.getText().hashCode());
    }

    private boolean areHashesEqual(@NotNull VirtualFile file) {
        Integer oldHash = this.getStoredHashForFile(file);
        return oldHash != null && oldHash.equals(GradleFiles.computeHash(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHashesOfChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            return this.filterHashes(this.myChangedFiles) && this.filterHashes(this.myChangedExternalFiles);
        }
    }

    private boolean filterHashes(@NotNull Collection<VirtualFile> files2) {
        boolean status2 = true;
        HashSet<VirtualFile> toRemove = new HashSet<VirtualFile>();
        for (VirtualFile file : files2) {
            if (!this.areHashesEqual(file)) {
                status2 = false;
                continue;
            }
            toRemove.add(file);
        }
        files2.removeAll(toRemove);
        return status2;
    }

    public Function1<? super GradleFilesUpdater.Result, Unit> updateCallback() {
        return result2 -> {
            Object object = this.myLock;
            synchronized (object) {
                this.myExternalBuildFiles.clear();
                this.myExternalBuildFiles.addAll(result2.getExternalBuildFiles());
                this.myFileHashes.clear();
                this.myFileHashes.putAll(result2.getHashes());
            }
            return Unit.INSTANCE;
        };
    }

    void scheduleUpdateFileHashes() {
        this.myUpdater.scheduleUpdateFileHashes(this.updateCallback());
    }

    public boolean areGradleFilesModified() {
        return (Boolean)ReadAction.compute(() -> !this.checkHashesOfChangedFiles());
    }

    public boolean isGradleFile(@NotNull PsiFile psiFile) {
        return FileRelevanceKt.isGradleFile(psiFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExternalBuildFile(@NotNull PsiFile psiFile) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myExternalBuildFiles.contains(psiFile.getVirtualFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExternalBuildFile(@NotNull VirtualFile virtualFile) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myExternalBuildFiles.contains(virtualFile);
        }
    }

    public void resetChangedFilesState() {
        this.removeChangedFiles();
    }

    public void maybeProcessSyncStarted() {
        if (!this.myProject.isInitialized()) {
            return;
        }
        this.resetChangedFilesState();
    }

    public void maybeProcessSyncSucceeded() {
        this.scheduleUpdateFileHashes();
    }
}

