/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.common;

import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.ide.gradle.model.GradlePluginModel;
import com.android.ide.gradle.model.builder.AndroidStudioToolingPlugin;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleInitScripts {
    @NotNull
    private final ContentCreator myContentCreator;
    @NotNull
    private static final String STUDIO_PROJECT_SYNC_DEBUG_MODE_KEY = "studio.project.sync.debug.mode";
    @NotNull
    private static final String STUDIO_PROJECT_EXCLUDED_JARS_KEY = "studio.project.sync.excluded.jars";
    @NotNull
    private static final Set<String> EXCLUDED_JARS = Set.of(Optional.ofNullable(System.getProperty("studio.project.sync.excluded.jars")).map(env -> env.split("\\s*,\\s*")).orElse(new String[0]));

    @NotNull
    public static GradleInitScripts getInstance() {
        return (GradleInitScripts)ApplicationManager.getApplication().getService(GradleInitScripts.class);
    }

    public GradleInitScripts() {
        this(new ContentCreator());
    }

    @NonInjectable
    @VisibleForTesting
    GradleInitScripts(@NotNull ContentCreator contentCreator) {
        this.myContentCreator = contentCreator;
    }

    public void addLocalMavenRepoInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        File initScriptFile = this.createLocalMavenRepoInitScriptFile();
        if (initScriptFile != null) {
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
    }

    @Nullable
    private File createLocalMavenRepoInitScriptFile() {
        List<String> repoPaths = this.getRepoPaths();
        String content2 = this.myContentCreator.createLocalMavenRepoInitScriptContent(repoPaths);
        if (content2 != null) {
            String fileName = "sync.local.repo";
            try {
                return GradleInitScripts.createInitScriptFile(fileName, content2);
            }
            catch (Throwable e) {
                String message = String.format("Failed to set up Gradle init script: '%1$s'", fileName);
                GradleInitScripts.getLogger().warn(message, e);
            }
        }
        return null;
    }

    private List<String> getRepoPaths() {
        if (!((Boolean)StudioFlags.INJECT_EXTRA_GRADLE_REPOSITORIES_WITH_INIT_SCRIPT.get()).booleanValue()) {
            return Collections.emptyList();
        }
        List repoPaths = GradleProjectSystemUtil.findAndroidStudioLocalMavenRepoPaths().stream().map(File::getPath).collect(Collectors.toCollection(ArrayList::new));
        if (!"https://maven.google.com/".equals(GoogleMavenRepositoryKt.GMAVEN_BASE_URL)) {
            repoPaths.add(GoogleMavenRepositoryKt.GMAVEN_BASE_URL);
        }
        return repoPaths;
    }

    public void addAndroidStudioToolingPluginInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        try {
            File initScriptFile = this.createAndroidStudioToolingPluginInitScriptFile();
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
        catch (IOException e) {
            GradleInitScripts.getLogger().warn("Failed to create init script that applies the Android Studio Tooling plugin.", (Throwable)e);
        }
    }

    @NotNull
    private File createAndroidStudioToolingPluginInitScriptFile() throws IOException {
        String content2 = this.myContentCreator.createAndroidStudioToolingPluginInitScriptContent();
        return GradleInitScripts.createInitScriptFile("sync.studio.tooling", content2);
    }

    @NotNull
    private static File createInitScriptFile(@NotNull String fileName, @NotNull String content2) throws IOException {
        File file = FileUtil.createTempFile((String)fileName, (String)".gradle");
        try {
            file.deleteOnExit();
            FileUtil.writeToFile((File)file, (String)content2);
            GradleInitScripts.getLogger().info(String.format("init script file %s contents %s", fileName, GradleInitScripts.escapeAsStringLiteral(content2)));
        }
        catch (Exception ex) {
            GradleInitScripts.getLogger().error("Failed to create init script: " + fileName, (Throwable)ex);
            throw ex;
        }
        return file;
    }

    private static void warnOnExcludedJarInclusion(List<String> paths) {
        String foundExcludedJars = paths.stream().filter(EXCLUDED_JARS::contains).collect(Collectors.joining());
        if (!foundExcludedJars.isEmpty()) {
            GradleInitScripts.getLogger().warn("Unexpected Jars were added as dependencies in init script: " + foundExcludedJars);
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleInitScripts.class);
    }

    @NotNull
    private static String escapeAsStringLiteral(@NotNull String s) {
        Escaper escaper = Escapers.builder().addEscape('\b', "\\b").addEscape('\t', "\\t").addEscape('\n', "\\n").addEscape('\f', "\\f").addEscape('\r', "\\r").addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();
        return "\"" + escaper.escape(s) + "\"";
    }

    private static void addInitScriptCommandLineArg(@NotNull File initScriptFile, @NotNull List<String> allArgs) {
        allArgs.add("--init-script");
        allArgs.add(initScriptFile.getAbsolutePath());
    }

    @VisibleForTesting
    static class ContentCreator {
        @NotNull
        private final AndroidStudioToolingPluginJars myAndroidStudioToolingPluginJars;

        ContentCreator() {
            this(new AndroidStudioToolingPluginJars());
        }

        ContentCreator(@NotNull AndroidStudioToolingPluginJars androidStudioToolingPluginJars) {
            this.myAndroidStudioToolingPluginJars = androidStudioToolingPluginJars;
        }

        @Nullable
        String createLocalMavenRepoInitScriptContent(@NotNull List<String> repoPaths) {
            if (repoPaths.isEmpty()) {
                return null;
            }
            StringBuilder paths = new StringBuilder();
            for (String path : repoPaths) {
                path = this.escapeGroovyStringLiteral(path);
                paths.append("      maven { url '").append(path).append("'}\n");
            }
            return "import org.gradle.util.GradleVersion\n\nallprojects {\n  buildscript {\n    repositories {\n" + String.valueOf(paths) + "    }\n  }\n  repositories {\n" + String.valueOf(paths) + "  }\n}\nif (GradleVersion.current().baseVersion >= GradleVersion.version('7.0')) {\n  beforeSettings {\n    it.pluginManagement {\n      repositories {\n" + String.valueOf(paths) + "      }\n    }\n  }\n}\nif (GradleVersion.current().baseVersion >= GradleVersion.version('6.8')) {\n  beforeSettings {\n    it.dependencyResolutionManagement {\n      repositories {\n" + String.valueOf(paths) + "      }\n    }\n  }\n}\n";
        }

        @NotNull
        String createAndroidStudioToolingPluginInitScriptContent() {
            List<String> paths = this.myAndroidStudioToolingPluginJars.getJarPaths();
            if (Boolean.getBoolean(GradleInitScripts.STUDIO_PROJECT_SYNC_DEBUG_MODE_KEY)) {
                GradleInitScripts.warnOnExcludedJarInclusion(paths);
            }
            return "import org.gradle.util.GradleVersion\ninitscript {\n    dependencies {\n        " + this.createClassPathString(paths) + "\n    }\n}\nif (GradleVersion.current() < GradleVersion.version(\"8.8\")) {\n    allprojects {\n        apply plugin: " + AndroidStudioToolingPlugin.class.getName() + "\n    }\n} else {\n    lifecycle.beforeProject {\n        apply plugin: " + AndroidStudioToolingPlugin.class.getName() + "\n    }\n\n}";
        }

        @NotNull
        String createClassPathString(@NotNull List<String> paths) {
            StringBuilder classpath = new StringBuilder();
            classpath.append("classpath files([");
            int pathCount = paths.size();
            for (int i = 0; i < pathCount; ++i) {
                String jarPath = this.escapeGroovyStringLiteral(paths.get(i));
                classpath.append("mapPath('").append(jarPath).append("')");
                if (i >= pathCount - 1) continue;
                classpath.append(", ");
            }
            classpath.append("])");
            return classpath.toString();
        }

        @NotNull
        private String escapeGroovyStringLiteral(@NotNull String s) {
            StringBuilder sb = new StringBuilder(s.length() + 5);
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                char c = s.charAt(i);
                if (c == '\\' || c == '\'') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            return sb.toString();
        }
    }

    @VisibleForTesting
    static class AndroidStudioToolingPluginJars {
        AndroidStudioToolingPluginJars() {
        }

        @NotNull
        List<String> getJarPaths() {
            return Stream.of(AndroidStudioToolingPluginJars.getJarPathForClass(GradlePluginModel.class), AndroidStudioToolingPluginJars.getJarPathForClass(AndroidStudioToolingPlugin.class), AndroidStudioToolingPluginJars.getJarPathForClass(KType.class)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private static String getJarPathForClass(@NotNull Class<?> aClass) {
            return FileUtil.toCanonicalPath((String)PathManager.getJarPathForClass(aClass));
        }
    }
}

