/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output.tomlParser;

import com.android.tools.idea.gradle.project.build.output.tomlParser.TomlErrorHandler;
import com.android.tools.idea.gradle.project.build.output.tomlParser.TomlErrorHelperKt;
import com.android.tools.idea.gradle.project.build.output.tomlParser.TomlErrorMessageAwareIssue;
import com.intellij.build.events.BuildIssueEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/tomlParser/IssueAtPositionHandler;", "Lcom/android/tools/idea/gradle/project/build/output/tomlParser/TomlErrorHandler;", "<init>", "()V", "PROBLEM_LINE_PATTERN", "Lkotlin/text/Regex;", "getPROBLEM_LINE_PATTERN", "()Lkotlin/text/Regex;", "REASON_POSITION_PATTERN", "getREASON_POSITION_PATTERN", "REASON_FILE_AND_POSITION_PATTERN", "getREASON_FILE_AND_POSITION_PATTERN", "REASON_FILE_AND_POSITION_PATTERN_CONTINUATION", "getREASON_FILE_AND_POSITION_PATTERN_CONTINUATION", "tryExtractMessage", "", "Lcom/intellij/build/events/BuildIssueEvent;", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "extractIssueInformation", "catalog", "", "description", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ErrorDescription", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nIssueAtPositionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueAtPositionHandler.kt\ncom/android/tools/idea/gradle/project/build/output/tomlParser/IssueAtPositionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1563#2:98\n1634#2,3:99\n*S KotlinDebug\n*F\n+ 1 IssueAtPositionHandler.kt\ncom/android/tools/idea/gradle/project/build/output/tomlParser/IssueAtPositionHandler\n*L\n84#1:98\n84#1:99,3\n*E\n"})
public final class IssueAtPositionHandler
implements TomlErrorHandler {
    @NotNull
    private final Regex PROBLEM_LINE_PATTERN = new Regex("\\s+- Problem: In version catalog ([^ ]+),.*");
    @NotNull
    private final Regex REASON_POSITION_PATTERN = new Regex("\\s+Reason: At line ([0-9]+), column ([0-9]+):.*");
    @NotNull
    private final Regex REASON_FILE_AND_POSITION_PATTERN = new Regex("\\s+Reason: In file '([^']+)' at line ([0-9]+), column ([0-9]+):.*");
    @NotNull
    private final Regex REASON_FILE_AND_POSITION_PATTERN_CONTINUATION = new Regex("\\s+In file '([^']+)' at line ([0-9]+), column ([0-9]+):.*");

    @NotNull
    public final Regex getPROBLEM_LINE_PATTERN() {
        return this.PROBLEM_LINE_PATTERN;
    }

    @NotNull
    public final Regex getREASON_POSITION_PATTERN() {
        return this.REASON_POSITION_PATTERN;
    }

    @NotNull
    public final Regex getREASON_FILE_AND_POSITION_PATTERN() {
        return this.REASON_FILE_AND_POSITION_PATTERN;
    }

    @NotNull
    public final Regex getREASON_FILE_AND_POSITION_PATTERN_CONTINUATION() {
        return this.REASON_FILE_AND_POSITION_PATTERN_CONTINUATION;
    }

    @Override
    @NotNull
    public List<BuildIssueEvent> tryExtractMessage(@NotNull BuildOutputInstantReader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        String string = reader2.readLine();
        boolean bl = string != null ? StringsKt.endsWith$default((String)string, (String)"Invalid TOML catalog definition:", (boolean)false, (int)2, null) : false;
        if (bl) {
            StringBuilder description2 = new StringBuilder().append("Invalid TOML catalog definition.").append('\n');
            String string2 = reader2.readLine();
            if (string2 == null) {
                return CollectionsKt.emptyList();
            }
            String problemLine = string2;
            MatchResult matchResult = this.PROBLEM_LINE_PATTERN.matchEntire((CharSequence)problemLine);
            if (matchResult != null) {
                MatchResult it = matchResult;
                boolean bl2 = false;
                String catalogName = (String)it.getGroupValues().get(1);
                description2.append(problemLine).append('\n');
                return this.extractIssueInformation(catalogName, description2, reader2);
            }
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<BuildIssueEvent> extractIssueInformation(String catalog, StringBuilder description2, BuildOutputInstantReader reader2) {
        void $this$mapTo$iv$iv;
        List errorDescriptions = new ArrayList();
        description2.append(TomlErrorHelperKt.readUntilLine(reader2, "> Invalid TOML catalog definition", (Function1<? super String, Unit>)((Function1)arg_0 -> IssueAtPositionHandler.extractIssueInformation$lambda$4(errorDescriptions, this, arg_0))));
        Iterable $this$map$iv = errorDescriptions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void error;
            ErrorDescription errorDescription = (ErrorDescription)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string = description2.toString();
            TomlErrorMessageAwareIssue buildIssue2 = new TomlErrorMessageAwareIssue((ErrorDescription)error, catalog, string){
                final /* synthetic */ ErrorDescription $error;
                final /* synthetic */ String $catalog;
                {
                    this.$error = $error;
                    this.$catalog = $catalog;
                    Intrinsics.checkNotNull((Object)$super_call_param$1);
                    super($super_call_param$1);
                }

                public Navigatable getNavigatable(Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    VirtualFile virtualFile = this.$error.getAbsolutePath() != null ? VfsUtil.findFile((Path)Paths.get(this.$error.getAbsolutePath(), new String[0]), (boolean)false) : TomlErrorHelperKt.findCatalogFile(project, this.$catalog);
                    if (virtualFile == null) {
                        return null;
                    }
                    VirtualFile tomlFile = virtualFile;
                    Integer n = this.$error.getLine();
                    Integer n2 = this.$error.getColumn();
                    return (Navigatable)new OpenFileDescriptor(project, tomlFile, n != null ? n - 1 : 0, n2 != null ? n2 - 1 : 0);
                }
            };
            collection2.add(new BuildIssueEventImpl(reader2.getParentEventId(), (BuildIssue)buildIssue2, MessageEvent.Kind.ERROR));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit extractIssueInformation$lambda$4(List $errorDescriptions, IssueAtPositionHandler this$0, String descriptionLine) {
        block2: {
            block1: {
                MatchResult.Destructured destructured;
                Intrinsics.checkNotNullParameter((Object)descriptionLine, (String)"descriptionLine");
                if (!$errorDescriptions.isEmpty()) break block1;
                MatchResult matchResult = this$0.REASON_POSITION_PATTERN.matchEntire((CharSequence)descriptionLine);
                if (matchResult != null) {
                    MatchResult $this$extractIssueInformation_u24lambda_u244_u24lambda_u241 = matchResult;
                    boolean bl = false;
                    destructured = $this$extractIssueInformation_u24lambda_u244_u24lambda_u241.getDestructured();
                    String line = (String)destructured.getMatch().getGroupValues().get(1);
                    String column2 = (String)destructured.getMatch().getGroupValues().get(2);
                    $errorDescriptions.add(new ErrorDescription(null, StringsKt.toIntOrNull((String)line), StringsKt.toIntOrNull((String)column2)));
                }
                MatchResult matchResult2 = this$0.REASON_FILE_AND_POSITION_PATTERN.matchEntire((CharSequence)descriptionLine);
                if (matchResult2 == null) break block2;
                MatchResult it = matchResult2;
                boolean bl = false;
                destructured = it.getDestructured();
                String file = (String)destructured.getMatch().getGroupValues().get(1);
                String line = (String)destructured.getMatch().getGroupValues().get(2);
                String column3 = (String)destructured.getMatch().getGroupValues().get(3);
                $errorDescriptions.add(new ErrorDescription(file, StringsKt.toIntOrNull((String)line), StringsKt.toIntOrNull((String)column3)));
                break block2;
            }
            MatchResult matchResult = this$0.REASON_FILE_AND_POSITION_PATTERN_CONTINUATION.matchEntire((CharSequence)descriptionLine);
            if (matchResult == null) break block2;
            MatchResult it = matchResult;
            boolean bl = false;
            MatchResult.Destructured destructured = it.getDestructured();
            String file = (String)destructured.getMatch().getGroupValues().get(1);
            String line = (String)destructured.getMatch().getGroupValues().get(2);
            String column4 = (String)destructured.getMatch().getGroupValues().get(3);
            $errorDescriptions.add(new ErrorDescription(file, StringsKt.toIntOrNull((String)line), StringsKt.toIntOrNull((String)column4)));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ2\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/tomlParser/IssueAtPositionHandler$ErrorDescription;", "", "absolutePath", "", "line", "", "column", "<init>", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getAbsolutePath", "()Ljava/lang/String;", "getLine", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getColumn", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/android/tools/idea/gradle/project/build/output/tomlParser/IssueAtPositionHandler$ErrorDescription;", "equals", "", "other", "hashCode", "toString", "intellij.android.projectSystem.gradle"})
    private static final class ErrorDescription {
        @Nullable
        private final String absolutePath;
        @Nullable
        private final Integer line;
        @Nullable
        private final Integer column;

        public ErrorDescription(@Nullable String absolutePath, @Nullable Integer line, @Nullable Integer column2) {
            this.absolutePath = absolutePath;
            this.line = line;
            this.column = column2;
        }

        @Nullable
        public final String getAbsolutePath() {
            return this.absolutePath;
        }

        @Nullable
        public final Integer getLine() {
            return this.line;
        }

        @Nullable
        public final Integer getColumn() {
            return this.column;
        }

        @Nullable
        public final String component1() {
            return this.absolutePath;
        }

        @Nullable
        public final Integer component2() {
            return this.line;
        }

        @Nullable
        public final Integer component3() {
            return this.column;
        }

        @NotNull
        public final ErrorDescription copy(@Nullable String absolutePath, @Nullable Integer line, @Nullable Integer column2) {
            return new ErrorDescription(absolutePath, line, column2);
        }

        public static /* synthetic */ ErrorDescription copy$default(ErrorDescription errorDescription, String string, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = errorDescription.absolutePath;
            }
            if ((n3 & 2) != 0) {
                n = errorDescription.line;
            }
            if ((n3 & 4) != 0) {
                n2 = errorDescription.column;
            }
            return errorDescription.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "ErrorDescription(absolutePath=" + this.absolutePath + ", line=" + this.line + ", column=" + this.column + ")";
        }

        public int hashCode() {
            int result2 = this.absolutePath == null ? 0 : this.absolutePath.hashCode();
            result2 = result2 * 31 + (this.line == null ? 0 : ((Object)this.line).hashCode());
            result2 = result2 * 31 + (this.column == null ? 0 : ((Object)this.column).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorDescription)) {
                return false;
            }
            ErrorDescription errorDescription = (ErrorDescription)other;
            if (!Intrinsics.areEqual((Object)this.absolutePath, (Object)errorDescription.absolutePath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.line, (Object)errorDescription.line)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.column, (Object)errorDescription.column);
        }
    }
}

