/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.google.common.collect.ImmutableList;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class Info {
    @NotNull
    public final Project myProject;
    @NotNull
    public final ProjectFacetManager myFacetManager;

    public Info(@NotNull Project project) {
        this.myProject = project;
        this.myFacetManager = ProjectFacetManager.getInstance((Project)project);
    }

    public static Info getInstance(@NotNull Project project) {
        return (Info)project.getService(Info.class);
    }

    public boolean isBuildWithGradle() {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            if (Arrays.stream(ModuleManager.getInstance((Project)this.myProject).getModules()).anyMatch(it -> ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleProjectSystemUtil.GRADLE_SYSTEM_ID, (Module)it))) {
                return true;
            }
            if (this.myFacetManager.hasFacets(GradleFacet.getFacetTypeId())) {
                return true;
            }
            if (GradleSyncState.getInstance(this.myProject).getLastSyncFinishedTimeStamp() != -1L) {
                return true;
            }
            if (!GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().isEmpty()) {
                return true;
            }
            return this.hasTopLevelGradleFile();
        });
    }

    public boolean hasTopLevelGradleFile() {
        if (this.myProject.isDefault()) {
            return false;
        }
        VirtualFile baseDir2 = this.myProject.getBaseDir();
        if (baseDir2 != null) {
            return GradleProjectSystemUtil.findGradleBuildFile(baseDir2) != null || GradleProjectSystemUtil.findGradleSettingsFile(baseDir2) != null;
        }
        return false;
    }

    @NotNull
    public Module[] getModulesToBuildFromSelection(@Nullable DataContext dataContext) {
        Module[] modules;
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && Info.isProjectModule(modules[0])) {
                return ModuleManager.getInstance((Project)this.myProject).getModules();
            }
            return modules;
        }
        Module module = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            Module[] moduleArray;
            if (Info.isProjectModule(module)) {
                moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module;
            }
            return moduleArray;
        }
        return Module.EMPTY_ARRAY;
    }

    private static boolean isProjectModule(@NotNull Module module) {
        File moduleRootFolderPath = AndroidRootUtil.findModuleRootFolderPath(module);
        if (moduleRootFolderPath == null) {
            return false;
        }
        String basePath = module.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootFolderPath, (File)new File(basePath)) && !GradleFacet.isAppliedTo(module);
    }

    @NotNull
    public List<Module> getAndroidModules() {
        ImmutableList.Builder modules = ImmutableList.builder();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ProjectFacetManager.getInstance((Project)this.myProject).getModulesWithFacet(AndroidFacet.ID)) {
                if (!LinkedAndroidModuleGroupUtilsKt.isHolderModule(module) || AndroidFacet.getInstance((Module)module) == null || GradleFacet.getInstance(module) == null) continue;
                modules.add((Object)module);
            }
        });
        return modules.build();
    }
}

