/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslUtil;
import com.android.tools.idea.gradle.dsl.parser.semantics.ExternalToModelMap;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyType;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertySemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SemanticsDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyDslNameConverter
implements GradleDslNameConverter {
    @NotNull
    private final BuildModelContext context;

    GroovyDslNameConverter(@NotNull BuildModelContext context) {
        this.context = context;
    }

    @Override
    @NotNull
    public GradleDslNameConverter.Kind getKind() {
        return GradleDslNameConverter.Kind.GROOVY;
    }

    @Override
    @NotNull
    public String psiToName(@NotNull PsiElement element) {
        StringBuilder sb;
        if (GroovyDslUtil.isStringLiteral(element) && GroovyDslUtil.decodeStringLiteral(element, sb = new StringBuilder())) {
            return GradleNameElement.escape(sb.toString());
        }
        if (element instanceof GrExpression) {
            GrExpression expression = (GrExpression)element;
            String name2 = GroovyDslUtil.gradleNameFor(expression);
            return name2 == null ? "" : name2;
        }
        return element.getText();
    }

    @Override
    @NotNull
    public String convertReferenceText(@NotNull GradleDslElement context, @NotNull String referenceText) {
        String result2 = (String)ApplicationManager.getApplication().runReadAction(() -> {
            GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)context.getDslFile().getProject());
            GrExpression expression = factory2.createExpressionFromText((CharSequence)referenceText);
            return GroovyDslUtil.gradleNameFor(expression);
        });
        return result2 != null ? result2 : referenceText;
    }

    @Override
    @NotNull
    public String convertReferencePsi(@NotNull GradleDslElement context, @NotNull PsiElement element) {
        String result2;
        if (element instanceof GrExpression && (result2 = GroovyDslUtil.gradleNameFor((GrExpression)element)) != null) {
            return result2;
        }
        return this.convertReferenceText(context, element.getText());
    }

    @Override
    @NotNull
    public String convertReferenceToExternalText(@NotNull GradleDslElement context, @NotNull String referenceText, boolean forInjection) {
        if (context instanceof GradleDslSimpleExpression) {
            return GroovyDslUtil.convertToExternalTextValue((GradleDslSimpleExpression)context, context.getDslFile(), referenceText, forInjection);
        }
        return referenceText;
    }

    @Override
    @NotNull
    public String convertReferenceToExternalText(@NotNull GradleDslElement context, @NotNull GradleDslElement dslElement, boolean forInjection) {
        if (context instanceof GradleDslSimpleExpression) {
            String externalText = GroovyDslUtil.convertToExternalTextValue(dslElement, (GradleDslSimpleExpression)context, context.getDslFile(), forInjection);
            return externalText != null ? externalText : dslElement.getName();
        }
        return dslElement.getName();
    }

    @Override
    @NotNull
    public ExternalNameInfo externalNameForParent(@NotNull String modelName, @NotNull GradleDslElement context) {
        @NotNull ExternalToModelMap map2 = context.getExternalToModelMap(this);
        ExternalNameInfo result2 = new ExternalNameInfo(modelName, ExternalNameInfo.ExternalNameSyntax.UNKNOWN);
        for (ExternalToModelMap.Entry e : map2.getEntrySet()) {
            if (!e.modelEffectDescription.property.name.equals(modelName) || e.versionConstraint != null && !e.versionConstraint.isOkWith(this.getContext().getAgpVersion())) continue;
            SemanticsDescription semantics = e.modelEffectDescription.semantics;
            if (semantics == PropertySemanticsDescription.GRADLE_PROPERTY) {
                return new ExternalNameInfo(e.surfaceSyntaxDescription.name, ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT);
            }
            if (Arrays.asList(MethodSemanticsDescription.SET, MethodSemanticsDescription.ADD_AS_LIST, MethodSemanticsDescription.AUGMENT_LIST, MethodSemanticsDescription.CLEAR_AND_AUGMENT_LIST, MethodSemanticsDescription.AUGMENT_MAP, MethodSemanticsDescription.OTHER).contains(semantics)) {
                return new ExternalNameInfo(e.surfaceSyntaxDescription.name, ExternalNameInfo.ExternalNameSyntax.METHOD);
            }
            if (semantics == PropertySemanticsDescription.VAL && (e.modelEffectDescription.property.type == ModelPropertyType.MUTABLE_SET || e.modelEffectDescription.property.type == ModelPropertyType.MUTABLE_LIST || e.modelEffectDescription.property.type == ModelPropertyType.MUTABLE_MAP)) {
                return new ExternalNameInfo(e.surfaceSyntaxDescription.name, ExternalNameInfo.ExternalNameSyntax.AUGMENTED_ASSIGNMENT);
            }
            if (semantics != PropertySemanticsDescription.VAR && semantics != PropertySemanticsDescription.VWO && semantics != PropertySemanticsDescription.VAR_BUT_DO_NOT_USE_FOR_WRITING_IN_KTS) continue;
            result2 = new ExternalNameInfo(e.surfaceSyntaxDescription.name, ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT);
        }
        return result2;
    }

    @Override
    @NotNull
    public Pattern getPatternForUnwrappedVariables() {
        return Pattern.compile("\\$(([a-zA-Z0-9_]\\w*)(\\.([a-zA-Z0-9_]\\w+))*)");
    }

    @Override
    @NotNull
    public Pattern getPatternForWrappedVariables() {
        return Pattern.compile("\\$\\{(.*)}");
    }

    @Override
    @Nullable
    public ModelPropertyDescription modelDescriptionForParent(@NotNull String externalName, @NotNull GradleDslElement context) {
        @NotNull ExternalToModelMap map2 = context.getExternalToModelMap(this);
        for (ExternalToModelMap.Entry e : map2.getEntrySet()) {
            if (!e.surfaceSyntaxDescription.name.equals(externalName)) continue;
            return e.modelEffectDescription.property;
        }
        return null;
    }

    @Override
    @NotNull
    public BuildModelContext getContext() {
        return this.context;
    }
}

