/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FakeElement
extends GradleDslSettableExpression {
    public static final Logger LOG = Logger.getInstance(FakeElement.class);
    @NotNull
    protected final GradleDslSimpleExpression myRealExpression;
    protected final boolean myCanDelete;
    @NotNull
    protected final GradleNameElement myFakeName;

    public FakeElement(@Nullable GradleDslElement parent, @NotNull GradleNameElement name2, @NotNull GradleDslSimpleExpression originExpression, boolean canDelete) {
        super(parent, null, name2, null);
        this.myRealExpression = originExpression;
        this.myCanDelete = canDelete;
        this.myFakeName = name2;
        this.setElementType(PropertyType.FAKE);
    }

    @Nullable
    private PsiElement createPsiElement() {
        Object s = this.extractValue();
        PsiElement element = s == null ? null : (PsiElement)ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().convertToPsiElement(this, s));
        this.setupDependencies(element);
        return element;
    }

    @Override
    public void rename(@NotNull String newName) {
        LOG.warn((Throwable)new UnsupportedOperationException("Renaming of this fake element is not possible: " + String.valueOf(this)));
    }

    @Override
    public void rename(@NotNull List<String> hierarchicalName) {
        LOG.warn((Throwable)new UnsupportedOperationException("Renaming of this fake element is not possible: " + String.valueOf(this)));
    }

    @Override
    public final void delete() {
        if (!this.myCanDelete) {
            LOG.warn((Throwable)new UnsupportedOperationException("Deleting this element is not supported: " + String.valueOf(this)));
            return;
        }
        this.consumeValue(null);
    }

    @Override
    @NotNull
    public final Collection<GradleDslElement> getChildren() {
        PsiElement element = this.createPsiElement();
        if (element == null) {
            return ImmutableList.of();
        }
        return this.getDslFile().getParser().getResolvedInjections(this, element).stream().map(e -> e.getToBeInjected()).collect(Collectors.toList());
    }

    @Override
    protected final void apply() {
    }

    @Override
    public long getModificationCount() {
        return this.myRealExpression.getModificationCount();
    }

    @Override
    public long getLastCommittedModificationCount() {
        return this.myRealExpression.getLastCommittedModificationCount();
    }

    @Override
    @Nullable
    public Object produceValue() {
        PsiElement element = this.createPsiElement();
        if (element == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().extractValue(this, element, true));
    }

    @Override
    @Nullable
    public final Object produceUnresolvedValue() {
        PsiElement element = this.createPsiElement();
        if (element == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().extractValue(this, element, false));
    }

    @Override
    @NotNull
    public final String getName() {
        return this.myFakeName.name();
    }

    @Override
    @NotNull
    public final String getFullName() {
        return this.myFakeName.fullName();
    }

    @Override
    @NotNull
    public final GradleNameElement getNameElement() {
        return this.myFakeName;
    }

    @Override
    public final void setValue(@NotNull Object value2) {
        this.consumeValue(value2);
    }

    @Nullable
    protected abstract Object extractValue();

    protected abstract void consumeValue(@Nullable Object var1);

    @NotNull
    public GradleDslElement getRealExpression() {
        return this.myRealExpression;
    }
}

