/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileTreeDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.PlatformArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class AbstractDependenciesModel
extends GradleDslBlockModel
implements DependenciesModel {
    public static final Logger LOG = Logger.getInstance(AbstractDependenciesModel.class);
    private static final Map<String, Function<ArtifactDependencySpec, String>> COMPONENT_MAP = ImmutableMap.builder().put((Object)"name", ArtifactDependencySpec::getName).put((Object)"group", ArtifactDependencySpec::getGroup).put((Object)"version", ArtifactDependencySpec::getVersion).put((Object)"ext", ArtifactDependencySpec::getExtension).put((Object)"classifier", ArtifactDependencySpec::getClassifier).build();

    public AbstractDependenciesModel(@NotNull DependenciesDslElement dslElement) {
        super(dslElement);
    }

    @Override
    @NotNull
    public List<DependencyModel> all() {
        return this.all(null, this.getAllFetcher());
    }

    @Override
    @NotNull
    public List<ArtifactDependencyModel> artifacts(@NotNull String configurationName) {
        return this.all(configurationName, this.getArtifactFetcher());
    }

    protected abstract Fetcher<ArtifactDependencyModel> getArtifactFetcher();

    protected abstract Fetcher<ModuleDependencyModel> getModuleFetcher();

    protected abstract Fetcher<FileTreeDependencyModel> getFileTreeFetcher();

    protected abstract Fetcher<FileDependencyModel> getFileFetcher();

    protected Fetcher<DependencyModel> getAllFetcher() {
        return (configurationName, element, resolved, configurationElement, maintainer, dest) -> {
            this.getArtifactFetcher().fetch(configurationName, element, resolved, configurationElement, maintainer, dest);
            this.getModuleFetcher().fetch(configurationName, element, resolved, configurationElement, maintainer, dest);
            this.getFileFetcher().fetch(configurationName, element, resolved, configurationElement, maintainer, dest);
            this.getFileTreeFetcher().fetch(configurationName, element, resolved, configurationElement, maintainer, dest);
        };
    }

    @Override
    @NotNull
    public List<ArtifactDependencyModel> artifacts() {
        return this.all(null, this.getArtifactFetcher());
    }

    @Override
    public boolean containsArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        for (ArtifactDependencyModel artifactDependencyModel : this.artifacts(configurationName)) {
            if (!ArtifactDependencySpecImpl.create(artifactDependencyModel).equals(dependency)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull String compactNotation) {
        this.addArtifact(configurationName, compactNotation, Collections.emptyList());
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull String compactNotation, @NotNull List<ArtifactDependencySpec> excludes) {
        ArtifactDependencySpecImpl dependency = ArtifactDependencySpecImpl.create(compactNotation);
        if (dependency == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            LOG.warn(msg);
            return;
        }
        this.addArtifact(configurationName, dependency, excludes);
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ReferenceTo reference) {
        ArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, reference, Collections.emptyList());
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ReferenceTo reference, @NotNull List<ArtifactDependencySpec> excludes) {
        ArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, reference, excludes);
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        this.addArtifact(configurationName, dependency, Collections.emptyList());
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        ArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, dependency, excludes);
    }

    @Override
    public void addPlatformArtifact(@NotNull String configurationName, @NotNull String compactNotation, boolean enforced) {
        ArtifactDependencySpecImpl dependency = ArtifactDependencySpecImpl.create(compactNotation);
        if (dependency == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            LOG.warn(msg);
            return;
        }
        this.addPlatformArtifact(configurationName, dependency, enforced);
    }

    @Override
    public void addPlatformArtifact(@NotNull String configurationName, @NotNull ReferenceTo reference, boolean enforced) {
        PlatformArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, reference, enforced);
    }

    @Override
    public void addPlatformArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, boolean enforced) {
        PlatformArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, dependency, enforced);
    }

    @Override
    public boolean replaceArtifactByPsiElement(@NotNull PsiElement psiElement, @NotNull ArtifactDependencySpec dependency) {
        GradleDslElement element = this.findByPsiElement(psiElement);
        if (element == null) {
            return false;
        }
        this.getDependencyReplacer().performDependencyReplace(psiElement, element, dependency);
        return true;
    }

    @Nullable
    protected abstract GradleDslElement findByPsiElement(@NotNull PsiElement var1);

    protected abstract DependencyReplacer getDependencyReplacer();

    @Override
    @NotNull
    public List<ModuleDependencyModel> modules() {
        return this.all(null, this.getModuleFetcher());
    }

    @Override
    public void addModule(@NotNull String configurationName, @NotNull String path) {
        this.addModule(configurationName, path, null);
    }

    @Override
    @NotNull
    @TestOnly
    public List<FileTreeDependencyModel> fileTrees() {
        return this.all(null, this.getFileTreeFetcher());
    }

    @Override
    public void addFileTree(@NotNull String configurationName, @NotNull String dir) {
        this.addFileTree(configurationName, dir, null, null);
    }

    @Override
    public void addFileTree(@NotNull String configurationName, @NotNull String dir, @Nullable List<String> includes, @Nullable List<String> excludes) {
        FileTreeDependencyModelImpl.createNew(this.myDslElement, configurationName, dir, includes, excludes);
    }

    @Override
    @NotNull
    @TestOnly
    public List<FileDependencyModel> files() {
        return this.all(null, this.getFileFetcher());
    }

    @Override
    public void addFile(@NotNull String configurationName, @NotNull String file) {
        FileDependencyModelImpl.createNew(this.myDslElement, configurationName, file);
    }

    @Override
    public void remove(@NotNull DependencyModel dependency) {
        if (!(dependency instanceof DependencyModelImpl)) {
            LOG.warn("Tried to remove an unknown dependency type: " + String.valueOf(dependency));
            return;
        }
        GradleDslElement dependencyElement = ((DependencyModelImpl)dependency).getDslElement();
        GradleDslElement parent = dependencyElement.getParent();
        if (parent instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)parent;
            List<GradleDslExpression> arguments = methodCall.getArguments();
            if (arguments.size() == 1 && arguments.get(0).equals(dependencyElement)) {
                this.myDslElement.removeProperty(methodCall);
            } else {
                methodCall.remove(dependencyElement);
            }
        } else if (parent instanceof GradleDslExpressionList) {
            List<GradleDslExpression> expressions = ((GradleDslExpressionList)parent).getExpressions();
            if (expressions.size() == 1 && expressions.get(0).equals(dependencyElement)) {
                if (parent.getParent() instanceof GradleDslMethodCall) {
                    this.myDslElement.removeProperty(parent.getParent());
                } else {
                    this.myDslElement.removeProperty(parent);
                }
            } else {
                ((GradleDslExpressionList)parent).removeElement(dependencyElement);
            }
        } else {
            this.myDslElement.removeProperty(dependencyElement);
        }
    }

    @NotNull
    private <T extends DependencyModel> List<T> all(@Nullable String configurationName, @NotNull Fetcher<T> fetcher) {
        ArrayList dependencies2 = new ArrayList();
        for (GradleDslElement element : configurationName != null ? this.myDslElement.getPropertyElementsByName(configurationName) : this.myDslElement.getAllPropertyElements()) {
            this.collectFrom(element.getName(), element, fetcher, dependencies2);
        }
        return dependencies2;
    }

    protected abstract <T extends DependencyModel> void collectFrom(@NotNull String var1, @NotNull GradleDslElement var2, @NotNull Fetcher<T> var3, @NotNull List<T> var4);

    protected static boolean isChildOfParent(@NotNull PsiElement child, @NotNull PsiElement parent) {
        ArrayList childElements = Lists.newArrayList((Object[])new PsiElement[]{parent});
        while (!childElements.isEmpty()) {
            PsiElement element = (PsiElement)childElements.remove(0);
            if (element.equals((Object)child)) {
                return true;
            }
            childElements.addAll(Arrays.asList(element.getChildren()));
        }
        return false;
    }

    protected static void updateGradleExpressionMapWithDependency(@NotNull GradleDslExpressionMap map2, @NotNull ArtifactDependencySpec dependency) {
        LinkedHashMap<String, Function<ArtifactDependencySpec, String>> properties = new LinkedHashMap<String, Function<ArtifactDependencySpec, String>>(COMPONENT_MAP);
        for (Map.Entry<String, GradleDslElement> entry : map2.getPropertyElements().entrySet()) {
            if (properties.containsKey(entry.getKey())) {
                String value2 = (String)((Function)properties.get(entry.getKey())).fun((Object)dependency);
                if (value2 == null) continue;
                map2.setNewLiteral(entry.getKey(), value2);
                properties.remove(entry.getKey());
                continue;
            }
            map2.removeProperty(entry.getKey());
        }
        for (Map.Entry<String, GradleDslElement> entry : properties.entrySet()) {
            String value2 = (String)((Function)entry.getValue()).fun((Object)dependency);
            if (value2 != null) {
                map2.addNewLiteral(entry.getKey(), value2);
                continue;
            }
            map2.removeProperty(entry.getKey());
        }
    }

    public static interface Fetcher<T extends DependencyModel> {
        public void fetch(@NotNull String var1, @NotNull GradleDslElement var2, @NotNull GradleDslElement var3, @Nullable GradleDslClosure var4, @NotNull DependencyModelImpl.Maintainer var5, @NotNull List<? super T> var6);
    }

    public static interface DependencyReplacer {
        public void performDependencyReplace(@NotNull PsiElement var1, @NotNull GradleDslElement var2, @NotNull ArtifactDependencySpec var3);
    }
}

