/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android.splits;

import com.android.tools.idea.gradle.dsl.api.android.splits.BaseSplitOptionsModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyType;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSplitOptionsModelImpl
extends GradleDslBlockModel
implements BaseSplitOptionsModel {
    @NonNls
    public static final String ENABLE = "mEnable";
    @NonNls
    public static final ModelPropertyDescription EXCLUDE = new ModelPropertyDescription("mExclude", ModelPropertyType.MUTABLE_LIST);
    @NonNls
    public static final ModelPropertyDescription INCLUDE = new ModelPropertyDescription("mInclude", ModelPropertyType.MUTABLE_LIST);
    private static final Predicate<GradleDslMethodCall> resetPredicate = e -> {
        ModelEffectDescription effect = e.getModelEffect();
        return effect != null && effect.property == INCLUDE && effect.semantics == MethodSemanticsDescription.RESET;
    };

    public BaseSplitOptionsModelImpl(@NotNull GradleDslBlockElement element) {
        super(element);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel enable() {
        return this.getModelForProperty(ENABLE);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel exclude() {
        return this.getModelForProperty(EXCLUDE);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel include() {
        return this.getModelForProperty(INCLUDE);
    }

    @Override
    public boolean reset() {
        List<GradleDslMethodCall> methodCalls = this.myDslElement.getPropertyElements(GradleDslMethodCall.class);
        return methodCalls.stream().anyMatch(resetPredicate);
    }

    @Override
    public void setReset(boolean addReset) {
        if (addReset) {
            GradleDslMethodCall resetMethod = new GradleDslMethodCall((GradleDslElement)this.myDslElement, GradleNameElement.empty(), "reset");
            resetMethod.setModelEffect(new ModelEffectDescription(INCLUDE, MethodSemanticsDescription.RESET));
            this.myDslElement.addNewElementAt(0, resetMethod);
        } else {
            this.myDslElement.getPropertyElements(GradleDslMethodCall.class).stream().filter(resetPredicate).forEach(this.myDslElement::removeProperty);
        }
    }
}

