/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleFileModel;
import com.android.tools.idea.gradle.dsl.api.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.configurations.ConfigurationsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.dsl.api.kotlin.KotlinModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleBlockModelMap;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleModelFactory;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleVersionCatalogModelImpl;
import com.android.tools.idea.gradle.dsl.model.PluginModelImpl;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslInfixExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleScriptFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleBuildModelImpl
extends GradleFileModelImpl
implements GradleBuildModel {
    private static final Logger LOG = Logger.getInstance(GradleBuildModelImpl.class);
    @NonNls
    private static final String PLUGIN = "plugin";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String VERSION = "version";
    @NonNls
    private static final String APPLY = "apply";
    @NotNull
    protected GradleBuildFile myGradleBuildFile;

    protected GradleBuildModelImpl(@NotNull GradleBuildFile buildDslFile) {
        super(buildDslFile);
        this.myGradleBuildFile = buildDslFile;
    }

    @Override
    @NotNull
    public List<PluginModel> plugins() {
        ApplyDslElement applyDslElement;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        ArrayList<PluginModelImpl> plugins = new ArrayList<PluginModelImpl>();
        if (pluginsDslElement != null) {
            plugins.addAll(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(pluginsDslElement)).values());
        }
        if ((applyDslElement = this.myGradleDslFile.getPropertyElement(APPLY, ApplyDslElement.class)) != null) {
            plugins.addAll(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement)).values());
        }
        return new ArrayList<PluginModel>(PluginModelImpl.deduplicatePlugins(plugins).values());
    }

    @Override
    @NotNull
    public List<PluginModel> appliedPlugins() {
        Predicate<PluginModel> appliedPredicate = plugin -> {
            ResolvedPropertyModel apply2 = plugin.apply();
            GradlePropertyModel.ValueType valueType = apply2.getValueType();
            if (valueType == GradlePropertyModel.ValueType.NONE) {
                return true;
            }
            if (valueType == GradlePropertyModel.ValueType.BOOLEAN) {
                return apply2.getValue(GradlePropertyModel.BOOLEAN_TYPE);
            }
            return false;
        };
        return this.plugins().stream().filter(appliedPredicate).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull String plugin) {
        Map<String, PluginModelImpl> applyPluginsModels;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement(APPLY, ApplyDslElement.class);
        if (pluginsDslElement == null && applyDslElement == null) {
            int at = 0;
            List<GradleDslElement> elements = this.myGradleDslFile.getCurrentElements();
            if (!elements.isEmpty() && elements.get(0) instanceof BuildScriptDslElement) {
                ++at;
            }
            pluginsDslElement = this.myGradleDslFile.ensurePropertyElementAt(PluginsDslElement.PLUGINS, at);
        } else if (pluginsDslElement == null) {
            Map<String, PluginModelImpl> models = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement));
            if (models.containsKey(plugin)) {
                return models.get(plugin);
            }
            GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, GradleNameElement.create(APPLY));
            applyMap.setAsNamedArgs(true);
            GradleDslLiteral literal = new GradleDslLiteral(applyMap, GradleNameElement.create(PLUGIN));
            literal.setValue(plugin.trim());
            applyMap.setNewElement(literal);
            applyDslElement.setNewElement(applyMap);
            return new PluginModelImpl(applyMap);
        }
        Map<String, PluginModelImpl> models = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(pluginsDslElement));
        if (models.containsKey(plugin)) {
            return models.get(plugin);
        }
        if (applyDslElement != null && (applyPluginsModels = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement))).containsKey(plugin)) {
            return applyPluginsModels.get(plugin);
        }
        GradleDslLiteral literal = new GradleDslLiteral(pluginsDslElement, GradleNameElement.create(ID));
        literal.setElementType(PropertyType.REGULAR);
        literal.setValue(plugin.trim());
        pluginsDslElement.setNewElement(literal);
        return new PluginModelImpl(literal);
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull String plugin, @Nullable String version2, @Nullable Boolean apply2) {
        int at = 0;
        List<GradleDslElement> elements = this.myGradleDslFile.getCurrentElements();
        if (!elements.isEmpty() && elements.get(0) instanceof BuildScriptDslElement) {
            ++at;
        }
        PluginsDslElement pluginsElement = this.myGradleDslFile.ensurePropertyElementAt(PluginsDslElement.PLUGINS, at);
        GradleDslInfixExpression expression = new GradleDslInfixExpression(pluginsElement, null);
        expression.setNewLiteral(ID, plugin);
        if (version2 != null) {
            expression.setNewLiteral(VERSION, version2);
        }
        if (apply2 != null) {
            expression.setNewLiteral(APPLY, apply2);
        }
        pluginsElement.setNewElement(expression);
        return new PluginModelImpl(expression);
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull ReferenceTo reference, @Nullable Boolean apply2) {
        int at = 0;
        List<GradleDslElement> elements = this.myGradleDslFile.getCurrentElements();
        if (!elements.isEmpty() && elements.get(0) instanceof BuildScriptDslElement) {
            ++at;
        }
        PluginsDslElement pluginsElement = this.myGradleDslFile.ensurePropertyElementAt(PluginsDslElement.PLUGINS, at);
        GradleDslMethodCall alias = new GradleDslMethodCall((GradleDslElement)pluginsElement, GradleNameElement.empty(), "alias");
        GradleDslLiteral target2 = new GradleDslLiteral(alias.getArgumentsElement(), GradleNameElement.empty());
        target2.setValue(reference);
        alias.addNewArgument(target2);
        if (apply2 != null) {
            GradleDslInfixExpression expression = new GradleDslInfixExpression(pluginsElement, null);
            alias.setParent(expression);
            expression.setNewElement(alias);
            expression.setNewLiteral(APPLY, apply2);
            pluginsElement.setNewElement(expression);
            return new PluginModelImpl(expression);
        }
        pluginsElement.setNewElement(alias);
        return new PluginModelImpl(alias);
    }

    @Override
    public void removePlugin(@NotNull String plugin) {
        ApplyDslElement applyDslElement;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        if (pluginsDslElement != null) {
            PluginModelImpl.removePlugins(PluginModelImpl.create(pluginsDslElement), plugin);
        }
        if ((applyDslElement = this.myGradleDslFile.getPropertyElement(APPLY, ApplyDslElement.class)) != null) {
            PluginModelImpl.removePlugins(PluginModelImpl.create(applyDslElement), plugin);
        }
    }

    @Override
    @Nullable
    public PsiElement getPluginsPsiElement() {
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        if (pluginsDslElement != null) {
            return pluginsDslElement.getPsiElement();
        }
        return null;
    }

    @Override
    @NotNull
    public BuildScriptModel buildscript() {
        return this.getModel(BuildScriptModel.class);
    }

    @Override
    @NotNull
    public ConfigurationsModel configurations() {
        return this.getModel(ConfigurationsModel.class);
    }

    @Override
    @NotNull
    public DependenciesModel dependencies() {
        return this.getModel(DependenciesModel.class);
    }

    @Override
    @NotNull
    public ExtModel ext() {
        return this.getModel(ExtModel.class);
    }

    @Override
    @NotNull
    public JavaModel java() {
        return this.getModel(JavaModel.class);
    }

    @Override
    @NotNull
    public KotlinModel kotlin() {
        return this.getModel(KotlinModel.class);
    }

    @Override
    @NotNull
    public RepositoriesModel repositories() {
        return this.getModel(RepositoriesModel.class);
    }

    @Override
    @NotNull
    public Set<GradleFileModel> getInvolvedFiles() {
        return this.getAllInvolvedFiles().stream().distinct().map(GradleBuildModelImpl::getFileModel).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public <T extends GradleDslModel> T getModel(Class<T> klass) {
        return GradleBlockModelMap.get(this.myGradleDslFile, GradleBuildModel.class, klass);
    }

    @Override
    @NotNull
    public File getModuleRootDirectory() {
        BuildModelContext context = this.myGradleDslFile.getContext();
        VirtualFile projectSettingsFile = context.getProjectSettingsFile();
        if (projectSettingsFile == null) {
            return this.myGradleDslFile.getDirectoryPath();
        }
        GradleSettingsFile settingsFile = context.getOrCreateSettingsFile(projectSettingsFile);
        GradleSettingsModelImpl settingsModel = new GradleSettingsModelImpl(settingsFile);
        File directory = settingsModel.moduleDirectory(this.myGradleDslFile.getName());
        if (directory == null) {
            return this.myGradleDslFile.getDirectoryPath();
        }
        return directory;
    }

    @Override
    @NotNull
    public Set<GradleDslFile> getAllInvolvedFiles() {
        HashSet<GradleDslFile> files2 = new HashSet<GradleDslFile>();
        files2.add(this.myGradleBuildFile);
        files2.addAll(this.getParentFiles());
        ArrayList<GradleScriptFile> currentFiles = new ArrayList<GradleScriptFile>();
        currentFiles.add(this.myGradleBuildFile);
        while (!currentFiles.isEmpty()) {
            GradleScriptFile currentFile = (GradleScriptFile)currentFiles.remove(0);
            files2.addAll(currentFile.getApplyDslElement());
            currentFiles.addAll(currentFile.getApplyDslElement());
        }
        for (GradleDslFile file : new ArrayList(files2)) {
            GradleBuildFile buildFile;
            GradlePropertiesFile sibling;
            if (!(file instanceof GradleBuildFile) || (sibling = (buildFile = (GradleBuildFile)file).getPropertiesFile()) == null) continue;
            files2.add(sibling);
        }
        files2.addAll(this.getContext().getVersionCatalogFiles());
        return files2;
    }

    private Set<GradleBuildFile> getParentFiles() {
        HashSet<GradleBuildFile> files2 = new HashSet<GradleBuildFile>();
        for (GradleBuildFile file = this.myGradleBuildFile.getParentModuleBuildFile(); file != null; file = file.getParentModuleBuildFile()) {
            files2.add(file);
        }
        return files2;
    }

    @Override
    @NotNull
    public Map<String, List<BuildModelNotification>> getNotifications() {
        return this.getAllInvolvedFiles().stream().filter(e -> !e.getPublicNotifications().isEmpty()).collect(Collectors.toMap(e -> e.getFile().getPath(), GradleDslFile::getPublicNotifications));
    }

    @Override
    @Nullable
    public GradlePropertiesModel getPropertiesModel() {
        GradlePropertiesFile propertiesFile = this.myGradleBuildFile.getPropertiesFile();
        if (propertiesFile == null) {
            return null;
        }
        return new GradlePropertiesModelImpl(propertiesFile);
    }

    @Override
    @TestOnly
    public void removeRepositoriesBlocks() {
        this.myGradleDslFile.removeProperty(RepositoriesDslElement.REPOSITORIES.name);
    }

    @Nullable
    private static GradleFileModel getFileModel(@NotNull GradleDslFile file) {
        if (file instanceof GradleBuildFile) {
            GradleBuildFile buildFile = (GradleBuildFile)file;
            return GradleModelFactory.createGradleBuildModel(buildFile);
        }
        if (file instanceof GradleSettingsFile) {
            return new GradleSettingsModelImpl((GradleSettingsFile)file);
        }
        if (file instanceof GradlePropertiesFile) {
            return new GradlePropertiesModelImpl((GradlePropertiesFile)file);
        }
        if (file instanceof GradleVersionCatalogFile) {
            return new GradleVersionCatalogModelImpl((GradleVersionCatalogFile)file);
        }
        LOG.warn((Throwable)new IllegalStateException("Unknown GradleDslFile type found!" + String.valueOf(file)));
        return null;
    }

    @Override
    @NotNull
    public GradleDslElement getRawPropertyHolder() {
        return this.myGradleBuildFile;
    }
}

