/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.catalog;

import com.android.tools.idea.gradle.dsl.model.VersionCatalogFilesModel;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.VersionCatalogsModel;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/gradle/catalog/VersionCatalogFilesGradleModel;", "Lcom/android/tools/idea/gradle/dsl/model/VersionCatalogFilesModel;", "<init>", "()V", "getCatalogNameToFileMapping", "", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "extractCatalogData", "projectInfo", "Lcom/intellij/openapi/externalSystem/model/ExternalProjectInfo;", "intellij.android.projectSystem.gradle"})
public final class VersionCatalogFilesGradleModel
implements VersionCatalogFilesModel {
    @Override
    @NotNull
    public Map<String, String> getCatalogNameToFileMapping(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getBasePath();
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String externalProjectPath = string;
        ExternalProjectInfo projectInfo = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, externalProjectPath);
        return this.extractCatalogData(projectInfo);
    }

    @Override
    @NotNull
    public Map<String, String> getCatalogNameToFileMapping(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = ExternalSystemModulePropertyManager.Companion.getInstance(module).getRootProjectPath();
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String externalProjectPath = string;
        ExternalProjectInfo projectInfo = ProjectDataManager.getInstance().getExternalProjectData(module.getProject(), GradleConstants.SYSTEM_ID, externalProjectPath);
        return this.extractCatalogData(projectInfo);
    }

    private final Map<String, String> extractCatalogData(ExternalProjectInfo projectInfo) {
        ExternalProjectInfo externalProjectInfo = projectInfo;
        if (externalProjectInfo == null || (externalProjectInfo = externalProjectInfo.getExternalProjectStructure()) == null) {
            return MapsKt.emptyMap();
        }
        ExternalProjectInfo versionCatalogsModel = externalProjectInfo;
        DataNode model = ExternalSystemApiUtil.find((DataNode)versionCatalogsModel, (Key)BuildScriptClasspathData.VERSION_CATALOGS);
        Object object = model;
        if (object == null || (object = (VersionCatalogsModel)object.getData()) == null || (object = object.getCatalogsLocations()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }
}

