/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class GenerateApkAction
extends AndroidStudioGradleAction {
    private static final String ACTION_TEXT = "Generate APKs";

    public GenerateApkAction() {
        super(ACTION_TEXT);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        e.getPresentation().setEnabled(!GenerateApkAction.isGradleSyncInProgress(project));
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        List<Module> appModules = ProjectStructure.getInstance(project).getAppHolderModules().stream().flatMap(module -> GradleProjectSystemUtil.getModulesToBuild(module).stream()).collect(Collectors.toList());
        if (!appModules.isEmpty()) {
            GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
            GoToApkLocationTask task2 = new GoToApkLocationTask(project, appModules, ACTION_TEXT);
            Module[] modulesToBuild = appModules.toArray(Module.EMPTY_ARRAY);
            task2.executeWhenBuildFinished(gradleBuildInvoker.assemble(modulesToBuild));
        }
    }
}

