/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.folding;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.configurations.Configuration;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InlinedResource {
    private static final int FOLD_MAX_LENGTH = 60;
    @NotNull
    private final ResourceReference myResourceReference;
    @NotNull
    private final ResourceRepository myResourceRepository;
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final FoldingDescriptor myDescriptor;
    private static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    InlinedResource(@NotNull ResourceReference resourceReference, @NotNull ResourceRepository resourceRepository, @NotNull FoldingDescriptor descriptor2, @NotNull PsiElement element) {
        this.myResourceRepository = resourceRepository;
        this.myResourceReference = resourceReference;
        this.myDescriptor = descriptor2;
        this.myElement = element;
    }

    @NotNull
    FoldingDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Nullable
    public String getResolvedString() {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)this.myElement);
        if (facet == null) {
            return null;
        }
        if (this.myResourceRepository.hasResources(this.myResourceReference.getNamespace(), this.myResourceReference.getResourceType(), this.myResourceReference.getName())) {
            String text2;
            FolderConfiguration referenceConfig = new FolderConfiguration();
            referenceConfig.setLocaleQualifier(new LocaleQualifier("xx"));
            Configuration configuration2 = AndroidAnnotatorUtil.pickConfiguration(this.myElement.getContainingFile(), facet);
            if (configuration2 == null) {
                return null;
            }
            ResourceResolver resourceResolver = configuration2.getResourceResolver();
            ResourceValue value2 = resourceResolver.getResolvedResource(this.myResourceReference);
            if (value2 != null && (text2 = value2.getValue()) != null) {
                String name2;
                if (this.myElement instanceof PsiMethodCallExpression) {
                    text2 = InlinedResource.insertArguments((PsiMethodCallExpression)this.myElement, text2);
                }
                if (this.myResourceReference.getResourceType() == ResourceType.BOOL) {
                    return text2;
                }
                if (this.myResourceReference.getResourceType() == ResourceType.PLURALS && text2.startsWith("@string/") && (value2 = ResourceRepositoryUtil.getConfiguredValue((ResourceRepository)this.myResourceRepository, (ResourceType)ResourceType.STRING, (String)(name2 = text2.substring("@string/".length())), (FolderConfiguration)referenceConfig)) != null && (value2 = resourceResolver.resolveResValue(value2)) != null && (text2 = value2.getValue()) != null) {
                    return "\"" + StringUtil.shortenTextWithEllipsis((String)text2, (int)58, (int)0) + "\"";
                }
                if (this.myResourceReference.getResourceType() == ResourceType.STRING || this.myElement instanceof XmlAttributeValue) {
                    return "\"" + StringUtil.shortenTextWithEllipsis((String)text2, (int)58, (int)0) + "\"";
                }
                if (this.myResourceReference.getResourceType() == ResourceType.INTEGER || text2.length() <= 1) {
                    return this.myResourceReference.getName() + ": " + text2;
                }
                return StringUtil.shortenTextWithEllipsis((String)text2, (int)60, (int)0);
            }
        }
        return null;
    }

    @NotNull
    private static String insertArguments(@NotNull PsiMethodCallExpression methodCallExpression, @NotNull String s) {
        if (s.indexOf(37) == -1) {
            return s;
        }
        PsiExpression[] args = methodCallExpression.getArgumentList().getExpressions();
        if (args.length == 0 || !args[0].isValid()) {
            return s;
        }
        if (args.length >= 3 && "getQuantityString".equals(methodCallExpression.getMethodExpression().getReferenceName())) {
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        Matcher matcher = FORMAT.matcher(s);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int start2 = 0;
        StringBuilder sb = new StringBuilder(2 * s.length());
        while (matcher.find(index)) {
            int number;
            if ("%".equals(matcher.group(6))) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            index = matcher.end();
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number <= 0 || number >= args.length) continue;
            PsiExpression argExpression = args[number];
            Object value2 = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)argExpression, (boolean)false);
            if (value2 == null) {
                value2 = args[number].getText();
            }
            for (int i = start2; i < matchStart; ++i) {
                sb.append(s.charAt(i));
            }
            sb.append('{');
            sb.append(value2);
            sb.append('}');
            start2 = index;
        }
        int n = s.length();
        for (int i = start2; i < n; ++i) {
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }
}

