/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.deploy;

import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.idea.execution.common.AndroidExecutionException;
import com.android.tools.idea.execution.common.RunConfigurationNotifier;
import com.android.tools.idea.execution.common.deploy.DeployAndHandleErrorKt;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"deployAndHandleError", "", "Lcom/android/tools/deployer/Deployer$Result;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "deployerAction", "Lkotlin/Function0;", "automaticallyApplyResolutionAction", "", "createRunnable", "Ljava/lang/Runnable;", "actionName", "", "intellij.android.execution.common"})
public final class DeployAndHandleErrorKt {
    @NotNull
    public static final List<Deployer.Result> deployAndHandleError(@NotNull ExecutionEnvironment env, @NotNull Function0<? extends List<? extends Deployer.Result>> deployerAction, boolean automaticallyApplyResolutionAction) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter(deployerAction, (String)"deployerAction");
        Logger logger = Logger.getInstance(((Object)((Object)deployAndHandleError.LOG.1.INSTANCE)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger LOG2 = logger;
        try {
            return (List)deployerAction.invoke();
        }
        catch (DeployerException e) {
            String string;
            LOG2.warn("Installation failed: " + e.getMessage() + " " + e.getDetails());
            DeployerException.Error error = e.getError();
            DeployerException.ResolutionAction resolutionAction = error.getResolution();
            if (resolutionAction == DeployerException.ResolutionAction.NONE) {
                String string2 = e.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                throw new AndroidExecutionException(string2, e.getMessage());
            }
            if (resolutionAction == DeployerException.ResolutionAction.RETRY && automaticallyApplyResolutionAction) {
                LOG2.info("Retrying previous deploy action");
                return DeployAndHandleErrorKt.deployAndHandleError(env, deployerAction, false);
            }
            StringBuilder bubbleError = new StringBuilder("Installation failed");
            String callToAction = error.getCallToAction();
            if (Intrinsics.areEqual((Object)env.getExecutor().getId(), (Object)"Debug") && resolutionAction == DeployerException.ResolutionAction.APPLY_CHANGES) {
                callToAction = "Rerun";
                resolutionAction = DeployerException.ResolutionAction.RUN_APP;
            }
            DeployerException.ResolutionAction resolutionAction2 = resolutionAction;
            switch (resolutionAction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[resolutionAction2.ordinal()]) {
                case 1: {
                    string = "android.deploy.ApplyChanges";
                    break;
                }
                case 2: 
                case 3: {
                    String string3 = env.getExecutor().getActionName();
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getActionName(...)");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown resolution action: " + resolutionAction);
                }
            }
            String actionName = string;
            Runnable actionRunnable = DeployAndHandleErrorKt.createRunnable(actionName);
            if (automaticallyApplyResolutionAction) {
                bubbleError.append('\n');
                bubbleError.append(callToAction + " will be done automatically");
                Project project = env.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                String string4 = env.getRunProfile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                String string5 = bubbleError.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                RunConfigurationNotifier.INSTANCE.notifyError(project, string4, string5);
                ApplicationManager.getApplication().invokeLater(actionRunnable);
            } else {
                String string6 = callToAction;
                Intrinsics.checkNotNull((Object)string6);
                NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)string6, (Runnable)actionRunnable);
                Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
                NotificationAction notificationAction2 = notificationAction;
                bubbleError.append('\n');
                bubbleError.append("Suggested action:");
                Project project = env.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                String string7 = env.getRunProfile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getName(...)");
                String string8 = bubbleError.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
                RunConfigurationNotifier.INSTANCE.notifyErrorWithAction(project, string7, string8, notificationAction2);
            }
            String string9 = e.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getId(...)");
            throw new AndroidExecutionException(string9, e.getMessage() + " " + e.getDetails());
        }
    }

    public static /* synthetic */ List deployAndHandleError$default(ExecutionEnvironment executionEnvironment, Function0 function0, boolean bl, int n, Object object) throws ExecutionException {
        if ((n & 4) != 0) {
            bl = false;
        }
        return DeployAndHandleErrorKt.deployAndHandleError(executionEnvironment, (Function0<? extends List<? extends Deployer.Result>>)function0, bl);
    }

    private static final Runnable createRunnable(String actionName) {
        AnAction action2 = ActionManager.getInstance().getAction(actionName);
        return () -> DeployAndHandleErrorKt.createRunnable$lambda$0(action2);
    }

    private static final void createRunnable$lambda$0(AnAction $action) {
        ActionManager.getInstance().tryToExecute($action, null, null, null, true);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeployerException.ResolutionAction.values().length];
            try {
                nArray[DeployerException.ResolutionAction.APPLY_CHANGES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeployerException.ResolutionAction.RUN_APP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeployerException.ResolutionAction.RETRY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

