/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.adb.shell.tasks;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.execution.common.AndroidExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"launchSandboxSdk", "", "device", "Lcom/android/ddmlib/IDevice;", "clientAppPackage", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getCommandAllowList", "getCommandStartSdkSandbox", "getCommandStopSdkSandbox", "SANDBOX_IS_DISABLED", "PACKAGE_NOT_FOUND", "BACKGROUND_START_NOT_ALLOWED", "SANDBOX_SDK_ALREADY_RUNNING", "FAILED_TO_START", "PACKAGE_NOT_DEBUGGABLE", "errorPatterns", "", "Ljava/util/regex/Pattern;", "intellij.android.execution.common"})
public final class LaunchSandboxSdkKt {
    @NotNull
    public static final String SANDBOX_IS_DISABLED = "(.*)SDK sandbox is disabled(.*)";
    @NotNull
    public static final String PACKAGE_NOT_FOUND = "(.*)No such package [^ ]+ for user [0-9]+(.*)";
    @NotNull
    public static final String BACKGROUND_START_NOT_ALLOWED = "(.*)android.app.BackgroundServiceStartNotAllowedException(.*)";
    @NotNull
    public static final String SANDBOX_SDK_ALREADY_RUNNING = "(.*)Sdk sandbox already running for(.*)";
    @NotNull
    public static final String FAILED_TO_START = "(.*)Sdk sandbox failed to start in [0-9]+ seconds(.*)";
    @NotNull
    public static final String PACKAGE_NOT_DEBUGGABLE = "(.*)Package [^ ]+ must be debuggable(.*)";
    @NotNull
    private static final Map<String, Pattern> errorPatterns;

    public static final void launchSandboxSdk(@NotNull IDevice device2, @NotNull String clientAppPackage, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)clientAppPackage, (String)"clientAppPackage");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        CollectingOutputReceiver stopCommandReceiver = new CollectingOutputReceiver();
        device2.executeShellCommand(LaunchSandboxSdkKt.getCommandStopSdkSandbox(clientAppPackage), (IShellOutputReceiver)stopCommandReceiver);
        String string = stopCommandReceiver.getOutput();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutput(...)");
        if (((CharSequence)string).length() > 0) {
            logger.debug(stopCommandReceiver.getOutput());
        }
        CollectingOutputReceiver allowCommandReceiver = new CollectingOutputReceiver();
        device2.executeShellCommand(LaunchSandboxSdkKt.getCommandAllowList(clientAppPackage), (IShellOutputReceiver)allowCommandReceiver);
        String string2 = allowCommandReceiver.getOutput();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOutput(...)");
        if (((CharSequence)string2).length() > 0) {
            logger.debug(allowCommandReceiver.getOutput());
        }
        CollectingOutputReceiver startCommandReceiver = new CollectingOutputReceiver();
        device2.executeShellCommand(LaunchSandboxSdkKt.getCommandStartSdkSandbox(clientAppPackage), (IShellOutputReceiver)startCommandReceiver);
        for (Map.Entry<String, Pattern> pattern : errorPatterns.entrySet()) {
            Matcher matcher = pattern.getValue().matcher(startCommandReceiver.getOutput());
            if (!matcher.find()) continue;
            throw new AndroidExecutionException(pattern.getKey(), matcher.group());
        }
        String string3 = startCommandReceiver.getOutput();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getOutput(...)");
        if (((CharSequence)string3).length() > 0) {
            logger.debug(startCommandReceiver.getOutput());
        }
    }

    @NotNull
    public static final String getCommandAllowList(@NotNull String clientAppPackage) {
        Intrinsics.checkNotNullParameter((Object)clientAppPackage, (String)"clientAppPackage");
        return "cmd deviceidle tempwhitelist " + clientAppPackage;
    }

    @NotNull
    public static final String getCommandStartSdkSandbox(@NotNull String clientAppPackage) {
        Intrinsics.checkNotNullParameter((Object)clientAppPackage, (String)"clientAppPackage");
        return "cmd sdk_sandbox start " + clientAppPackage;
    }

    @NotNull
    public static final String getCommandStopSdkSandbox(@NotNull String clientAppPackage) {
        Intrinsics.checkNotNullParameter((Object)clientAppPackage, (String)"clientAppPackage");
        return "cmd sdk_sandbox stop " + clientAppPackage;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SANDBOX_IS_DISABLED, (Object)Pattern.compile(SANDBOX_IS_DISABLED)), TuplesKt.to((Object)PACKAGE_NOT_FOUND, (Object)Pattern.compile(PACKAGE_NOT_FOUND)), TuplesKt.to((Object)BACKGROUND_START_NOT_ALLOWED, (Object)Pattern.compile(BACKGROUND_START_NOT_ALLOWED)), TuplesKt.to((Object)SANDBOX_SDK_ALREADY_RUNNING, (Object)Pattern.compile(SANDBOX_SDK_ALREADY_RUNNING)), TuplesKt.to((Object)FAILED_TO_START, (Object)Pattern.compile(FAILED_TO_START)), TuplesKt.to((Object)PACKAGE_NOT_DEBUGGABLE, (Object)Pattern.compile(PACKAGE_NOT_DEBUGGABLE))};
        errorPatterns = MapsKt.mapOf((Pair[])pairArray);
    }
}

