/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.visitors;

import com.android.tools.idea.diagnostics.hprof.parser.ConstantPoolEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfVisitor;
import com.android.tools.idea.diagnostics.hprof.parser.HeapDumpRecordType;
import com.android.tools.idea.diagnostics.hprof.parser.InstanceFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.StaticFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import com.android.tools.idea.diagnostics.hprof.util.FileBackedHashMap;
import com.android.tools.idea.diagnostics.hprof.util.IDMapper;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J_\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0016\u00a2\u0006\u0002\u0010\u001bJ(\u0010\u001c\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J(\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0005H&J\b\u0010(\u001a\u00020)H&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/RemapIDsVisitor;", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfVisitor;", "<init>", "()V", "currentID", "", "preVisit", "", "visitPrimitiveArrayDump", "arrayObjectId", "", "stackTraceSerialNumber", "numberOfElements", "elementType", "Lcom/android/tools/idea/diagnostics/hprof/parser/Type;", "visitClassDump", "classId", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;)V", "visitObjectArrayDump", "arrayClassObjectId", "objects", "", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "addMapping", "oldId", "newId", "getIDMapper", "Lcom/android/tools/idea/diagnostics/hprof/util/IDMapper;", "Companion", "intellij.android.core"})
public abstract class RemapIDsVisitor
extends HProfVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int currentID;
    private static final int KEY_SIZE = 8;
    private static final int VALUE_SIZE = 4;

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(HeapDumpRecordType.ClassDump);
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
        this.currentID = 1;
    }

    @Override
    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType) {
        Intrinsics.checkNotNullParameter((Object)((Object)elementType), (String)"elementType");
        int n = this.currentID;
        this.currentID = n + 1;
        this.addMapping(arrayObjectId, n);
    }

    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        int n = this.currentID;
        this.currentID = n + 1;
        this.addMapping(classId, n);
    }

    @Override
    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        int n = this.currentID;
        this.currentID = n + 1;
        this.addMapping(arrayObjectId, n);
    }

    @Override
    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        int n = this.currentID;
        this.currentID = n + 1;
        this.addMapping(objectId, n);
    }

    public abstract void addMapping(long var1, int var3);

    @NotNull
    public abstract IDMapper getIDMapper();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/RemapIDsVisitor$Companion;", "", "<init>", "()V", "createMemoryBased", "Lcom/android/tools/idea/diagnostics/hprof/visitors/RemapIDsVisitor;", "createFileBased", "channel", "Ljava/nio/channels/FileChannel;", "maxInstanceCount", "", "isSupported", "", "instanceCount", "KEY_SIZE", "", "VALUE_SIZE", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemapIDsVisitor createMemoryBased() {
            Long2IntOpenHashMap map2 = new Long2IntOpenHashMap();
            map2.put(0L, 0);
            return new RemapIDsVisitor(map2){
                final /* synthetic */ Long2IntOpenHashMap $map;
                {
                    this.$map = $map;
                }

                public void addMapping(long oldId, int newId) {
                    if (oldId != 0L) {
                        this.$map.put(oldId, newId);
                    }
                }

                public IDMapper getIDMapper() {
                    return new IDMapper(this.$map){
                        final /* synthetic */ Long2IntOpenHashMap $map;
                        {
                            this.$map = $map;
                        }

                        public long getID(long id2) {
                            if (this.isValidID(id2)) {
                                return this.$map.get(id2);
                            }
                            return 0L;
                        }

                        public boolean isValidID(long id2) {
                            return this.$map.containsKey(id2);
                        }
                    };
                }
            };
        }

        @NotNull
        public final RemapIDsVisitor createFileBased(@NotNull FileChannel channel, long maxInstanceCount) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            FileBackedHashMap remapIDsMap = FileBackedHashMap.Companion.createEmpty(channel, maxInstanceCount, 8, 4);
            return new RemapIDsVisitor(remapIDsMap){
                final /* synthetic */ FileBackedHashMap $remapIDsMap;
                {
                    this.$remapIDsMap = $remapIDsMap;
                }

                public void addMapping(long oldId, int newId) {
                    if (oldId == 0L) {
                        return;
                    }
                    this.$remapIDsMap.put(oldId).putInt(newId);
                }

                public IDMapper getIDMapper() {
                    return new IDMapper(this.$remapIDsMap){
                        final /* synthetic */ FileBackedHashMap $remapIDsMap;
                        {
                            this.$remapIDsMap = $remapIDsMap;
                        }

                        public long getID(long id2) {
                            long l;
                            if (id2 == 0L) {
                                l = 0L;
                            } else if (this.$remapIDsMap.containsKey(id2)) {
                                ByteBuffer byteBuffer = this.$remapIDsMap.get(id2);
                                Intrinsics.checkNotNull((Object)byteBuffer);
                                l = byteBuffer.getInt();
                            } else {
                                return 0L;
                            }
                            return l;
                        }

                        public boolean isValidID(long id2) {
                            return this.$remapIDsMap.containsKey(id2);
                        }
                    };
                }
            };
        }

        public final boolean isSupported(long instanceCount) {
            return FileBackedHashMap.Companion.isSupported(instanceCount, 8, 4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

