/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.util;

import java.io.Closeable;
import java.util.LinkedList;
import java.util.Queue;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/TruncatingPrintBuffer;", "Ljava/io/Closeable;", "headLimit", "", "tailLimit", "printFunc", "Lkotlin/Function1;", "", "", "<init>", "(IILkotlin/jvm/functions/Function1;)V", "queue", "Ljava/util/Queue;", "linesPrinted", "linesLost", "closed", "", "close", "", "println", "s", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nTruncatingPrintBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TruncatingPrintBuffer.kt\ncom/android/tools/idea/diagnostics/hprof/util/TruncatingPrintBuffer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1869#2,2:66\n*S KotlinDebug\n*F\n+ 1 TruncatingPrintBuffer.kt\ncom/android/tools/idea/diagnostics/hprof/util/TruncatingPrintBuffer\n*L\n44#1:66,2\n*E\n"})
public final class TruncatingPrintBuffer
implements Closeable {
    private final int headLimit;
    private final int tailLimit;
    @NotNull
    private final Function1<String, Object> printFunc;
    @NotNull
    private final Queue<String> queue;
    private int linesPrinted;
    private int linesLost;
    private boolean closed;

    public TruncatingPrintBuffer(int headLimit, int tailLimit, @NotNull Function1<? super String, ? extends Object> printFunc) {
        Intrinsics.checkNotNullParameter(printFunc, (String)"printFunc");
        this.headLimit = headLimit;
        this.tailLimit = tailLimit;
        this.printFunc = printFunc;
        this.queue = new LinkedList();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.linesLost > 0) {
            int n;
            while (this.queue.size() > this.tailLimit) {
                this.queue.remove();
                n = this.linesLost;
                this.linesLost = n + 1;
            }
            int n2 = n = this.linesLost > 1 ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.printFunc.invoke((Object)("[...removed " + this.linesLost + " lines...]"));
        }
        Iterable $this$forEach$iv = this.queue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.printFunc.invoke((Object)it);
        }
        this.queue.clear();
    }

    public final void println(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.linesPrinted < this.headLimit) {
            this.printFunc.invoke((Object)s);
            int n = this.linesPrinted;
            this.linesPrinted = n + 1;
        } else {
            this.queue.add(s);
            if (this.queue.size() > this.tailLimit + 1) {
                this.queue.remove();
                int n = this.linesLost;
                this.linesLost = n + 1;
            }
        }
    }

    public static /* synthetic */ void println$default(TruncatingPrintBuffer truncatingPrintBuffer, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        truncatingPrintBuffer.println(string);
    }
}

