/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.HeapTraverseNode;
import com.android.tools.idea.diagnostics.heap.MemoryReportJniHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectTagUtil {
    static final int INVALID_OBJECT_ID = -1;
    static final int INVALID_OBJECT_DEPTH = -1;
    private static final long CURRENT_ITERATION_ID_MASK = 255L;
    private static final long CURRENT_ITERATION_VISITED_MASK = 256L;
    private static final long CURRENT_ITERATION_OBJECT_ID_MASK = 2199023255040L;
    private static final int CURRENT_ITERATION_OBJECT_ID_OFFSET = 9;
    private static final int CURRENT_ITERATION_OBJECT_DEPTH_OFFSET = 41;
    private static final long CURRENT_ITERATION_OBJECT_DEPTH_MASK = 288228177128456192L;
    private static final long OBJECT_OWNED_BY_EXCEEDED_COMPONENT_BIT_MASK = 0x400000000000000L;
    private static final int OBJECT_OWNING_EXCEEDED_COMPONENT_OFFSET = 59;
    static final int EXCEEDED_COMPONENTS_LIMIT = 16;
    private static final long OBJECT_OWNING_EXCEEDED_COMPONENT_MASK = 0x7800000000000000L;
    private static final int DEPTH_KIND_OFFSET = 63;
    private static final long DEPTH_KIND_MASK = Long.MIN_VALUE;

    static int getObjectId(long tag, short currentIterationId) {
        if (!ObjectTagUtil.isTagFromTheCurrentIteration(tag, currentIterationId)) {
            return -1;
        }
        return (int)((tag & 0x1FFFFFFFE00L) >> 9);
    }

    static boolean wasVisited(long tag, short currentIterationId) {
        if (!ObjectTagUtil.isTagFromTheCurrentIteration(tag, currentIterationId)) {
            return false;
        }
        return (tag & 0x100L) != 0L;
    }

    static int getDepth(long tag, short currentIterationId) {
        if (!ObjectTagUtil.isTagFromTheCurrentIteration(tag, currentIterationId)) {
            return -1;
        }
        return (int)((tag & 0x3FFFE0000000000L) >> 41);
    }

    @Nullable
    static HeapTraverseNode.MinDepthKind getDepthKind(long tag, short currentIterationId) {
        if (!ObjectTagUtil.isTagFromTheCurrentIteration(tag, currentIterationId)) {
            return null;
        }
        return HeapTraverseNode.minDepthKindFromByte((byte)((tag & Long.MIN_VALUE) >>> 63));
    }

    static void setObjectId(@NotNull Object obj, long tag, int newObjectId, short currentIterationId) {
        tag &= 0xFFFFFE00000001FFL;
        tag |= (long)newObjectId << 9;
        tag &= 0xFFFFFFFFFFFFFF00L;
        MemoryReportJniHelper.setObjectTag(obj, tag |= (long)currentIterationId);
    }

    static long constructTag(int objectId, int depth, HeapTraverseNode.MinDepthKind minDepthKind, short currentIterationId, boolean isOwnedByExceededComponent, int currentExceededClusterIndex) {
        assert (0 <= currentExceededClusterIndex);
        assert (currentExceededClusterIndex < 32);
        long tag = 0L;
        tag |= (long)objectId << 9 & 0x1FFFFFFFE00L;
        tag |= (long)depth << 41 & 0x3FFFE0000000000L;
        if (isOwnedByExceededComponent) {
            tag |= 0x400000000000000L;
        }
        tag |= (long)currentExceededClusterIndex << 59 & 0x7800000000000000L;
        if (minDepthKind != HeapTraverseNode.MinDepthKind.DEFAULT) {
            tag |= (long)minDepthKind.getValue() << 63 & Long.MIN_VALUE;
        }
        return tag |= (long)currentIterationId;
    }

    static long markVisited(@NotNull Object obj, long tag, short currentIterationId) {
        tag &= 0xFFFFFFFFFFFFFEFFL;
        tag |= 0x100L;
        tag &= 0xFFFFFFFFFFFFFF00L;
        MemoryReportJniHelper.setObjectTag(obj, tag |= (long)currentIterationId);
        return tag;
    }

    private static boolean isTagFromTheCurrentIteration(long tag, short currentIterationId) {
        return (tag & 0xFFL) == (long)currentIterationId;
    }

    public static boolean isOwnedByExceededComponent(long tag) {
        return (tag & 0x400000000000000L) != 0L;
    }

    public static byte getOwningExceededClusterIndex(long tag) {
        return (byte)((tag & 0x7800000000000000L) >>> 59);
    }
}

