/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HeapTraverseNode {
    @NotNull
    private final WeakReference<?> weakReference;
    public RefWeight ownershipWeight;
    public long ownedByComponentMask;
    public long retainedMask;
    public int retainedMaskForCategories;
    public boolean isMergePoint;
    public boolean isRetainedByPlatform;
    @Nullable
    public Integer minDepth = null;
    @Nullable
    public MinDepthKind minDepthKind = null;

    @Nullable
    static MinDepthKind minDepthKindFromByte(byte minDepthKindByte) {
        return switch (minDepthKindByte) {
            case 0 -> MinDepthKind.DEFAULT;
            case 1 -> MinDepthKind.USING_DISPOSED_OBJECTS;
            default -> null;
        };
    }

    HeapTraverseNode(@Nullable Object obj, @NotNull RefWeight ownershipWeight, long ownedByComponentMask, long retainedMask, int retainedMaskForCategories, boolean isMergePoint, boolean isRetainedByPlatform) {
        this.weakReference = new WeakReference<Object>(obj);
        this.ownershipWeight = ownershipWeight;
        this.ownedByComponentMask = ownedByComponentMask;
        this.retainedMask = retainedMask;
        this.retainedMaskForCategories = retainedMaskForCategories;
        this.isMergePoint = isMergePoint;
        this.isRetainedByPlatform = isRetainedByPlatform;
    }

    HeapTraverseNode(@Nullable Object obj, byte ownershipWeight, long ownedByComponentMask, long retainedMask, int retainedMaskForCategories, boolean isMergePoint, boolean isRetainedByPlatform) {
        this(obj, HeapTraverseNode.refWeightFromByte(ownershipWeight), ownedByComponentMask, retainedMask, retainedMaskForCategories, isMergePoint, isRetainedByPlatform);
    }

    @Nullable
    Object getObject() {
        return this.weakReference.get();
    }

    private static RefWeight refWeightFromByte(byte refWeightByte) {
        return switch (refWeightByte) {
            case 1 -> RefWeight.NON_COMPONENT;
            case 2 -> RefWeight.SYNTHETIC;
            case 3 -> RefWeight.ARRAY_ELEMENT;
            case 4 -> RefWeight.INSTANCE_FIELD;
            case 5 -> RefWeight.STATIC_FIELD;
            case 6 -> RefWeight.DISPOSER_TREE_REFERENCE;
            default -> RefWeight.DEFAULT;
        };
    }

    static native void cacheHeapSnapshotTraverseNodeConstructorId(Class<?> var0);

    static native void clearObjectIdToTraverseNodeMap();

    static native void putOrUpdateObjectIdToTraverseNodeMap(int var0, @NotNull Object var1, byte var2, long var3, long var5, int var7, boolean var8, boolean var9);

    static native int getObjectIdToTraverseNodeMapSize();

    static native void removeElementFromObjectIdToTraverseNodeMap(int var0);

    static native HeapTraverseNode getObjectIdToTraverseNodeMapElement(int var0, Class<?> var1);

    static enum MinDepthKind {
        DEFAULT(0),
        USING_DISPOSED_OBJECTS(1);

        private final byte value;

        private MinDepthKind(byte value2) {
            this.value = value2;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static enum RefWeight {
        DEFAULT(0),
        NON_COMPONENT(1),
        SYNTHETIC(2),
        ARRAY_ELEMENT(3),
        INSTANCE_FIELD(4),
        STATIC_FIELD(5),
        DISPOSER_TREE_REFERENCE(6);

        private final byte value;

        private RefWeight(byte value2) {
            this.value = value2;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

