/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.GoogleCrashReporter;
import com.android.tools.idea.diagnostics.heap.ComponentsSet;
import com.android.tools.idea.diagnostics.heap.ExtendedReportStatistics;
import com.android.tools.idea.diagnostics.heap.FieldCache;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverseException;
import com.android.tools.idea.diagnostics.heap.HeapTraverseConfig;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.MemoryReportCollector;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.android.tools.idea.diagnostics.heap.RootPathTreePrinter;
import com.android.tools.idea.diagnostics.report.DiagnosticCrashReport;
import com.android.tools.idea.diagnostics.report.DiagnosticReportProperties;
import com.google.common.base.Ascii;
import com.google.wireless.android.sdk.stats.MemoryUsageReportEvent;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.ide.PowerSaveMode;
import com.intellij.util.containers.WeakList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeapSnapshotStatistics {
    private static final int MAX_BYTES_FOR_REPORT_ATTACHMENT_FILE = 1200000;
    private static final int MAX_BYTES_FOR_HEAP_SUMMARY_FIELD = 250000;
    @NotNull
    final ClusterObjectsStatistics.ObjectsStatisticsWithPlatformTracking totalStats = new ClusterObjectsStatistics.ObjectsStatisticsWithPlatformTracking();
    @NotNull
    private final List<ComponentClusterObjectsStatistics> componentStats = new ArrayList<ComponentClusterObjectsStatistics>();
    @NotNull
    private final List<CategoryClusterObjectsStatistics> categoryComponentStats = new ArrayList<CategoryClusterObjectsStatistics>();
    @NotNull
    final Long2ObjectMap<SharedClusterStatistics> maskToSharedComponentStats = new Long2ObjectOpenHashMap();
    int maxFieldsCacheSize = 0;
    int maxObjectsQueueSize = 0;
    int enumeratedGarbageCollectedObjects = 0;
    int unsuccessfulFieldAccessCounter = 0;
    int heapObjectCount = 0;
    private short traverseSessionId;
    @NotNull
    private final HeapTraverseConfig config;
    @Nullable
    private final ExtendedReportStatistics extendedReportStatistics;

    HeapSnapshotStatistics(@NotNull ComponentsSet componentsSet) {
        this(new HeapTraverseConfig(componentsSet, false, false));
    }

    HeapSnapshotStatistics(@NotNull HeapTraverseConfig config) {
        this.config = config;
        for (ComponentsSet.Component component : config.getComponentsSet().getComponents()) {
            this.componentStats.add(new ComponentClusterObjectsStatistics(component));
        }
        for (ComponentsSet.ComponentCategory category : config.getComponentsSet().getComponentsCategories()) {
            this.categoryComponentStats.add(new CategoryClusterObjectsStatistics(category));
        }
        this.extendedReportStatistics = config.collectHistograms ? new ExtendedReportStatistics(config) : null;
    }

    @NotNull
    public List<ComponentClusterObjectsStatistics> getComponentStats() {
        return this.componentStats;
    }

    @NotNull
    public List<CategoryClusterObjectsStatistics> getCategoryComponentStats() {
        return this.categoryComponentStats;
    }

    void addObjectSizeToSharedComponent(long sharedMask, long size, String objectClassName, boolean isMergePoint, boolean isPlatformObject, boolean isRetainedByPlatform, boolean isDisposedButReferenced) {
        if (!this.maskToSharedComponentStats.containsKey(sharedMask)) {
            this.maskToSharedComponentStats.put(sharedMask, (Object)new SharedClusterStatistics(sharedMask));
        }
        SharedClusterStatistics stats = (SharedClusterStatistics)this.maskToSharedComponentStats.get(sharedMask);
        stats.getStatistics().addObject(size, isPlatformObject, isRetainedByPlatform);
        if (this.config.collectHistograms && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addClassNameToSharedClusterHistogram(stats, objectClassName, size, isMergePoint, isDisposedButReferenced);
        }
    }

    void addOwnedObjectSizeToComponent(int componentId, long size, String objectClassName, boolean isRoot2, boolean isPlatformObject, boolean isRetainedByPlatform, boolean isDisposedButReferenced) {
        ComponentClusterObjectsStatistics stats = this.componentStats.get(componentId);
        stats.addOwnedObject(size, isPlatformObject, isRetainedByPlatform);
        if (this.config.collectHistograms && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addClassNameToComponentOwnedHistogram((ComponentsSet.Component)stats.getCluster(), objectClassName, size, isRoot2, isDisposedButReferenced);
        }
    }

    void addObjectToTotal(long size, boolean isPlatformObject, boolean isRetainedByPlatform) {
        this.totalStats.addObject(size, isPlatformObject, isRetainedByPlatform);
    }

    void addRetainedObjectSizeToCategoryComponent(int categoryId, long size, boolean isPlatformObject, boolean isRetainedByPlatform) {
        this.categoryComponentStats.get(categoryId).addRetainedObject(size, isPlatformObject, isRetainedByPlatform);
    }

    void addOwnedObjectSizeToCategoryComponent(int categoryId, long size, String objectClassName, boolean isRoot2, boolean isPlatformObject, boolean isRetainedByPlatform, boolean isDisposedButReferenced) {
        CategoryClusterObjectsStatistics stats = this.categoryComponentStats.get(categoryId);
        stats.addOwnedObject(size, isPlatformObject, isRetainedByPlatform);
        if (this.config.collectHistograms && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addClassNameToCategoryOwnedHistogram((ComponentsSet.ComponentCategory)stats.getCluster(), objectClassName, size, isRoot2, isDisposedButReferenced);
        }
    }

    void addRetainedObjectSizeToComponent(int componentID, long size, boolean isPlatformObject, boolean isRetainedByPlatform) {
        this.componentStats.get(componentID).addRetainedObject(size, isPlatformObject, isRetainedByPlatform);
    }

    void addDisposedButReferencedObject(long size, String objectClassName) {
        if (this.config.collectDisposerTreeInfo && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addDisposedButReferencedObject(size, objectClassName);
        }
    }

    public void calculateExtendedReportDataIfNeeded(@NotNull FieldCache fieldCache, @NotNull MemoryReportCollector collector, @NotNull WeakList<Object> startRoots, @NotNull Map<String, ExtendedReportStatistics.ClassObjectsStatistics> nameToClassObjectsStatistics) throws HeapSnapshotTraverseException {
        if (this.extendedReportStatistics == null || !this.config.collectObjectTreesData) {
            return;
        }
        this.extendedReportStatistics.calculateExtendedReportData(this.config, fieldCache, collector, startRoots, nameToClassObjectsStatistics);
    }

    public void checkClassIsTrackedAndAdd(@NotNull String className) {
        ComponentsSet componentsSet = this.config.getComponentsSet();
        for (ComponentsSet.ComponentCategory category : componentsSet.getCategoriesTrackingClassName().get((Object)className)) {
            this.categoryComponentStats.get(category.getId()).addTrackedFQNInstance(className);
        }
        for (ComponentsSet.Component component : componentsSet.getComponentsTrackingClassName().get((Object)className)) {
            this.componentStats.get(component.getId()).addTrackedFQNInstance(className);
        }
    }

    private static String getOptimalUnitsStatisticsPresentation(@NotNull ObjectsStatistics statistics) {
        return HeapTraverseUtil.getObjectsStatsPresentation(statistics, MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.OPTIMAL_UNITS);
    }

    @NotNull
    CrashReport asCrashReport(final @NotNull List<ComponentsSet.Component> exceededComponents, final @NotNull ComponentsSet.Component targetExceededComponent, final @NotNull MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode) {
        if (this.extendedReportStatistics == null) {
            throw new IllegalStateException("Extended memory report required for sending a Crash report was not calculated.");
        }
        return new DiagnosticCrashReport("Extended Memory Report", new DiagnosticReportProperties()){

            public void serialize(@NotNull MultipartEntityBuilder builder) {
                super.serialize(builder);
                String exceededComponentsPresentation = exceededComponents.stream().map(ComponentsSet.Cluster::getLabel).collect(Collectors.joining(","));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"signature", (String)("Cluster that exceeded the memory usage threshold:" + targetExceededComponent.getLabel()));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Total used memory", (String)HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(HeapSnapshotStatistics.this.totalStats.getObjectsStatistics()));
                String totalPlatformObjectsPresentation = String.format("%s[%s]", HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(HeapSnapshotStatistics.this.totalStats.platformObjectsSelfStats), HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(HeapSnapshotStatistics.this.totalStats.platformRetainedObjectsStats));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Total platform objects memory", (String)totalPlatformObjectsPresentation);
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Target exceeded cluster", (String)targetExceededComponent.getLabel());
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Target exceeded cluster owned memory", (String)HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(HeapSnapshotStatistics.this.componentStats.get((int)targetExceededComponent.getId()).getOwnedClusterStat().objectsStat));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"All clusters that exceeded the memory usage threshold", (String)exceededComponentsPresentation);
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Number of nodes in GC root paths trees", (String)String.valueOf(HeapSnapshotStatistics.this.extendedReportStatistics.rootPathTree.getNumberOfRootPathTreeNodes()));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Status code", (String)statusCode.name());
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Number of duplicated class loaders", (String)String.valueOf(HeapSnapshotStatistics.this.extendedReportStatistics.globalNominatedClassLoaders.size()));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Number of nominated class loaders", (String)String.valueOf(HeapSnapshotStatistics.this.extendedReportStatistics.componentToExceededClustersStatistics.get((Object)targetExceededComponent).nominatedClassLoaders.size()));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"heapSummary", (String)HeapSnapshotStatistics.this.collectHeapSummary(targetExceededComponent));
                DisposedObjectsInfo disposedObjectsInfo = new DisposedObjectsInfo();
                builder.addBinaryBody("extendedMemoryReport", HeapSnapshotStatistics.this.collectExtendedReport(targetExceededComponent, disposedObjectsInfo).getBytes(), ContentType.TEXT_PLAIN, "extendedMemoryReport.txt");
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Number of disposed objects with size at least 1mb", (String)String.valueOf(disposedObjectsInfo.numberOfDisposedObjectsWithAtLeast1mb));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Number of disposed objects with size at least 10mb", (String)String.valueOf(disposedObjectsInfo.numberOfDisposedObjectsWithAtLeast10mb));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder, (String)"Number of disposed objects with size at least 100mb", (String)String.valueOf(disposedObjectsInfo.numberOfDisposedObjectsWithAtLeast100mb));
            }
        };
    }

    @NotNull
    private String collectHeapSummary(@NotNull ComponentsSet.Component targetExceededComponent) {
        StringBuilder builder = new StringBuilder();
        assert (this.extendedReportStatistics != null);
        new RootPathTreePrinter.RootPathTreeSummaryPrinter(this.extendedReportStatistics, this.extendedReportStatistics.componentToExceededClustersStatistics.get(targetExceededComponent), this.config.summaryRequiredSubtreeSize).print(s -> HeapSnapshotStatistics.appendLine(builder, s));
        return Ascii.truncate((CharSequence)builder.toString(), (int)250000, (String)"[truncated]");
    }

    private static void appendLine(@NotNull StringBuilder builder, @NotNull String text2) {
        builder.append(text2).append("\n");
    }

    private void addClusterHistograms(@NotNull StringBuilder builder, @NotNull String clusterLabel, @NotNull ClusterObjectsStatistics<?> stat, @NotNull ExtendedReportStatistics.ClusterHistogram.ClusterType clusterType) {
        HeapSnapshotStatistics.appendLine(builder, HeapReportUtils.INSTANCE.sectionHeader(clusterLabel));
        HeapSnapshotStatistics.appendLine(builder, String.format(Locale.US, "Owned: %s", HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(stat.getOwnedClusterStat().getObjectsStatistics())));
        if (this.extendedReportStatistics != null) {
            this.extendedReportStatistics.logClusterHistogram(s -> HeapSnapshotStatistics.appendLine(builder, s), (ComponentsSet.Cluster)stat.getCluster(), clusterType);
        }
        if (!stat.getTrackedFQNInstanceCounter().isEmpty()) {
            HeapSnapshotStatistics.appendLine(builder, "Number of instances of tracked classes:");
            for (String s2 : stat.getTrackedFQNInstanceCounter().keySet()) {
                HeapSnapshotStatistics.appendLine(builder, String.format(Locale.US, "      %s:%d", s2, stat.getTrackedFQNInstanceCounter().getInt((Object)s2)));
            }
        }
        HeapSnapshotStatistics.appendLine(builder, String.format(Locale.US, "Platform object: %s[%s]", HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(stat.getOwnedClusterStat().platformObjectsSelfStats), HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(stat.getOwnedClusterStat().platformRetainedObjectsStats)));
    }

    @NotNull
    private String collectExtendedReport(@NotNull ComponentsSet.Component targetExceededComponent, @NotNull DisposedObjectsInfo disposedObjectsInfo) {
        StringBuilder extendedReportBuilder = new StringBuilder();
        for (CategoryClusterObjectsStatistics categoryClusterObjectsStatistics : this.categoryComponentStats) {
            this.addClusterHistograms(extendedReportBuilder, "Category " + ((ComponentsSet.ComponentCategory)categoryClusterObjectsStatistics.getCluster()).getLabel(), categoryClusterObjectsStatistics, ExtendedReportStatistics.ClusterHistogram.ClusterType.CATEGORY);
        }
        for (ComponentClusterObjectsStatistics componentClusterObjectsStatistics : this.componentStats) {
            this.addClusterHistograms(extendedReportBuilder, "Component " + ((ComponentsSet.Component)componentClusterObjectsStatistics.getCluster()).getLabel(), componentClusterObjectsStatistics, ExtendedReportStatistics.ClusterHistogram.ClusterType.COMPONENT);
        }
        this.maskToSharedComponentStats.values().stream().sorted(Comparator.comparingLong(a -> a.getStatistics().getObjectsStatistics().getTotalSizeInBytes()).reversed()).limit(10L).forEach(stat -> {
            HeapSnapshotStatistics.appendLine(extendedReportBuilder, HeapReportUtils.INSTANCE.sectionHeader("Shared cluster " + HeapSnapshotStatistics.getSharedClusterPresentationLabel(stat, this)));
            HeapSnapshotStatistics.appendLine(extendedReportBuilder, String.format(Locale.US, "Owned: %s\n", HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(stat.getStatistics().getObjectsStatistics())));
            if (this.extendedReportStatistics != null) {
                this.extendedReportStatistics.logSharedClusterHistogram(s -> HeapSnapshotStatistics.appendLine(extendedReportBuilder, s), (SharedClusterStatistics)stat);
            }
        });
        if (this.extendedReportStatistics != null) {
            HeapSnapshotStatistics.appendLine(extendedReportBuilder, HeapReportUtils.INSTANCE.sectionHeader("Exceeded cluster " + targetExceededComponent.getLabel()));
            this.extendedReportStatistics.printExceededClusterStatisticsIfNeeded(s -> HeapSnapshotStatistics.appendLine(extendedReportBuilder, s), targetExceededComponent, disposedObjectsInfo);
            HeapSnapshotStatistics.appendLine(extendedReportBuilder, HeapReportUtils.INSTANCE.sectionHeader("Disposer tree report"));
            this.extendedReportStatistics.logDisposerTreeReport(s -> HeapSnapshotStatistics.appendLine(extendedReportBuilder, s));
        }
        return Ascii.truncate((CharSequence)extendedReportBuilder.toString(), (int)1200000, (String)"[truncated]");
    }

    void print(@NotNull Consumer<String> writer2, @NotNull Function<ObjectsStatistics, String> objectsStatsPresentation, @NotNull MemoryReportCollector.HeapSnapshotPresentationConfig presentationConfig, long collectionTimeMs) {
        writer2.accept(String.format(Locale.US, "Total used memory: %s", objectsStatsPresentation.apply(this.totalStats.getObjectsStatistics())));
        writer2.accept(String.format(Locale.US, "Total platform objects memory: %s[%s]", objectsStatsPresentation.apply(this.totalStats.platformObjectsSelfStats), objectsStatsPresentation.apply(this.totalStats.platformRetainedObjectsStats)));
        ObjectsStatistics sharedObjectsStatistics = new ObjectsStatistics();
        this.maskToSharedComponentStats.values().forEach(e -> sharedObjectsStatistics.addStats(e.getStatistics().objectsStat));
        writer2.accept(String.format(Locale.US, "Total shared memory: %s", objectsStatsPresentation.apply(sharedObjectsStatistics)));
        writer2.accept(String.format(Locale.US, "Report collection time: %d ms", collectionTimeMs));
        writer2.accept(String.format(Locale.US, "%d Categories:", this.categoryComponentStats.size()));
        for (CategoryClusterObjectsStatistics categoryClusterObjectsStatistics : this.categoryComponentStats) {
            writer2.accept(String.format(Locale.US, "  Category %s:", ((ComponentsSet.ComponentCategory)categoryClusterObjectsStatistics.getCluster()).getLabel()));
            writer2.accept(String.format(Locale.US, "    Owned: %s", objectsStatsPresentation.apply(categoryClusterObjectsStatistics.getOwnedClusterStat().getObjectsStatistics())));
            if (this.config.collectHistograms && this.extendedReportStatistics != null) {
                this.extendedReportStatistics.logCategoryHistogram(writer2, (ComponentsSet.ComponentCategory)categoryClusterObjectsStatistics.getCluster());
            }
            if (presentationConfig.shouldLogRetainedSizes) {
                writer2.accept(String.format(Locale.US, "    Retained: %s", objectsStatsPresentation.apply(categoryClusterObjectsStatistics.getRetainedClusterStat().objectsStat)));
            }
            if (!categoryClusterObjectsStatistics.getTrackedFQNInstanceCounter().isEmpty()) {
                writer2.accept("    Number of instances of tracked classes:");
                for (String s2 : categoryClusterObjectsStatistics.getTrackedFQNInstanceCounter().keySet()) {
                    writer2.accept(String.format(Locale.US, "      %s:%d", s2, categoryClusterObjectsStatistics.getTrackedFQNInstanceCounter().getInt((Object)s2)));
                }
            }
            writer2.accept(String.format(Locale.US, "    Platform object: %s[%s]", objectsStatsPresentation.apply(categoryClusterObjectsStatistics.getOwnedClusterStat().platformObjectsSelfStats), objectsStatsPresentation.apply(categoryClusterObjectsStatistics.getOwnedClusterStat().platformRetainedObjectsStats)));
        }
        writer2.accept(String.format(Locale.US, "%d Components:", this.componentStats.size()));
        for (ComponentClusterObjectsStatistics componentClusterObjectsStatistics : this.componentStats) {
            writer2.accept(String.format(Locale.US, "  Component %s:", ((ComponentsSet.Component)componentClusterObjectsStatistics.getCluster()).getLabel()));
            writer2.accept(String.format(Locale.US, "    Owned: %s", objectsStatsPresentation.apply(componentClusterObjectsStatistics.getOwnedClusterStat().getObjectsStatistics())));
            if (this.config.collectHistograms && this.extendedReportStatistics != null) {
                this.extendedReportStatistics.logComponentHistogram(writer2, (ComponentsSet.Component)componentClusterObjectsStatistics.getCluster());
                if (this.extendedReportStatistics.componentToExceededClustersStatistics.containsKey(componentClusterObjectsStatistics.getCluster())) {
                    this.extendedReportStatistics.printExceededClusterStatisticsIfNeeded(writer2, (ComponentsSet.Component)componentClusterObjectsStatistics.getCluster(), new DisposedObjectsInfo());
                }
            }
            if (presentationConfig.shouldLogRetainedSizes) {
                writer2.accept(String.format(Locale.US, "    Retained: %s", objectsStatsPresentation.apply(componentClusterObjectsStatistics.getRetainedClusterStat().objectsStat)));
            }
            writer2.accept(String.format(Locale.US, "    Platform object: %s[%s]", objectsStatsPresentation.apply(componentClusterObjectsStatistics.getOwnedClusterStat().platformObjectsSelfStats), objectsStatsPresentation.apply(componentClusterObjectsStatistics.getOwnedClusterStat().platformRetainedObjectsStats)));
        }
        if (presentationConfig.shouldLogSharedClusters) {
            writer2.accept("Shared clusters:");
            this.maskToSharedComponentStats.values().stream().sorted(Comparator.comparingLong(a -> -a.getStatistics().objectsStat.getTotalSizeInBytes())).limit(10L).forEach(s -> {
                writer2.accept(String.format(Locale.US, "  %s: %s", HeapSnapshotStatistics.getSharedClusterPresentationLabel(s, this), objectsStatsPresentation.apply(s.getStatistics().objectsStat)));
                if (this.config.collectHistograms && this.extendedReportStatistics != null) {
                    this.extendedReportStatistics.logSharedClusterHistogram(writer2, (SharedClusterStatistics)s);
                }
            });
        }
        if (this.extendedReportStatistics != null) {
            this.extendedReportStatistics.logDisposerTreeReport(writer2);
        }
    }

    static String getSharedClusterPresentationLabel(@NotNull SharedClusterStatistics clusterStats, @NotNull HeapSnapshotStatistics stats) {
        return clusterStats.getComponentIds(stats.getConfig()).stream().map(id2 -> ((ComponentsSet.Component)stats.getComponentStats().get((int)id2).getCluster()).getLabel()).toList().toString();
    }

    void updateMaxFieldsCacheSize(int currentFieldSize) {
        this.maxFieldsCacheSize = Math.max(this.maxFieldsCacheSize, currentFieldSize);
    }

    void updateMaxObjectsQueueSize(int currentObjectsQueueSize) {
        this.maxObjectsQueueSize = Math.max(this.maxObjectsQueueSize, currentObjectsQueueSize);
    }

    void incrementGarbageCollectedObjectsCounter() {
        ++this.enumeratedGarbageCollectedObjects;
    }

    void incrementUnsuccessfulFieldAccessCounter() {
        ++this.unsuccessfulFieldAccessCounter;
    }

    void setHeapObjectCount(int heapObjectCount) {
        this.heapObjectCount = heapObjectCount;
    }

    @NotNull
    private MemoryUsageReportEvent.ObjectsStatistics buildObjectStatistics(@NotNull ObjectsStatistics objectsStatistics) {
        return MemoryUsageReportEvent.ObjectsStatistics.newBuilder().setObjectsCount(objectsStatistics.getObjectsCount()).setTotalSizeBytes(objectsStatistics.getTotalSizeInBytes()).build();
    }

    @NotNull
    private MemoryUsageReportEvent.MemoryTrafficStatistics buildMemoryTrafficStatistics(@NotNull ClusterObjectsStatistics.ObjectsStatisticsWithPlatformTracking statistics) {
        return MemoryUsageReportEvent.MemoryTrafficStatistics.newBuilder().setTotalStats(this.buildObjectStatistics(statistics.getObjectsStatistics())).setPlatformObjectsStats(this.buildObjectStatistics(statistics.getPlatformObjectsSelfStats())).setPlatformRetainedStats(this.buildObjectStatistics(statistics.getPlatformRetainedObjectsStats())).build();
    }

    @NotNull
    private MemoryUsageReportEvent.ClusterObjectsStatistics buildClusterObjectsStatistics(@NotNull ClusterObjectsStatistics<?> componentStatistics) {
        return MemoryUsageReportEvent.ClusterObjectsStatistics.newBuilder().setOwnedClusterStats(this.buildMemoryTrafficStatistics(componentStatistics.getOwnedClusterStat())).setRetainedClusterStats(this.buildMemoryTrafficStatistics(componentStatistics.getRetainedClusterStat())).build();
    }

    @NotNull
    MemoryUsageReportEvent buildMemoryUsageReportEvent(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode, long executionTimeMs, long executionStartMs, int sharedComponentsLimit) {
        MemoryUsageReportEvent.Builder builder = MemoryUsageReportEvent.newBuilder();
        for (ComponentClusterObjectsStatistics componentStat : this.componentStats) {
            builder.addComponentStats(MemoryUsageReportEvent.ClusterMemoryUsage.newBuilder().setLabel(((ComponentsSet.Component)componentStat.getCluster()).getLabel()).setStats(this.buildClusterObjectsStatistics(componentStat)).putAllInstanceCountPerClassName(componentStat.getTrackedFQNInstanceCounter()));
        }
        this.maskToSharedComponentStats.values().stream().sorted(Comparator.comparingLong(s -> -s.getStatistics().objectsStat.getTotalSizeInBytes())).limit(sharedComponentsLimit).forEach(s -> builder.addSharedComponentStats(MemoryUsageReportEvent.SharedClusterMemoryUsage.newBuilder().addAllIds(s.getComponentIds(this.config)).setStats(this.buildMemoryTrafficStatistics(s.statistics))));
        for (CategoryClusterObjectsStatistics categoryStat : this.categoryComponentStats) {
            builder.addComponentCategoryStats(MemoryUsageReportEvent.ClusterMemoryUsage.newBuilder().setLabel(((ComponentsSet.ComponentCategory)categoryStat.getCluster()).getLabel()).setStats(this.buildClusterObjectsStatistics(categoryStat)).putAllInstanceCountPerClassName(categoryStat.getTrackedFQNInstanceCounter()));
        }
        builder.setMetadata(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.newBuilder().setStatusCode(statusCode).setTotalHeapObjectsStats(this.buildMemoryTrafficStatistics(this.totalStats)).setFieldCacheCountPeak(this.maxFieldsCacheSize).setObjectQueueLengthPeak(this.maxObjectsQueueSize).setGarbageCollectedBefore2PassCount(this.enumeratedGarbageCollectedObjects).setCollectionTimeSeconds((double)executionTimeMs / 1000.0).setIsInPowerSaveMode(PowerSaveMode.isEnabled()).setUnsuccessfulFieldAccessesCount(this.unsuccessfulFieldAccessCounter).setCollectionStartTimestampSeconds((double)executionStartMs / 1000.0).setCollectionIteration((int)this.traverseSessionId));
        return builder.build();
    }

    void setTraverseSessionId(short traverseSessionId) {
        this.traverseSessionId = traverseSessionId;
    }

    @NotNull
    public HeapTraverseConfig getConfig() {
        return this.config;
    }

    @Nullable
    public ExtendedReportStatistics getExtendedReportStatistics() {
        return this.extendedReportStatistics;
    }

    public static abstract class ClusterObjectsStatistics<T extends ComponentsSet.Cluster> {
        @NotNull
        private final ObjectsStatisticsWithPlatformTracking retainedClusterStat = new ObjectsStatisticsWithPlatformTracking();
        @NotNull
        private final ObjectsStatisticsWithPlatformTracking ownedClusterStat = new ObjectsStatisticsWithPlatformTracking();
        @NotNull
        private final Object2IntMap<String> trackedFQNInstanceCounter = new Object2IntOpenHashMap();
        @NotNull
        private final T cluster;

        public ClusterObjectsStatistics(@NotNull T cluster) {
            this.cluster = cluster;
        }

        void addOwnedObject(long size, boolean isPlatformObject, boolean isRetainedByPlatform) {
            this.ownedClusterStat.addObject(size, isPlatformObject, isRetainedByPlatform);
        }

        void addRetainedObject(long size, boolean isPlatformObject, boolean isRetainedByPlatform) {
            this.retainedClusterStat.addObject(size, isPlatformObject, isRetainedByPlatform);
        }

        @NotNull
        public ObjectsStatisticsWithPlatformTracking getOwnedClusterStat() {
            return this.ownedClusterStat;
        }

        @NotNull
        public ObjectsStatisticsWithPlatformTracking getRetainedClusterStat() {
            return this.retainedClusterStat;
        }

        @NotNull
        public Object2IntMap<String> getTrackedFQNInstanceCounter() {
            return this.trackedFQNInstanceCounter;
        }

        void addTrackedFQNInstance(String name2) {
            this.trackedFQNInstanceCounter.put((Object)name2, this.trackedFQNInstanceCounter.getOrDefault((Object)name2, 0) + 1);
        }

        @NotNull
        public T getCluster() {
            return this.cluster;
        }

        public static class ObjectsStatisticsWithPlatformTracking {
            @NotNull
            private final ObjectsStatistics objectsStat = new ObjectsStatistics();
            @NotNull
            private final ObjectsStatistics platformObjectsSelfStats = new ObjectsStatistics();
            @NotNull
            private final ObjectsStatistics platformRetainedObjectsStats = new ObjectsStatistics();

            void addObject(long size, boolean isPlatformObject, boolean isRetainedByPlatform) {
                this.objectsStat.addObject(size);
                if (isPlatformObject) {
                    this.platformObjectsSelfStats.addObject(size);
                }
                if (isRetainedByPlatform) {
                    this.platformRetainedObjectsStats.addObject(size);
                }
            }

            public ObjectsStatistics getObjectsStatistics() {
                return this.objectsStat;
            }

            @NotNull
            public ObjectsStatistics getPlatformObjectsSelfStats() {
                return this.platformObjectsSelfStats;
            }

            @NotNull
            public ObjectsStatistics getPlatformRetainedObjectsStats() {
                return this.platformRetainedObjectsStats;
            }
        }
    }

    public static class ComponentClusterObjectsStatistics
    extends ClusterObjectsStatistics<ComponentsSet.Component> {
        private ComponentClusterObjectsStatistics(@NotNull ComponentsSet.Component component) {
            super(component);
        }
    }

    public static class CategoryClusterObjectsStatistics
    extends ClusterObjectsStatistics<ComponentsSet.ComponentCategory> {
        private CategoryClusterObjectsStatistics(@NotNull ComponentsSet.ComponentCategory category) {
            super(category);
        }
    }

    static class SharedClusterStatistics {
        @NotNull
        private final ClusterObjectsStatistics.ObjectsStatisticsWithPlatformTracking statistics;
        final long componentsMask;

        private SharedClusterStatistics(long componentsMask) {
            this.componentsMask = componentsMask;
            this.statistics = new ClusterObjectsStatistics.ObjectsStatisticsWithPlatformTracking();
        }

        @NotNull
        ClusterObjectsStatistics.ObjectsStatisticsWithPlatformTracking getStatistics() {
            return this.statistics;
        }

        @NotNull
        Collection<Integer> getComponentIds(@NotNull HeapTraverseConfig config) {
            ArrayList<Integer> components = new ArrayList<Integer>();
            HeapTraverseUtil.processMask(this.componentsMask, index -> components.add(config.getComponentsSet().getComponents().get((int)index).getId()));
            return components;
        }
    }

    static final class DisposedObjectsInfo {
        int numberOfDisposedObjectsWithAtLeast1mb = 0;
        int numberOfDisposedObjectsWithAtLeast10mb = 0;
        int numberOfDisposedObjectsWithAtLeast100mb = 0;

        DisposedObjectsInfo() {
        }
    }
}

