/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0003\u001f !B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter;", "", "maxEventsPerPeriod", "", "periodMs", "", "allowancePerSignature", "timeProvider", "Lkotlin/Function0;", "<init>", "(IJILkotlin/jvm/functions/Function0;)V", "signatureStats", "Ljava/util/HashMap;", "", "Lcom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter$SignatureStatistics;", "Lkotlin/collections/HashMap;", "globalCount", "isPowerOfTwo", "", "n", "queue", "Ljava/util/ArrayDeque;", "tryAcquireForSignature", "Lcom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter$Permit;", "sig", "updateTimeQueue", "currentTimeMs", "(J)Ljava/lang/Long;", "allow", "stats", "deny", "SignatureStatistics", "PermissionType", "Permit", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nExceptionRateLimiter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionRateLimiter.kt\ncom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,95:1\n382#2,7:96\n*S KotlinDebug\n*F\n+ 1 ExceptionRateLimiter.kt\ncom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter\n*L\n38#1:96,7\n*E\n"})
public final class ExceptionRateLimiter {
    private final int maxEventsPerPeriod;
    private final long periodMs;
    private final int allowancePerSignature;
    @NotNull
    private final Function0<Long> timeProvider;
    @NotNull
    private final HashMap<String, SignatureStatistics> signatureStats;
    private int globalCount;
    @NotNull
    private final ArrayDeque<Long> queue;

    public ExceptionRateLimiter(int maxEventsPerPeriod, long periodMs, int allowancePerSignature, @NotNull Function0<Long> timeProvider) {
        Intrinsics.checkNotNullParameter(timeProvider, (String)"timeProvider");
        this.maxEventsPerPeriod = maxEventsPerPeriod;
        this.periodMs = periodMs;
        this.allowancePerSignature = allowancePerSignature;
        this.timeProvider = timeProvider;
        this.signatureStats = new HashMap();
        this.queue = new ArrayDeque(this.maxEventsPerPeriod);
    }

    public /* synthetic */ ExceptionRateLimiter(int n, long l, int n2, Function0 function0, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 10;
        }
        if ((n3 & 2) != 0) {
            l = TimeUnit.MINUTES.toMillis(10L);
        }
        if ((n3 & 4) != 0) {
            n2 = 2;
        }
        if ((n3 & 8) != 0) {
            function0 = ExceptionRateLimiter::_init_$lambda$0;
        }
        this(n, l, n2, (Function0<Long>)function0);
    }

    private final boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Permit tryAcquireForSignature(@NotNull String sig) {
        Object object;
        void $this$getOrPut$iv22;
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        Map map2 = this.signatureStats;
        String key$iv = sig;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv22.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            SignatureStatistics answer$iv = new SignatureStatistics(0, 0);
            $this$getOrPut$iv22.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        SignatureStatistics stats = (SignatureStatistics)object;
        int $this$getOrPut$iv22 = this.globalCount;
        this.globalCount = $this$getOrPut$iv22 + 1;
        stats.setCount(stats.getCount() + 1);
        int count = stats.getCount();
        long currentTimeMs = ((Number)this.timeProvider.invoke()).longValue();
        Long evictedTimeMs = this.updateTimeQueue(currentTimeMs);
        if (count <= this.allowancePerSignature) {
            return this.allow(stats);
        }
        if (this.isPowerOfTwo(count)) {
            return this.allow(stats);
        }
        if (evictedTimeMs == null || currentTimeMs - evictedTimeMs > this.periodMs) {
            return this.allow(stats);
        }
        return this.deny(stats);
    }

    private final Long updateTimeQueue(long currentTimeMs) {
        this.queue.addLast(currentTimeMs);
        if (this.queue.size() <= this.maxEventsPerPeriod) {
            return null;
        }
        return this.queue.removeFirst();
    }

    private final Permit allow(SignatureStatistics stats) {
        int deniedSinceLastAllow = stats.getDeniedSinceLastAllow();
        stats.setDeniedSinceLastAllow(0);
        return new Permit(PermissionType.ALLOW, deniedSinceLastAllow, this.globalCount, stats.getCount());
    }

    private final Permit deny(SignatureStatistics stats) {
        stats.setDeniedSinceLastAllow(stats.getDeniedSinceLastAllow() + 1);
        int deniedSinceLastAllow = stats.getDeniedSinceLastAllow();
        return new Permit(PermissionType.DENY, deniedSinceLastAllow, this.globalCount, stats.getCount());
    }

    private static final long _init_$lambda$0() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public ExceptionRateLimiter() {
        this(0, 0L, 0, null, 15, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter$PermissionType;", "", "<init>", "(Ljava/lang/String;I)V", "DENY", "ALLOW", "intellij.android.core"})
    public static final class PermissionType
    extends Enum<PermissionType> {
        public static final /* enum */ PermissionType DENY = new PermissionType();
        public static final /* enum */ PermissionType ALLOW = new PermissionType();
        private static final /* synthetic */ PermissionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PermissionType[] values() {
            return (PermissionType[])$VALUES.clone();
        }

        public static PermissionType valueOf(String value2) {
            return Enum.valueOf(PermissionType.class, value2);
        }

        @NotNull
        public static EnumEntries<PermissionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = permissionTypeArray = new PermissionType[]{PermissionType.DENY, PermissionType.ALLOW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter$Permit;", "", "permissionType", "Lcom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter$PermissionType;", "deniedSinceLastAllow", "", "globalExceptionCounter", "localExceptionCounter", "<init>", "(Lcom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter$PermissionType;III)V", "getPermissionType", "()Lcom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter$PermissionType;", "getDeniedSinceLastAllow", "()I", "getGlobalExceptionCounter", "getLocalExceptionCounter", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.core"})
    public static final class Permit {
        @NotNull
        private final PermissionType permissionType;
        private final int deniedSinceLastAllow;
        private final int globalExceptionCounter;
        private final int localExceptionCounter;

        public Permit(@NotNull PermissionType permissionType, int deniedSinceLastAllow, int globalExceptionCounter, int localExceptionCounter) {
            Intrinsics.checkNotNullParameter((Object)((Object)permissionType), (String)"permissionType");
            this.permissionType = permissionType;
            this.deniedSinceLastAllow = deniedSinceLastAllow;
            this.globalExceptionCounter = globalExceptionCounter;
            this.localExceptionCounter = localExceptionCounter;
        }

        @NotNull
        public final PermissionType getPermissionType() {
            return this.permissionType;
        }

        public final int getDeniedSinceLastAllow() {
            return this.deniedSinceLastAllow;
        }

        public final int getGlobalExceptionCounter() {
            return this.globalExceptionCounter;
        }

        public final int getLocalExceptionCounter() {
            return this.localExceptionCounter;
        }

        @NotNull
        public final PermissionType component1() {
            return this.permissionType;
        }

        public final int component2() {
            return this.deniedSinceLastAllow;
        }

        public final int component3() {
            return this.globalExceptionCounter;
        }

        public final int component4() {
            return this.localExceptionCounter;
        }

        @NotNull
        public final Permit copy(@NotNull PermissionType permissionType, int deniedSinceLastAllow, int globalExceptionCounter, int localExceptionCounter) {
            Intrinsics.checkNotNullParameter((Object)((Object)permissionType), (String)"permissionType");
            return new Permit(permissionType, deniedSinceLastAllow, globalExceptionCounter, localExceptionCounter);
        }

        public static /* synthetic */ Permit copy$default(Permit permit, PermissionType permissionType, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                permissionType = permit.permissionType;
            }
            if ((n4 & 2) != 0) {
                n = permit.deniedSinceLastAllow;
            }
            if ((n4 & 4) != 0) {
                n2 = permit.globalExceptionCounter;
            }
            if ((n4 & 8) != 0) {
                n3 = permit.localExceptionCounter;
            }
            return permit.copy(permissionType, n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "Permit(permissionType=" + this.permissionType + ", deniedSinceLastAllow=" + this.deniedSinceLastAllow + ", globalExceptionCounter=" + this.globalExceptionCounter + ", localExceptionCounter=" + this.localExceptionCounter + ")";
        }

        public int hashCode() {
            int result2 = this.permissionType.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.deniedSinceLastAllow);
            result2 = result2 * 31 + Integer.hashCode(this.globalExceptionCounter);
            result2 = result2 * 31 + Integer.hashCode(this.localExceptionCounter);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Permit)) {
                return false;
            }
            Permit permit = (Permit)other;
            if (this.permissionType != permit.permissionType) {
                return false;
            }
            if (this.deniedSinceLastAllow != permit.deniedSinceLastAllow) {
                return false;
            }
            if (this.globalExceptionCounter != permit.globalExceptionCounter) {
                return false;
            }
            return this.localExceptionCounter == permit.localExceptionCounter;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionRateLimiter$SignatureStatistics;", "", "count", "", "deniedSinceLastAllow", "<init>", "(II)V", "getCount", "()I", "setCount", "(I)V", "getDeniedSinceLastAllow", "setDeniedSinceLastAllow", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.core"})
    public static final class SignatureStatistics {
        private int count;
        private int deniedSinceLastAllow;

        public SignatureStatistics(int count, int deniedSinceLastAllow) {
            this.count = count;
            this.deniedSinceLastAllow = deniedSinceLastAllow;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final int getDeniedSinceLastAllow() {
            return this.deniedSinceLastAllow;
        }

        public final void setDeniedSinceLastAllow(int n) {
            this.deniedSinceLastAllow = n;
        }

        public final int component1() {
            return this.count;
        }

        public final int component2() {
            return this.deniedSinceLastAllow;
        }

        @NotNull
        public final SignatureStatistics copy(int count, int deniedSinceLastAllow) {
            return new SignatureStatistics(count, deniedSinceLastAllow);
        }

        public static /* synthetic */ SignatureStatistics copy$default(SignatureStatistics signatureStatistics, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = signatureStatistics.count;
            }
            if ((n3 & 2) != 0) {
                n2 = signatureStatistics.deniedSinceLastAllow;
            }
            return signatureStatistics.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "SignatureStatistics(count=" + this.count + ", deniedSinceLastAllow=" + this.deniedSinceLastAllow + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.count);
            result2 = result2 * 31 + Integer.hashCode(this.deniedSinceLastAllow);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SignatureStatistics)) {
                return false;
            }
            SignatureStatistics signatureStatistics = (SignatureStatistics)other;
            if (this.count != signatureStatistics.count) {
                return false;
            }
            return this.deniedSinceLastAllow == signatureStatistics.deniedSinceLastAllow;
        }
    }
}

