/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.AndroidStudioSystemHealthMonitor;
import com.android.tools.idea.diagnostics.StudioCrashDetails;
import com.android.tools.idea.diagnostics.StudioCrashDetection;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.SystemHealthEvent;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 82\u00020\u0001:\u000545678B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u001cH\u0002J\u0018\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J\u0010\u0010\b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020+H\u0002J\b\u00100\u001a\u00020\u001cH\u0016J\u0010\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u000203H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR#\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0015\u0010\u0017\u001a\u00060\u0018R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00069"}, d2={"Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "freezeCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "deadlockStatus", "Lcom/google/wireless/android/sdk/stats/SystemHealthEvent$DeadlockStatus;", "freezeHeartbeat", "Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$FreezeHeartbeat;", "clock", "Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$Clock;", "getClock", "()Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$Clock;", "setClock", "(Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$Clock;)V", "dedicatedThreadExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getDedicatedThreadExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "setDedicatedThreadExecutor", "(Ljava/util/concurrent/ScheduledExecutorService;)V", "triggers", "Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$Triggers;", "getTriggers", "()Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$Triggers;", "start", "", "setUpMemoryTelemetry", "logLowMemoryWarning", "type", "Lcom/intellij/openapi/util/LowMemoryWatcher$LowMemoryWatcherType;", "getLowMemoryWarningType", "Lcom/google/wireless/android/sdk/stats/SystemHealthEvent$LowMemoryWarningType;", "setUpExitTelemetry", "getSignalNumber", "", "signalName", "", "setUpFreezeTelemetry", "freezeStarted", "durationMs", "", "freezeStartTime", "freezeFinished", "updateDeadlockStatus", "freezeTimeMs", "dispose", "logSystemHealthEvent", "systemHealthEvent", "Lcom/google/wireless/android/sdk/stats/SystemHealthEvent$Builder;", "Triggers", "Clock", "FreezeHeartbeatDelay", "FreezeHeartbeat", "Companion", "intellij.android.core"})
public final class SystemHealthDataCollection
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicInteger freezeCounter = new AtomicInteger(0);
    @NotNull
    private SystemHealthEvent.DeadlockStatus deadlockStatus = SystemHealthEvent.DeadlockStatus.UNKNOWN;
    @NotNull
    private final FreezeHeartbeat freezeHeartbeat = new FreezeHeartbeat(arg_0 -> SystemHealthDataCollection.freezeHeartbeat$lambda$0(this, arg_0));
    @VisibleForTesting
    @NotNull
    private Clock clock = SystemHealthDataCollection::clock$lambda$1;
    @VisibleForTesting
    @NotNull
    private ScheduledExecutorService dedicatedThreadExecutor;
    @NotNull
    private final Triggers triggers;
    @NotNull
    private static final List<FreezeHeartbeatDelay> HEARTBEAT_DELAYS;
    public static final int INVALID_SIGNAL = -1;
    public static final int UNKNOWN_SIGNAL = -2;

    public SystemHealthDataCollection() {
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"SystemHealthDataCollection", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"createBoundedScheduledExecutorService(...)");
        this.dedicatedThreadExecutor = scheduledExecutorService;
        this.triggers = new Triggers();
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    public final void setClock(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"<set-?>");
        this.clock = clock;
    }

    @NotNull
    public final ScheduledExecutorService getDedicatedThreadExecutor() {
        return this.dedicatedThreadExecutor;
    }

    public final void setDedicatedThreadExecutor(@NotNull ScheduledExecutorService scheduledExecutorService) {
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"<set-?>");
        this.dedicatedThreadExecutor = scheduledExecutorService;
    }

    @NotNull
    public final Triggers getTriggers() {
        return this.triggers;
    }

    public final void start() {
        this.setUpFreezeTelemetry();
        this.setUpExitTelemetry();
        this.setUpMemoryTelemetry();
    }

    private final void setUpMemoryTelemetry() {
        LowMemoryWatcher.register(this.triggers::gcThresholdMet, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ALWAYS, (Disposable)this);
        LowMemoryWatcher.register(this.triggers::gcThresholdMetAfterCollection, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC, (Disposable)this);
        AndroidStudioSystemHealthMonitor.getInstance().registerOutOfMemoryErrorListener(() -> SystemHealthDataCollection.setUpMemoryTelemetry$lambda$2(this), this);
    }

    private final void logLowMemoryWarning(LowMemoryWatcher.LowMemoryWatcherType type) {
        SystemHealthEvent.Builder builder = SystemHealthEvent.newBuilder().setEventType(SystemHealthEvent.SystemHealthEventType.MEMORY_LOW_MEMORY_WARNING).setMemory(SystemHealthEvent.Memory.newBuilder().setLowMemoryWarningType(this.getLowMemoryWarningType(type)));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setMemory(...)");
        this.logSystemHealthEvent(builder);
    }

    private final SystemHealthEvent.LowMemoryWarningType getLowMemoryWarningType(LowMemoryWatcher.LowMemoryWatcherType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> SystemHealthEvent.LowMemoryWarningType.BEFORE_GC;
            case 2 -> SystemHealthEvent.LowMemoryWarningType.AFTER_GC;
            default -> SystemHealthEvent.LowMemoryWarningType.UNKNOWN_TYPE;
        };
    }

    private final void setUpExitTelemetry() {
        Application application = ApplicationManager.getApplication();
        List<StudioCrashDetails> crashDetails = StudioCrashDetection.reapCrashDescriptions();
        for (StudioCrashDetails details : crashDetails) {
            if (details.isJvmCrash()) {
                String string = details.getSessionID();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSessionID(...)");
                String string2 = details.getErrorSignal();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getErrorSignal(...)");
                this.triggers.jvmCrashDetected(string, string2);
                continue;
            }
            String string = details.getSessionID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSessionID(...)");
            this.triggers.nongracefulExitDetected(string);
        }
        MessageBusConnection messageBusConnection = application.getMessageBus().connect((Disposable)this);
        Topic topic = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new AppLifecycleListener(this){
            final /* synthetic */ SystemHealthDataCollection this$0;
            {
                this.this$0 = $receiver;
            }

            public void appClosing() {
                this.this$0.getTriggers().gracefulExitDetected(UsageTracker.getSessionId());
            }
        });
    }

    private final int getSignalNumber(String signalName) {
        Matcher matcher = Pattern.compile("^SIG([A-Z]+).*").matcher(signalName);
        if (matcher.matches()) {
            String extractedSignalName = matcher.group(1);
            Map signalMap = SystemHealthDataCollection.Companion.createSignalMap();
            Integer n = (Integer)signalMap.get(extractedSignalName);
            return n != null ? n : -2;
        }
        return -1;
    }

    private final void setUpFreezeTelemetry() {
        Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect((Disposable)this).subscribe(IdePerformanceListener.TOPIC, (Object)new IdePerformanceListener(this){
            final /* synthetic */ SystemHealthDataCollection this$0;
            {
                this.this$0 = $receiver;
            }

            public void uiFreezeStarted(Path reportDir) {
                Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
                this.this$0.getTriggers().uiFreezeStarted();
            }

            public void uiFreezeFinished(long durationMs, Path reportDir) {
                this.this$0.getTriggers().uiFreezeFinished(durationMs);
            }

            public void dumpedThreads(Path toFile, ThreadDump dump) {
                super.dumpedThreads(toFile, dump);
            }
        });
    }

    private final void freezeStarted(long durationMs, long freezeStartTime) {
        int freezeID = this.freezeCounter.incrementAndGet();
        this.deadlockStatus = SystemHealthEvent.DeadlockStatus.UNKNOWN;
        this.updateDeadlockStatus(durationMs);
        SystemHealthEvent.Builder builder = SystemHealthEvent.newBuilder().setEventType(SystemHealthEvent.SystemHealthEventType.UI_FREEZE_STARTED).setUiFreeze(SystemHealthEvent.UIFreeze.newBuilder().setFreezeId((long)freezeID).setDeadlock(this.deadlockStatus).setDurationMs(durationMs));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setUiFreeze(...)");
        this.logSystemHealthEvent(builder);
        this.freezeHeartbeat.start(freezeStartTime);
    }

    private final void freezeHeartbeat(long durationMs) {
        this.updateDeadlockStatus(durationMs);
        SystemHealthEvent.Builder builder = SystemHealthEvent.newBuilder().setEventType(SystemHealthEvent.SystemHealthEventType.UI_FREEZE_UPDATE).setUiFreeze(SystemHealthEvent.UIFreeze.newBuilder().setFreezeId((long)this.freezeCounter.get()).setDeadlock(this.deadlockStatus).setDurationMs(durationMs));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setUiFreeze(...)");
        this.logSystemHealthEvent(builder);
    }

    private final void freezeFinished(long durationMs) {
        this.deadlockStatus = SystemHealthEvent.DeadlockStatus.NO_DEADLOCK;
        this.freezeHeartbeat.stop();
        SystemHealthEvent.Builder builder = SystemHealthEvent.newBuilder().setEventType(SystemHealthEvent.SystemHealthEventType.UI_FREEZE_FINISHED).setUiFreeze(SystemHealthEvent.UIFreeze.newBuilder().setFreezeId((long)this.freezeCounter.get()).setDeadlock(this.deadlockStatus).setDurationMs(durationMs));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setUiFreeze(...)");
        this.logSystemHealthEvent(builder);
    }

    private final void updateDeadlockStatus(long freezeTimeMs) {
        ThreadMXBean bean;
        long[] threadIds;
        if (this.deadlockStatus == SystemHealthEvent.DeadlockStatus.CONFIRMED) {
            return;
        }
        if (this.deadlockStatus == SystemHealthEvent.DeadlockStatus.UNKNOWN && freezeTimeMs >= TimeUnit.SECONDS.toMillis(90L)) {
            this.deadlockStatus = SystemHealthEvent.DeadlockStatus.SUSPECTED;
        }
        if ((threadIds = (bean = ManagementFactory.getThreadMXBean()).findMonitorDeadlockedThreads()) != null && !(threadIds.length == 0)) {
            long edtId = EDT.getEventDispatchThread().getId();
            boolean edtBlocked = Arrays.stream(threadIds).anyMatch(arg_0 -> SystemHealthDataCollection.updateDeadlockStatus$lambda$3(edtId, arg_0));
            this.deadlockStatus = edtBlocked ? SystemHealthEvent.DeadlockStatus.CONFIRMED : SystemHealthEvent.DeadlockStatus.SUSPECTED;
        }
    }

    public void dispose() {
    }

    private final void logSystemHealthEvent(SystemHealthEvent.Builder systemHealthEvent) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.SYSTEM_HEALTH_EVENT).setSystemHealthEvent(systemHealthEvent);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setSystemHealthEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    private static final void freezeHeartbeat$lambda$0(SystemHealthDataCollection this$0, long durationMs) {
        this$0.freezeHeartbeat(durationMs);
    }

    private static final long clock$lambda$1() {
        return System.nanoTime() / (long)1000000;
    }

    private static final void setUpMemoryTelemetry$lambda$2(SystemHealthDataCollection this$0) {
        this$0.triggers.outOfMemoryErrorRaised();
    }

    private static final boolean updateDeadlockStatus$lambda$3(long $edtId, long tid) {
        return tid == $edtId;
    }

    @NotNull
    public static final SystemHealthDataCollection getInstance() {
        return Companion.getInstance();
    }

    static {
        Object[] objectArray = new FreezeHeartbeatDelay[5];
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        Duration duration2 = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        objectArray[0] = new FreezeHeartbeatDelay(duration, duration2);
        Duration duration3 = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(...)");
        Duration duration4 = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(...)");
        objectArray[1] = new FreezeHeartbeatDelay(duration3, duration4);
        Duration duration5 = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration5, (String)"ofMinutes(...)");
        Duration duration6 = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration6, (String)"ofMinutes(...)");
        objectArray[2] = new FreezeHeartbeatDelay(duration5, duration6);
        Duration duration7 = Duration.ofMinutes(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration7, (String)"ofMinutes(...)");
        Duration duration8 = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration8, (String)"ofMinutes(...)");
        objectArray[3] = new FreezeHeartbeatDelay(duration7, duration8);
        Duration duration9 = Duration.ofHours(6L);
        Intrinsics.checkNotNullExpressionValue((Object)duration9, (String)"ofHours(...)");
        Duration duration10 = Duration.ofMinutes(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration10, (String)"ofMinutes(...)");
        objectArray[4] = new FreezeHeartbeatDelay(duration9, duration10);
        HEARTBEAT_DELAYS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$Clock;", "", "milliTime", "", "intellij.android.core"})
    public static interface Clock {
        public long milliTime();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$Companion;", "", "<init>", "()V", "HEARTBEAT_DELAYS", "", "Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$FreezeHeartbeatDelay;", "INVALID_SIGNAL", "", "UNKNOWN_SIGNAL", "instance", "Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection;", "getInstance$annotations", "getInstance", "()Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection;", "createSignalMap", "", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SystemHealthDataCollection getInstance() {
            Object object = ApplicationManager.getApplication().getService(SystemHealthDataCollection.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (SystemHealthDataCollection)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        private final Map<String, Integer> createSignalMap() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"HUP", (Object)1), TuplesKt.to((Object)"INT", (Object)2), TuplesKt.to((Object)"QUIT", (Object)3), TuplesKt.to((Object)"ILL", (Object)4), TuplesKt.to((Object)"TRAP", (Object)5), TuplesKt.to((Object)"ABRT", (Object)6), TuplesKt.to((Object)"IOT", (Object)7), TuplesKt.to((Object)"BUS", (Object)8), TuplesKt.to((Object)"KILL", (Object)9), TuplesKt.to((Object)"USR1", (Object)10), TuplesKt.to((Object)"SEGV", (Object)11), TuplesKt.to((Object)"USR2", (Object)12), TuplesKt.to((Object)"PIPE", (Object)13), TuplesKt.to((Object)"ALRM", (Object)14), TuplesKt.to((Object)"TERM", (Object)15), TuplesKt.to((Object)"STKFLT", (Object)16), TuplesKt.to((Object)"CHLD", (Object)17), TuplesKt.to((Object)"CONT", (Object)18), TuplesKt.to((Object)"STOP", (Object)19), TuplesKt.to((Object)"TSTP", (Object)20), TuplesKt.to((Object)"TTIN", (Object)21), TuplesKt.to((Object)"TTOU", (Object)22), TuplesKt.to((Object)"URG", (Object)23), TuplesKt.to((Object)"XCPU", (Object)24), TuplesKt.to((Object)"XFSZ", (Object)25), TuplesKt.to((Object)"VTALRM", (Object)26), TuplesKt.to((Object)"PROF", (Object)27), TuplesKt.to((Object)"WINCH", (Object)28), TuplesKt.to((Object)"IO", (Object)29), TuplesKt.to((Object)"POLL", (Object)29), TuplesKt.to((Object)"PWR", (Object)30), TuplesKt.to((Object)"SYS", (Object)31), TuplesKt.to((Object)"UNUSED", (Object)31)};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0004J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0002J\u0006\u0010\u0015\u001a\u00020\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$FreezeHeartbeat;", "", "callback", "Ljava/util/function/Consumer;", "", "<init>", "(Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection;Ljava/util/function/Consumer;)V", "isRunning", "", "freezeStart", "future", "Ljava/util/concurrent/ScheduledFuture;", "delayIterator", "", "Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$FreezeHeartbeatDelay;", "currentDelay", "start", "", "scheduleNextHeartbeat", "freezeHeartbeat", "advanceDelayIterator", "stop", "intellij.android.core"})
    private final class FreezeHeartbeat {
        @NotNull
        private final Consumer<Long> callback;
        private boolean isRunning;
        private long freezeStart;
        @Nullable
        private ScheduledFuture<?> future;
        @NotNull
        private Iterator<FreezeHeartbeatDelay> delayIterator;
        @Nullable
        private FreezeHeartbeatDelay currentDelay;

        public FreezeHeartbeat(Consumer<Long> callback2) {
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            this.callback = callback2;
            this.delayIterator = HEARTBEAT_DELAYS.iterator();
        }

        public final void start(long freezeStart) {
            if (this.isRunning) {
                this.stop();
            }
            this.freezeStart = freezeStart;
            this.isRunning = true;
            this.currentDelay = null;
            this.delayIterator = HEARTBEAT_DELAYS.iterator();
            this.scheduleNextHeartbeat();
        }

        private final void scheduleNextHeartbeat() {
            block0: {
                FreezeHeartbeatDelay freezeHeartbeatDelay = this.advanceDelayIterator();
                if (freezeHeartbeatDelay == null) break block0;
                FreezeHeartbeatDelay freezeHeartbeatDelay2 = freezeHeartbeatDelay;
                SystemHealthDataCollection systemHealthDataCollection = SystemHealthDataCollection.this;
                FreezeHeartbeatDelay heartbeatDelay = freezeHeartbeatDelay2;
                boolean bl = false;
                this.future = systemHealthDataCollection.getDedicatedThreadExecutor().schedule(() -> FreezeHeartbeat.scheduleNextHeartbeat$lambda$1$lambda$0(this), heartbeatDelay.interval().toMillis(), TimeUnit.MILLISECONDS);
            }
        }

        private final void freezeHeartbeat() {
            this.future = null;
            if (!this.isRunning) {
                return;
            }
            this.callback.accept(SystemHealthDataCollection.this.getClock().milliTime() - this.freezeStart);
            this.scheduleNextHeartbeat();
        }

        private final FreezeHeartbeatDelay advanceDelayIterator() {
            if (this.currentDelay == null) {
                if (this.delayIterator.hasNext()) {
                    this.currentDelay = this.delayIterator.next();
                } else {
                    return null;
                }
            }
            long currentFreezeTimeMs = SystemHealthDataCollection.this.getClock().milliTime() - this.freezeStart;
            while (this.currentDelay != null) {
                FreezeHeartbeatDelay freezeHeartbeatDelay = this.currentDelay;
                Intrinsics.checkNotNull((Object)freezeHeartbeatDelay);
                if (currentFreezeTimeMs < freezeHeartbeatDelay.duration().toMillis()) break;
                if (!this.delayIterator.hasNext()) {
                    this.currentDelay = null;
                    break;
                }
                this.currentDelay = this.delayIterator.next();
            }
            return this.currentDelay;
        }

        public final void stop() {
            if (!this.isRunning) {
                return;
            }
            if (this.future != null) {
                ScheduledFuture<?> scheduledFuture = this.future;
                Intrinsics.checkNotNull(scheduledFuture);
                scheduledFuture.cancel(false);
                this.future = null;
            }
            this.isRunning = false;
        }

        private static final void scheduleNextHeartbeat$lambda$1$lambda$0(FreezeHeartbeat this$0) {
            this$0.freezeHeartbeat();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$FreezeHeartbeatDelay;", "Ljava/lang/Record;", "duration", "Ljava/time/Duration;", "interval", "<init>", "(Ljava/time/Duration;Ljava/time/Duration;)V", "()Ljava/time/Duration;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.core"})
    private static final class FreezeHeartbeatDelay
    extends Record {
        @NotNull
        private final Duration duration;
        @NotNull
        private final Duration interval;

        public FreezeHeartbeatDelay(@NotNull Duration duration, @NotNull Duration interval) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            this.duration = duration;
            this.interval = interval;
        }

        @NotNull
        public final Duration duration() {
            return this.duration;
        }

        @NotNull
        public final Duration interval() {
            return this.interval;
        }

        @NotNull
        public final Duration component1() {
            return this.duration;
        }

        @NotNull
        public final Duration component2() {
            return this.interval;
        }

        @NotNull
        public final FreezeHeartbeatDelay copy(@NotNull Duration duration, @NotNull Duration interval) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            return new FreezeHeartbeatDelay(duration, interval);
        }

        public static /* synthetic */ FreezeHeartbeatDelay copy$default(FreezeHeartbeatDelay freezeHeartbeatDelay, Duration duration, Duration duration2, int n, Object object) {
            if ((n & 1) != 0) {
                duration = freezeHeartbeatDelay.duration;
            }
            if ((n & 2) != 0) {
                duration2 = freezeHeartbeatDelay.interval;
            }
            return freezeHeartbeatDelay.copy(duration, duration2);
        }

        @Override
        @NotNull
        public String toString() {
            return "FreezeHeartbeatDelay(duration=" + this.duration + ", interval=" + this.interval + ")";
        }

        @Override
        public int hashCode() {
            int result2 = this.duration.hashCode();
            result2 = result2 * 31 + this.interval.hashCode();
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FreezeHeartbeatDelay)) {
                return false;
            }
            FreezeHeartbeatDelay freezeHeartbeatDelay = (FreezeHeartbeatDelay)other;
            if (!Intrinsics.areEqual((Object)this.duration, (Object)freezeHeartbeatDelay.duration)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.interval, (Object)freezeHeartbeatDelay.interval);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection$Triggers;", "", "<init>", "(Lcom/android/tools/idea/diagnostics/SystemHealthDataCollection;)V", "gcEventsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "gcThresholdMet", "", "gcThresholdMetAfterCollection", "outOfMemoryErrorRaised", "jvmCrashDetected", "sessionID", "", "signalName", "gracefulExitDetected", "sessionId", "nongracefulExitDetected", "uiFreezeStarted", "uiFreezeFinished", "durationMs", "", "intellij.android.core"})
    public final class Triggers {
        @NotNull
        private final AtomicInteger gcEventsCounter = new AtomicInteger(0);

        public final void gcThresholdMet() {
            if (this.gcEventsCounter.incrementAndGet() <= 2000) {
                SystemHealthDataCollection.this.logLowMemoryWarning(LowMemoryWatcher.LowMemoryWatcherType.ALWAYS);
            }
        }

        public final void gcThresholdMetAfterCollection() {
            if (this.gcEventsCounter.incrementAndGet() <= 2000) {
                SystemHealthDataCollection.this.logLowMemoryWarning(LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC);
            }
        }

        public final void outOfMemoryErrorRaised() {
            SystemHealthEvent.Builder builder = SystemHealthEvent.newBuilder().setEventType(SystemHealthEvent.SystemHealthEventType.MEMORY_OOM_ERROR);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventType(...)");
            SystemHealthDataCollection.this.logSystemHealthEvent(builder);
        }

        public final void jvmCrashDetected(@NotNull String sessionID, @NotNull String signalName) {
            Intrinsics.checkNotNullParameter((Object)sessionID, (String)"sessionID");
            Intrinsics.checkNotNullParameter((Object)signalName, (String)"signalName");
            SystemHealthEvent.Builder builder = SystemHealthEvent.newBuilder().setEventType(SystemHealthEvent.SystemHealthEventType.EXIT_JVM_CRASH).setExit(SystemHealthEvent.Exit.newBuilder().setStudioSessionId(sessionID).setJvmSignalNumber(SystemHealthDataCollection.this.getSignalNumber(signalName)));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setExit(...)");
            SystemHealthDataCollection.this.logSystemHealthEvent(builder);
        }

        public final void gracefulExitDetected(@NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            SystemHealthEvent.Builder builder = SystemHealthEvent.newBuilder().setEventType(SystemHealthEvent.SystemHealthEventType.EXIT_GRACEFUL).setExit(SystemHealthEvent.Exit.newBuilder().setStudioSessionId(sessionId));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setExit(...)");
            SystemHealthDataCollection.this.logSystemHealthEvent(builder);
        }

        public final void nongracefulExitDetected(@NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            SystemHealthEvent.Builder builder = SystemHealthEvent.newBuilder().setEventType(SystemHealthEvent.SystemHealthEventType.EXIT_NONGRACEFUL).setExit(SystemHealthEvent.Exit.newBuilder().setStudioSessionId(sessionId));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setExit(...)");
            SystemHealthDataCollection.this.logSystemHealthEvent(builder);
        }

        public final void uiFreezeStarted() {
            int unresponsiveInterval = PerformanceWatcher.Companion.getInstance().getUnresponsiveInterval();
            long freezeStartTime = SystemHealthDataCollection.this.getClock().milliTime() - (long)unresponsiveInterval;
            SystemHealthDataCollection.this.getDedicatedThreadExecutor().submit(() -> Triggers.uiFreezeStarted$lambda$0(SystemHealthDataCollection.this, unresponsiveInterval, freezeStartTime));
        }

        public final void uiFreezeFinished(long durationMs) {
            SystemHealthDataCollection.this.getDedicatedThreadExecutor().submit(() -> Triggers.uiFreezeFinished$lambda$1(SystemHealthDataCollection.this, durationMs));
        }

        private static final void uiFreezeStarted$lambda$0(SystemHealthDataCollection this$0, int $unresponsiveInterval, long $freezeStartTime) {
            this$0.freezeStarted($unresponsiveInterval, $freezeStartTime);
        }

        private static final void uiFreezeFinished$lambda$1(SystemHealthDataCollection this$0, long $durationMs) {
            this$0.freezeFinished($durationMs);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LowMemoryWatcher.LowMemoryWatcherType.values().length];
            try {
                nArray[LowMemoryWatcher.LowMemoryWatcherType.ALWAYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

