/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.JVMReportParser;
import com.android.tools.idea.diagnostics.SanitizedBuilder;
import com.android.tools.idea.diagnostics.SectionType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/JVMReportSanitizer;", "", "<init>", "()V", "sanitize", "", "report", "Ljava/io/File;", "sanitizeHeader", "", "parser", "Lcom/android/tools/idea/diagnostics/JVMReportParser;", "builder", "Lcom/android/tools/idea/diagnostics/SanitizedBuilder;", "sanitizeSummary", "sanitizeThread", "sanitizeProcess", "sanitizeSystem", "sanitizeUnknown", "skipSubsection", "line", "intellij.android.core"})
public final class JVMReportSanitizer {
    @NotNull
    public static final JVMReportSanitizer INSTANCE = new JVMReportSanitizer();

    private JVMReportSanitizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final String sanitize(@NotNull File report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        SanitizedBuilder builder = new SanitizedBuilder();
        Closeable closeable = new BufferedReader(new FileReader(report));
        Throwable throwable = null;
        try {
            BufferedReader reader2 = (BufferedReader)closeable;
            boolean bl = false;
            JVMReportParser parser = new JVMReportParser(reader2);
            block15: while (!parser.isEOF()) {
                parser.goToNextSection();
                SectionType sectionType = parser.getCurrentSectionType();
                switch (WhenMappings.$EnumSwitchMapping$0[sectionType.ordinal()]) {
                    case 1: {
                        throw new IllegalStateException("at beginning of file, need to call `goToNextSection()` first");
                    }
                    case 2: {
                        INSTANCE.sanitizeHeader(parser, builder);
                        continue block15;
                    }
                    case 3: {
                        INSTANCE.sanitizeSummary(parser, builder);
                        continue block15;
                    }
                    case 4: {
                        INSTANCE.sanitizeThread(parser, builder);
                        continue block15;
                    }
                    case 5: {
                        INSTANCE.sanitizeProcess(parser, builder);
                        continue block15;
                    }
                    case 6: {
                        INSTANCE.sanitizeSystem(parser, builder);
                        continue block15;
                    }
                    case 7: {
                        INSTANCE.sanitizeUnknown(parser, builder);
                        continue block15;
                    }
                    case 8: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return builder.toString();
    }

    private final void sanitizeHeader(JVMReportParser parser, SanitizedBuilder builder) {
        while (!parser.isEndOfSection()) {
            String line = parser.readNextSectionLine();
            if (line == null) {
                return;
            }
            builder.sanitizeUntilEOL(line);
        }
    }

    private final void sanitizeSummary(JVMReportParser parser, SanitizedBuilder builder) {
        while (!parser.isEndOfSection()) {
            String line = parser.readNextSectionLine();
            if (line == null) {
                return;
            }
            builder.sanitizeUntilEOL(line);
        }
    }

    private final void sanitizeThread(JVMReportParser parser, SanitizedBuilder builder) {
        while (!parser.isEndOfSection()) {
            String line = parser.readNextSectionLine();
            if (line == null) {
                return;
            }
            builder.sanitizeUntilEOL(line);
        }
    }

    private final void sanitizeProcess(JVMReportParser parser, SanitizedBuilder builder) {
        while (!parser.isEndOfSection()) {
            String line = parser.readNextSectionLine();
            if (line == null) {
                return;
            }
            if (StringsKt.startsWith$default((String)line, (String)"Heap Regions: ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"Environment Variables:", (boolean)false, (int)2, null)) {
                this.skipSubsection(line, parser, builder);
                continue;
            }
            builder.sanitizeUntilEOL(line);
        }
    }

    private final void sanitizeSystem(JVMReportParser parser, SanitizedBuilder builder) {
        while (!parser.isEndOfSection()) {
            String line = parser.readNextSectionLine();
            if (line == null) {
                return;
            }
            builder.sanitizeUntilEOL(line);
        }
    }

    private final void sanitizeUnknown(JVMReportParser parser, SanitizedBuilder builder) {
        while (!parser.isEndOfSection()) {
            String line = parser.readNextSectionLine();
            if (line == null) {
                return;
            }
            builder.sanitizeUntilEOL(line);
        }
    }

    private final void skipSubsection(String line, JVMReportParser parser, SanitizedBuilder builder) {
        int lineCount = 0;
        while (!parser.isEndOfSubsection()) {
            ++lineCount;
            parser.readNextSectionLine();
        }
        builder.sanitizeUntilEOL(line + "\n<Skipped " + lineCount + " lines>");
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SectionType.values().length];
            try {
                nArray[SectionType.BeginningOfFile.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.Header.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.Summary.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.Thread.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.Process.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.System.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.Unknown.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.EOF.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

