/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.SectionState;
import com.android.tools.idea.diagnostics.SectionType;
import java.io.BufferedReader;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\tJ\b\u0010\r\u001a\u00020\tH\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/diagnostics/JVMReportParser;", "", "reader", "Ljava/io/BufferedReader;", "<init>", "(Ljava/io/BufferedReader;)V", "bufferedLine", "", "currentSectionType", "Lcom/android/tools/idea/diagnostics/SectionType;", "currentSectionState", "Lcom/android/tools/idea/diagnostics/SectionState;", "getCurrentSectionType", "extractSectionTypeFromCurrentLine", "goToNextSection", "", "updateSectionInfoToNewSection", "updateSectionInfoToEOF", "readNextSectionLine", "isEOF", "", "isEndOfSection", "isEndOfSubsection", "intellij.android.core"})
public final class JVMReportParser {
    @NotNull
    private final BufferedReader reader;
    @Nullable
    private String bufferedLine;
    @NotNull
    private SectionType currentSectionType;
    @NotNull
    private SectionState currentSectionState;

    public JVMReportParser(@NotNull BufferedReader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        this.reader = reader2;
        this.currentSectionType = SectionType.BeginningOfFile;
        this.currentSectionState = SectionState.BeginningOfFile;
    }

    @NotNull
    public final SectionType getCurrentSectionType() {
        if (this.currentSectionType == SectionType.BeginningOfFile) {
            throw new IllegalStateException("Not started reading the file yet");
        }
        return this.currentSectionType;
    }

    private final SectionType extractSectionTypeFromCurrentLine() {
        String line = this.bufferedLine;
        if (line == null) {
            return SectionType.EOF;
        }
        if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null)) {
            return SectionType.Header;
        }
        String string = StringsKt.replace$default((String)StringsKt.replace$default((String)line, (String)"-", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return switch (string) {
            case "SUMMARY" -> SectionType.Summary;
            case "THREAD" -> SectionType.Thread;
            case "PROCESS" -> SectionType.Process;
            case "SYSTEM" -> SectionType.System;
            default -> SectionType.Unknown;
        };
    }

    public final void goToNextSection() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentSectionState.ordinal()]) {
            case 1: 
            case 2: {
                while (!this.isEndOfSection()) {
                    this.readNextSectionLine();
                }
                this.updateSectionInfoToNewSection();
                break;
            }
            case 3: {
                this.updateSectionInfoToNewSection();
                break;
            }
            case 4: {
                throw new IllegalStateException("Reached EOF, cannot proceed further");
            }
            case 5: {
                String line;
                this.bufferedLine = line = this.reader.readLine();
                if (line == null) {
                    this.updateSectionInfoToEOF();
                    return;
                }
                this.updateSectionInfoToNewSection();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void updateSectionInfoToNewSection() {
        this.currentSectionState = this.isEOF() ? SectionState.EOF : SectionState.Start;
        this.currentSectionType = this.extractSectionTypeFromCurrentLine();
    }

    private final void updateSectionInfoToEOF() {
        this.currentSectionState = SectionState.EOF;
        this.currentSectionType = SectionType.EOF;
    }

    @Nullable
    public final String readNextSectionLine() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentSectionState.ordinal()]) {
            case 2: {
                String line = this.bufferedLine;
                if (line == null) {
                    this.updateSectionInfoToEOF();
                    return null;
                }
                this.currentSectionState = SectionState.SectionBody;
                this.bufferedLine = this.reader.readLine();
                return line;
            }
            case 1: {
                String line = this.bufferedLine;
                if (line == null) {
                    this.updateSectionInfoToEOF();
                    return null;
                }
                if (StringsKt.startsWith$default((String)line, (String)"-----", (boolean)false, (int)2, null)) {
                    this.currentSectionState = SectionState.EndOfSection;
                    return null;
                }
                this.bufferedLine = this.reader.readLine();
                return line;
            }
            case 3: {
                return null;
            }
            case 4: {
                throw new IllegalStateException("Reached EOF, cannot proceed further");
            }
            case 5: {
                throw new IllegalStateException("Not started reading the file yet");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final boolean isEOF() {
        return this.currentSectionState == SectionState.EOF;
    }

    public final boolean isEndOfSection() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.currentSectionState.ordinal()]) {
            case 3, 4 -> true;
            case 1, 2 -> false;
            case 5 -> throw new IllegalStateException("Not started reading the file yet");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean isEndOfSubsection() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentSectionState.ordinal()]) {
            case 3: 
            case 4: {
                return true;
            }
            case 1: 
            case 2: {
                CharSequence charSequence = this.bufferedLine;
                return charSequence == null || charSequence.length() == 0;
            }
            case 5: {
                throw new IllegalStateException("Not started reading the file yet");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SectionState.values().length];
            try {
                nArray[SectionState.SectionBody.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionState.Start.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionState.EndOfSection.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionState.EOF.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionState.BeginningOfFile.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

