/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanagerv2;

import com.android.sdklib.deviceprovisioner.ActivationAction;
import com.android.sdklib.deviceprovisioner.DeactivationAction;
import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.sdklib.deviceprovisioner.PairDeviceAction;
import com.android.tools.adtui.categorytable.IconButton;
import com.android.tools.idea.devicemanagerv2.ActionButtonsPanel;
import com.android.tools.idea.devicemanagerv2.OverflowButton;
import com.android.tools.idea.devicemanagerv2.StartStopButton;
import com.android.tools.idea.devicemanagerv2.StartStopMirroringButton;
import com.android.tools.idea.devicemanagerv2.WifiPairButton;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/devicemanagerv2/DeviceHandleButtonsPanel;", "Lcom/android/tools/idea/devicemanagerv2/ActionButtonsPanel;", "project", "Lcom/intellij/openapi/project/Project;", "handle", "Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/sdklib/deviceprovisioner/DeviceHandle;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "overflowButton", "Lcom/android/tools/idea/devicemanagerv2/OverflowButton;", "intellij.android.device-manager-v2"})
public final class DeviceHandleButtonsPanel
extends ActionButtonsPanel {
    @Nullable
    private final Project project;
    @NotNull
    private final OverflowButton overflowButton;

    public DeviceHandleButtonsPanel(@Nullable Project project, @NotNull DeviceHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        this.project = project;
        this.overflowButton = new OverflowButton();
        ActivationAction activationAction = handle.getActivationAction();
        DeactivationAction deactivationAction = handle.getDeactivationAction();
        PairDeviceAction wifiPairAction = handle.getWifiPairDeviceAction();
        if (activationAction != null && deactivationAction != null) {
            IconButton[] iconButtonArray = new IconButton[]{new StartStopButton(handle, activationAction, deactivationAction, handle.getRepairDeviceAction()), this.overflowButton};
            this.setUp(iconButtonArray);
        } else if (wifiPairAction != null && this.project != null) {
            IconButton[] iconButtonArray = new IconButton[]{new WifiPairButton(handle, wifiPairAction), this.overflowButton};
            this.setUp(iconButtonArray);
        } else if (this.project == null) {
            IconButton[] iconButtonArray = new IconButton[]{this.overflowButton};
            this.setUp(iconButtonArray);
        } else {
            IconButton[] iconButtonArray = new IconButton[]{new StartStopMirroringButton(handle, this.project), this.overflowButton};
            this.setUp(iconButtonArray);
        }
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }
}

