/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.ui;

import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.tools.adtui.common.AdtUiUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceExplorerPanel {
    private JComboBox myDeviceCombo;
    private JPanel myComponent;
    private JPanel errorPanel;
    private JLabel errorText;
    private JTabbedPane tabPane;

    public DeviceExplorerPanel() {
        this.setupUI();
        this.errorPanel.setBackground(UIUtil.getTreeBackground());
        this.errorText.setFont((Font)AdtUiUtils.EMPTY_TOOL_WINDOW_FONT);
        this.errorText.setForeground(NamedColorUtil.getInactiveTextColor());
        this.errorText.setIconTextGap(16);
    }

    @NotNull
    public JPanel getComponent() {
        return this.myComponent;
    }

    @NotNull
    public JComboBox<DeviceHandle> getDeviceCombo() {
        return this.myDeviceCombo;
    }

    @NotNull
    public JTabbedPane getTabPane() {
        return this.tabPane;
    }

    public void showTabs() {
        this.myDeviceCombo.setVisible(true);
        this.tabPane.setVisible(true);
        this.errorPanel.setVisible(false);
        this.errorText.setText("");
    }

    public void showMessageLayer(@NotNull String message, @Nullable Icon icon, boolean showDeviceList) {
        this.showMessageLayerWorker(message, NamedColorUtil.getInactiveTextColor(), icon, showDeviceList);
    }

    private void showMessageLayerWorker(@NotNull String message, @NotNull Color color, @Nullable Icon icon, boolean showDeviceList) {
        this.errorText.setForeground(color);
        this.errorText.setIcon(icon);
        this.myDeviceCombo.setVisible(showDeviceList);
        String htmlText = String.format("<html><div style='text-align: center;'>%s</div></html>", StringUtil.escapeXml((String)message));
        this.errorText.setText(htmlText);
        this.errorPanel.setVisible(true);
        this.tabPane.setVisible(false);
    }

    private void setupUI() {
        this.myComponent = new JPanel();
        this.myComponent.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 1, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myComponent.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.myDeviceCombo = new JComboBox();
        panel1.add((Component)this.myDeviceCombo, new GridConstraints(0, 0, 1, 1, 8, 1, 5, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myComponent.add((Component)panel2, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.errorPanel = new JPanel();
        this.errorPanel.setLayout(new BorderLayout(0, 0));
        this.errorPanel.setVisible(false);
        panel2.add((Component)this.errorPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.errorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(120, 10, 0, 10), null, 0, 0, null, null));
        this.errorText = new JLabel();
        this.errorText.setHorizontalAlignment(0);
        this.errorText.setHorizontalTextPosition(0);
        this.errorText.setMaximumSize(new Dimension(0, 0));
        this.errorText.setMinimumSize(new Dimension(0, 0));
        this.errorText.setPreferredSize(new Dimension(0, 0));
        this.errorText.setText("");
        this.errorText.setVerticalAlignment(1);
        this.errorText.setVerticalTextPosition(3);
        this.errorPanel.add((Component)this.errorText, "Center");
        this.tabPane = new JTabbedPane();
        panel2.add((Component)this.tabPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
    }
}

