/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files.adbimpl;

import com.android.ddmlib.FileListingService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class AdbPathUtil {
    @NotNull
    public static final String FILE_SEPARATOR = "/";
    @NotNull
    public static final String DEVICE_TEMP_DIRECTORY = "/data/local/tmp";

    @NotNull
    public static String getFileName(@NotNull String path) {
        return path.equals(FILE_SEPARATOR) ? path : PathUtilRt.getFileName((String)path);
    }

    @NotNull
    public static String getParentPath(@NotNull String path) {
        if (StringUtil.isEmpty((String)path)) {
            return "";
        }
        int end = path.lastIndexOf(FILE_SEPARATOR);
        if (end == path.length() - 1) {
            end = path.lastIndexOf(FILE_SEPARATOR, end - 1);
        }
        switch (end) {
            case -1: {
                return "";
            }
            case 0: {
                return FILE_SEPARATOR;
            }
        }
        return path.substring(0, end);
    }

    @NotNull
    public static String resolve(@NotNull String basePath, @NotNull String other) {
        if (AdbPathUtil.isEmpty(other)) {
            return basePath;
        }
        if (AdbPathUtil.isAbsolute(other)) {
            return other;
        }
        if (AdbPathUtil.isSuffixed(basePath)) {
            return basePath + other;
        }
        return basePath + FILE_SEPARATOR + other;
    }

    @NotNull
    public static String getEscapedPath(@NotNull String path) {
        if (FILE_SEPARATOR.equals(path)) {
            return path;
        }
        return AdbPathUtil.getSegments(path).stream().map(x -> FILE_SEPARATOR + FileListingService.FileEntry.escape((String)x)).collect(Collectors.joining());
    }

    @NotNull
    public static @Unmodifiable List<String> getSegments(@NotNull String path) {
        if (StringUtil.isEmpty((String)path) || FILE_SEPARATOR.equals(path)) {
            return new ArrayList<String>();
        }
        return StringUtil.split((String)path, (String)FILE_SEPARATOR);
    }

    private static boolean isEmpty(@NotNull String path) {
        return StringUtil.isEmpty((String)path);
    }

    private static boolean isAbsolute(@NotNull String path) {
        return path.startsWith(FILE_SEPARATOR);
    }

    private static boolean isSuffixed(@NotNull String path) {
        return path.endsWith(FILE_SEPARATOR);
    }
}

