/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files.adbimpl;

import com.android.ddmlib.FileListingService;
import com.android.tools.idea.device.explorer.files.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.device.explorer.files.adbimpl.AdbPathUtil;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"processLsOutputLine", "Lcom/android/tools/idea/device/explorer/files/adbimpl/AdbFileListingEntry;", "line", "", "escaping", "", "parentEntry", "getObjectType", "Lcom/android/tools/idea/device/explorer/files/adbimpl/AdbFileListingEntry$EntryKind;", "permissions", "getName", "result", "Ljava/util/regex/MatchResult;", "intellij.android.device-explorer-files"})
@SourceDebugExtension(value={"SMAP\nAdbFileListing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdbFileListing.kt\ncom/android/tools/idea/device/explorer/files/adbimpl/AdbFileListingKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,257:1\n37#2:258\n36#2,3:259\n*S KotlinDebug\n*F\n+ 1 AdbFileListing.kt\ncom/android/tools/idea/device/explorer/files/adbimpl/AdbFileListingKt\n*L\n209#1:258\n209#1:259,3\n*E\n"})
public final class AdbFileListingKt {
    /*
     * WARNING - void declaration
     */
    private static final AdbFileListingEntry processLsOutputLine(String line, boolean escaping, AdbFileListingEntry parentEntry) {
        if (((CharSequence)line).length() == 0) {
            return null;
        }
        Matcher m = FileListingService.LS_L_PATTERN.matcher(line);
        if (!m.matches()) {
            return null;
        }
        Intrinsics.checkNotNull((Object)m);
        String name2 = AdbFileListingKt.getName(m, escaping);
        if (Intrinsics.areEqual((Object)name2, (Object)".") || Intrinsics.areEqual((Object)name2, (Object)"..")) {
            return null;
        }
        String permissions = m.group(1);
        String owner = m.group(2);
        String group2 = m.group(3);
        String size = m.group(4);
        String date = m.group(5);
        String time2 = m.group(6);
        Object info = null;
        Intrinsics.checkNotNull((Object)permissions);
        AdbFileListingEntry.EntryKind objectType = AdbFileListingKt.getObjectType(permissions);
        if (objectType == AdbFileListingEntry.EntryKind.SYMBOLIC_LINK) {
            void $this$toTypedArray$iv;
            Object object = name2;
            Regex regex = new Regex("\\s->\\s");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] segments = thisCollection$iv.toArray(new String[0]);
            if (segments.length == 2) {
                name2 = segments[0];
                info = segments[1];
            }
            info = "-> " + info;
        }
        String string = AdbPathUtil.resolve(parentEntry.getFullPath(), name2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolve(...)");
        String path = string;
        return new AdbFileListingEntry(path, objectType, permissions, owner, group2, date, time2, size, (String)info);
    }

    private static final AdbFileListingEntry.EntryKind getObjectType(String permissions) {
        AdbFileListingEntry.EntryKind objectType = AdbFileListingEntry.EntryKind.OTHER;
        switch (permissions.charAt(0)) {
            case '-': {
                objectType = AdbFileListingEntry.EntryKind.FILE;
                break;
            }
            case 'b': {
                objectType = AdbFileListingEntry.EntryKind.BLOCK;
                break;
            }
            case 'c': {
                objectType = AdbFileListingEntry.EntryKind.CHARACTER;
                break;
            }
            case 'd': {
                objectType = AdbFileListingEntry.EntryKind.DIRECTORY;
                break;
            }
            case 'l': {
                objectType = AdbFileListingEntry.EntryKind.SYMBOLIC_LINK;
                break;
            }
            case 's': {
                objectType = AdbFileListingEntry.EntryKind.SOCKET;
                break;
            }
            case 'p': {
                objectType = AdbFileListingEntry.EntryKind.FIFO;
            }
        }
        return objectType;
    }

    private static final String getName(MatchResult result2, boolean escaping) {
        String string;
        String name2 = result2.group(7);
        if (escaping) {
            Intrinsics.checkNotNull((Object)name2);
            string = StringsKt.replace$default((String)name2, (String)"\\", (String)"", (boolean)false, (int)4, null);
        } else {
            Intrinsics.checkNotNull((Object)name2);
            string = name2;
        }
        return string;
    }

    public static final /* synthetic */ AdbFileListingEntry access$processLsOutputLine(String line, boolean escaping, AdbFileListingEntry parentEntry) {
        return AdbFileListingKt.processLsOutputLine(line, escaping, parentEntry);
    }

    public static final /* synthetic */ AdbFileListingEntry.EntryKind access$getObjectType(String permissions) {
        return AdbFileListingKt.getObjectType(permissions);
    }
}

