/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.deploy;

import com.android.tools.idea.deploy.DeploymentConfiguration;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class DeploymentConfigurable
implements Configurable,
Configurable.NoScroll {
    private final DeploymentConfiguration myConfiguration = DeploymentConfiguration.getInstance();
    private JPanel myContentPanel;
    private JBCheckBox myRunAfterApplyChanges;
    private JBCheckBox myRunAfterApplyCodeChanges;

    public DeploymentConfigurable() {
        this.setupUI();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return AndroidBundle.message("configurable.DeploymentConfigurable.displayName", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        return this.myConfiguration.APPLY_CHANGES_FALLBACK_TO_RUN != this.myRunAfterApplyChanges.isSelected() || this.myConfiguration.APPLY_CODE_CHANGES_FALLBACK_TO_RUN != this.myRunAfterApplyCodeChanges.isSelected();
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.APPLY_CHANGES_FALLBACK_TO_RUN = this.myRunAfterApplyChanges.isSelected();
        this.myConfiguration.APPLY_CODE_CHANGES_FALLBACK_TO_RUN = this.myRunAfterApplyCodeChanges.isSelected();
    }

    public void reset() {
        this.myRunAfterApplyChanges.setSelected(this.myConfiguration.APPLY_CHANGES_FALLBACK_TO_RUN);
        this.myRunAfterApplyCodeChanges.setSelected(this.myConfiguration.APPLY_CODE_CHANGES_FALLBACK_TO_RUN);
    }

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myContentPanel.add((Component)spacer1, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myRunAfterApplyChanges = new JBCheckBox();
        this.myRunAfterApplyChanges.setText("Automatically perform \"Run\" when Apply Changes fails");
        this.myContentPanel.add((Component)this.myRunAfterApplyChanges, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.myRunAfterApplyCodeChanges = new JBCheckBox();
        this.myRunAfterApplyCodeChanges.setText("Automatically perform \"Run\" when Apply Code Changes fails");
        this.myContentPanel.add((Component)this.myRunAfterApplyCodeChanges, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Enabling these options trigger an automatic rerun of your app only if there is an incompatible change when using Apply Changes.");
        this.myContentPanel.add((Component)jBLabel1, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("In some cases, when Apply Changes or Apply Code Changes succeeds, you might need to manually restart your app to see your changes.");
        this.myContentPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("For example, to see changes you made in your Activity's onCreate() method.");
        this.myContentPanel.add((Component)jBLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }
}

