/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.tree.render.CustomPopupFullValueEvaluator;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.ui.Messages;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\f\u0010\r\u001a\u00020\u0006*\u00020\u0006H\u0002J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u0006*\u00020\u0006H\u0002J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0006H\u0002J\f\u0010\u0015\u001a\u00020\u0011*\u00020\u0006H\u0002J\u0014\u0010\u0016\u001a\u00020\u0011*\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/debug/BitmapPopupEvaluatorV2;", "Lcom/intellij/debugger/ui/tree/render/CustomPopupFullValueEvaluator;", "Lcom/android/tools/idea/debug/BitmapPopupEvaluatorV2$ImageResult;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "value", "Lcom/sun/jdi/ObjectReference;", "<init>", "(Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;Lcom/sun/jdi/ObjectReference;)V", "getData", "createComponent", "Ljavax/swing/JComponent;", "data", "getBitmap", "getBitmapFromDrawable", "getPixels", "", "", "width", "height", "getWidth", "getHeight", "getInt", "methodName", "", "ImageResult", "intellij.android.debuggers"})
@SourceDebugExtension(value={"SMAP\nBitmapPopupEvaluatorV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapPopupEvaluatorV2.kt\ncom/android/tools/idea/debug/BitmapPopupEvaluatorV2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1563#2:134\n1634#2,3:135\n*S KotlinDebug\n*F\n+ 1 BitmapPopupEvaluatorV2.kt\ncom/android/tools/idea/debug/BitmapPopupEvaluatorV2\n*L\n114#1:134\n114#1:135,3\n*E\n"})
public final class BitmapPopupEvaluatorV2
extends CustomPopupFullValueEvaluator<ImageResult> {
    @NotNull
    private final EvaluationContextImpl evaluationContext;
    @NotNull
    private final ObjectReference value;

    public BitmapPopupEvaluatorV2(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference value2) {
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        super("\u2026 View Bitmap", evaluationContext);
        this.evaluationContext = evaluationContext;
        this.value = value2;
    }

    @NotNull
    protected ImageResult getData() {
        ImageResult imageResult;
        try {
            ObjectReference bitmap = this.getBitmap(this.value);
            int width = this.getWidth(bitmap);
            int height = this.getHeight(bitmap);
            List<Integer> pixels = this.getPixels(bitmap, width, height);
            BufferedImage image = new BufferedImage(width, height, 2);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int argb = ((Number)pixels.get(x + y * width)).intValue();
                    image.setRGB(x, y, argb);
                }
            }
            imageResult = new ImageResult.Success(image);
        }
        catch (Exception e) {
            ActionsKt.invokeLater$default(null, () -> BitmapPopupEvaluatorV2.getData$lambda$0(e), (int)1, null);
            imageResult = ImageResult.Error.INSTANCE;
        }
        return imageResult;
    }

    @NotNull
    protected JComponent createComponent(@NotNull ImageResult data2) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        ImageResult imageResult = data2;
        if (imageResult instanceof ImageResult.Success) {
            ImageEditorUI imageEditorUI = ImageEditorManagerImpl.createImageEditorUI((BufferedImage)((ImageResult.Success)data2).getImage());
            Intrinsics.checkNotNullExpressionValue((Object)imageEditorUI, (String)"createImageEditorUI(...)");
            jComponent = (JComponent)imageEditorUI;
        } else if (Intrinsics.areEqual((Object)imageResult, (Object)ImageResult.Error.INSTANCE)) {
            jComponent = new JLabel("Unexpected error while obtaining image", Messages.getErrorIcon(), 0);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jComponent;
    }

    private final ObjectReference getBitmap(ObjectReference $this$getBitmap) {
        ObjectReference objectReference;
        String fqcn;
        String string = $this$getBitmap.type().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        String string2 = fqcn = string;
        if (Intrinsics.areEqual((Object)string2, (Object)"android.graphics.Bitmap")) {
            objectReference = $this$getBitmap;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"android.graphics.drawable.BitmapDrawable")) {
            objectReference = this.getBitmapFromDrawable($this$getBitmap);
            if (objectReference == null) {
                throw new RuntimeException("Unable to obtain bitmap from drawable");
            }
        } else {
            throw new RuntimeException("Invalid parameter passed into method");
        }
        return objectReference;
    }

    private final ObjectReference getBitmapFromDrawable(ObjectReference $this$getBitmapFromDrawable) {
        ObjectReference objectReference;
        try {
            Method method2 = DebuggerUtils.findMethod((ReferenceType)$this$getBitmapFromDrawable.referenceType(), (String)"getBitmap", (String)"()Landroid/graphics/Bitmap;");
            if (method2 == null) {
                return null;
            }
            Method method3 = method2;
            Value value2 = this.evaluationContext.getDebugProcess().invokeMethod((EvaluationContext)this.evaluationContext, $this$getBitmapFromDrawable, method3, CollectionsKt.emptyList());
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            objectReference = (ObjectReference)value2;
        }
        catch (EvaluateException ignored) {
            objectReference = null;
        }
        return objectReference;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getPixels(ObjectReference $this$getPixels, int width, int height) {
        void $this$mapTo$iv$iv;
        Method method2 = DebuggerUtils.findMethod((ReferenceType)$this$getPixels.referenceType(), (String)"getPixels", (String)"([IIIIIII)V");
        if (method2 == null) {
            throw new RuntimeException("Method getPixels not found in " + $this$getPixels.type().name());
        }
        Method method3 = method2;
        VirtualMachine vm = $this$getPixels.virtualMachine();
        List<ReferenceType> list = vm.classesByName("int[]");
        Intrinsics.checkNotNullExpressionValue(list, (String)"classesByName(...)");
        Object object = CollectionsKt.first(list);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.sun.jdi.ArrayType");
        ArrayType intArrayType = (ArrayType)object;
        ArrayReference pixels = intArrayType.newInstance(width * height);
        IntegerValue offset = vm.mirrorOf(0);
        IntegerValue stride = vm.mirrorOf(width);
        IntegerValue x = vm.mirrorOf(0);
        IntegerValue y = vm.mirrorOf(0);
        Object[] objectArray = new Value[]{pixels, offset, stride, x, y, vm.mirrorOf(width), vm.mirrorOf(height)};
        List args = CollectionsKt.listOf((Object[])objectArray);
        this.evaluationContext.getDebugProcess().invokeMethod((EvaluationContext)this.evaluationContext, $this$getPixels, method3, args);
        List<Value> list2 = pixels.getValues();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValues(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Value value2 = (Value)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.sun.jdi.IntegerValue");
            collection2.add(((IntegerValue)it).value());
        }
        return (List)destination$iv$iv;
    }

    private final int getWidth(ObjectReference $this$getWidth) {
        return this.getInt($this$getWidth, "getWidth");
    }

    private final int getHeight(ObjectReference $this$getHeight) {
        return this.getInt($this$getHeight, "getHeight");
    }

    private final int getInt(ObjectReference $this$getInt, String methodName) {
        Method method2 = DebuggerUtils.findMethod((ReferenceType)$this$getInt.referenceType(), (String)methodName, (String)"()I");
        if (method2 == null) {
            throw new RuntimeException("Method " + methodName + " not found in " + $this$getInt.type().name());
        }
        Method method3 = method2;
        Value value2 = this.evaluationContext.getDebugProcess().invokeMethod((EvaluationContext)this.evaluationContext, $this$getInt, method3, CollectionsKt.emptyList());
        Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type com.sun.jdi.IntegerValue");
        IntegerValue value3 = (IntegerValue)value2;
        return value3.value();
    }

    private static final Unit getData$lambda$0(Exception $e) {
        throw new RuntimeException("Unexpected error while obtaining image", $e);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/debug/BitmapPopupEvaluatorV2$ImageResult;", "", "<init>", "()V", "Success", "Error", "Lcom/android/tools/idea/debug/BitmapPopupEvaluatorV2$ImageResult$Error;", "Lcom/android/tools/idea/debug/BitmapPopupEvaluatorV2$ImageResult$Success;", "intellij.android.debuggers"})
    public static abstract sealed class ImageResult {
        private ImageResult() {
        }

        public /* synthetic */ ImageResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/idea/debug/BitmapPopupEvaluatorV2$ImageResult$Error;", "Lcom/android/tools/idea/debug/BitmapPopupEvaluatorV2$ImageResult;", "<init>", "()V", "intellij.android.debuggers"})
        public static final class Error
        extends ImageResult {
            @NotNull
            public static final Error INSTANCE = new Error();

            private Error() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/debug/BitmapPopupEvaluatorV2$ImageResult$Success;", "Lcom/android/tools/idea/debug/BitmapPopupEvaluatorV2$ImageResult;", "image", "Ljava/awt/image/BufferedImage;", "<init>", "(Ljava/awt/image/BufferedImage;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "intellij.android.debuggers"})
        public static final class Success
        extends ImageResult {
            @NotNull
            private final BufferedImage image;

            public Success(@NotNull BufferedImage image) {
                Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                super(null);
                this.image = image;
            }

            @NotNull
            public final BufferedImage getImage() {
                return this.image;
            }
        }
    }
}

