/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.configurations.ConfigurationModelModule;
import com.android.tools.configurations.ThemeInfoProvider;
import com.android.tools.idea.configurations.StudioThemeInfoProvider;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.module.ModuleKeyManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.StudioLayoutlibContext;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.layoutlib.LayoutlibContext;
import com.android.tools.module.AndroidModuleInfo;
import com.android.tools.module.ModuleDependencies;
import com.android.tools.module.ModuleKey;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0016\u00100\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u001f\u00a8\u00062"}, d2={"Lcom/android/tools/idea/configurations/StudioConfigurationModelModule;", "Lcom/android/tools/configurations/ConfigurationModelModule;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "androidPlatform", "Lcom/android/tools/sdk/AndroidPlatform;", "getAndroidPlatform", "()Lcom/android/tools/sdk/AndroidPlatform;", "resourceRepositoryManager", "Lcom/android/tools/res/ResourceRepositoryManager;", "getResourceRepositoryManager", "()Lcom/android/tools/res/ResourceRepositoryManager;", "themeInfoProvider", "Lcom/android/tools/configurations/ThemeInfoProvider;", "getThemeInfoProvider", "()Lcom/android/tools/configurations/ThemeInfoProvider;", "androidModuleInfo", "Lcom/android/tools/module/AndroidModuleInfo;", "getAndroidModuleInfo", "()Lcom/android/tools/module/AndroidModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "name", "", "getName", "()Ljava/lang/String;", "layoutlibContext", "Lcom/android/tools/layoutlib/LayoutlibContext;", "getLayoutlibContext", "()Lcom/android/tools/layoutlib/LayoutlibContext;", "dependencies", "Lcom/android/tools/module/ModuleDependencies;", "getDependencies", "()Lcom/android/tools/module/ModuleDependencies;", "getCompatibilityTarget", "Lcom/android/tools/sdk/CompatibilityRenderTarget;", "target", "Lcom/android/sdklib/IAndroidTarget;", "moduleKey", "Lcom/android/tools/module/ModuleKey;", "getModuleKey", "()Lcom/android/tools/module/ModuleKey;", "resourcePackage", "getResourcePackage", "intellij.android.core"})
public final class StudioConfigurationModelModule
implements ConfigurationModelModule {
    @NotNull
    private final Module module;
    @NotNull
    private final ThemeInfoProvider themeInfoProvider;
    @Nullable
    private final AndroidModuleInfo androidModuleInfo;
    @NotNull
    private final Project project;
    @NotNull
    private final String name;
    @NotNull
    private final LayoutlibContext layoutlibContext;
    @NotNull
    private final ModuleDependencies dependencies;

    public StudioConfigurationModelModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        this.themeInfoProvider = new StudioThemeInfoProvider(this.module);
        this.androidModuleInfo = StudioAndroidModuleInfo.getInstance(this.module);
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        String string = this.module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.name = string;
        Project project2 = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.layoutlibContext = new StudioLayoutlibContext(project2);
        this.dependencies = ProjectSystemUtil.getModuleSystem(this.module).getModuleDependencies();
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @Override
    @Nullable
    public AndroidPlatform getAndroidPlatform() {
        return AndroidPlatforms.getInstance(this.module);
    }

    @Override
    @Nullable
    public ResourceRepositoryManager getResourceRepositoryManager() {
        return StudioResourceRepositoryManager.getInstance(this.module);
    }

    @Override
    @NotNull
    public ThemeInfoProvider getThemeInfoProvider() {
        return this.themeInfoProvider;
    }

    @Override
    @Nullable
    public AndroidModuleInfo getAndroidModuleInfo() {
        return this.androidModuleInfo;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public LayoutlibContext getLayoutlibContext() {
        return this.layoutlibContext;
    }

    @Override
    @NotNull
    public ModuleDependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    @NotNull
    public CompatibilityRenderTarget getCompatibilityTarget(@NotNull IAndroidTarget target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        return StudioEmbeddedRenderTarget.Companion.getCompatibilityTarget(target2);
    }

    @Override
    @NotNull
    public ModuleKey getModuleKey() {
        return ModuleKeyManager.INSTANCE.getKey(this.module);
    }

    @Override
    @Nullable
    public String getResourcePackage() {
        return ProjectSystemUtil.getModuleSystem(this.module).getPackageName();
    }
}

